/*
 * Hardware tuning for the UMC 8891A bridge. */

#include "8891A.h"

#define UMC_8891A_TWEAKSIZE (sizeof(UMC_8891A_Tweaks)/sizeof(Tweaks_t))-1

unsigned int getnumtweaks_UMC_8891A(struct pci_dev *current_dev)
{
	return UMC_8891A_TWEAKSIZE;
}

void init_UMC_8891A(struct pci_dev *current_dev)
{
	init_tweaks(UMC_8891A_TWEAKSIZE, UMC_8891A_Tweaks, current_dev);
}

void tune_UMC_8891A(GtkWidget *table, struct pci_dev *current_dev, unsigned int numbuttons)
{
	Tweaks_t *Tweaks;

	unsigned int index;
	int column=0;

	Tweaks = UMC_8891A_Tweaks;

	for (index=0;index<numbuttons;index++) {
		CreateButton(table, Tweaks, current_dev, column);
		column++;
		Tweaks++;
	}
}

void save_UMC_8891A(FILE *savehandle, struct pci_dev *current_dev)
{
	write_tweaks(savehandle, UMC_8891A_TWEAKSIZE, UMC_8891A_Tweaks, current_dev);
}
