/*
 * Copyright (c) 2000 Dave Jones <dave@powertweak.com>
 *
 * Can be freely distributed and used under the terms of the GNU GPL.
 */

/* AMD-specific information */
void Decode_AMD(void)
{
	unsigned int eax,ebx,ecx,edx;

	if (cpu0_data.MaxCPUID >= 1) {
		cpuid(1, &eax,&ebx,&ecx,&edx);

		cpu0_data.stepping = eax & 0xf;
		cpu0_data.model = (eax >> 4) & 0xf;
		cpu0_data.family = (eax >> 8) & 0xf;
	}

	if (cpu0_data.MaxCPUID >= 1) {
		cpuid (0x80000005, &eax,&ebx,&ecx,&edx);

		cpu0_data.ITLB_entries = ebx & 0xff;
		cpu0_data.ITLB_assoc = (ebx>>8) & 0xff;
		cpu0_data.DTLB_entries = (ebx>>16) & 0xff;
		cpu0_data.DTLB_assoc = (ebx>>24) & 0xff;

		cpu0_data.DCACHE_linesize = ecx & 0xff;
		cpu0_data.DCACHE_linespertag = (ecx>>8) & 0xff;
		cpu0_data.DCACHE_assoc = (ecx>>16) & 0xff;
		cpu0_data.DCACHE_size = (ecx>>24) & 0xff;

		cpu0_data.ICACHE_linesize = edx & 0xff;
		cpu0_data.ICACHE_linespertag = (edx>>8) & 0xff;
		cpu0_data.ICACHE_assoc = (edx>>16) & 0xff;
		cpu0_data.ICACHE_size = (edx>>24) & 0xff;
	}
}
