/*
 * NcdT -- directory tree printer with extended capabilities
 * (C) 1999 by Pawel Wiecek <coven@vmh.net>
 * See Copying file for licence.
 * 
 * Main code
 */

#include <stdio.h>
#include <sys/stat.h>
#include <string.h>
#include <dirent.h>
#include <stdlib.h>
#include "ncdt.h"

struct TREE *root;

int main(int argc, char *argv[]) {
 char *rootname, *title;
 unsigned long tt;

 if((argc==2)&&(!strcmp(argv[1],"--help"))) {
  fprintf(stderr,"NcdT 1.5 -- simple format tree with extended "
	  "capabilities\n\nUsage:\n  ncdt\t\t\t\t- shows directory tree "
	  "rooted on current\n\t\t\t\t  directory (.)\n  ncdt "
	  "<directory>\t\t- shows directory tree rooted on <directory>\n  "
	  "ncdt <directory> <name>\t- shows directory tree rooted on "
	  "<directory>\n\t\t\t\t  using <name> for root name (instead "
	  "of\n\t\t\t\t  default <directory>)\n  ncdt --help\t\t   - "
	  "displays this short help\n\nAdditional capabilities not found "
	  "in standard tree are:\n - size field for directories displays "
	  "the summary size of directory\n   subtree instead of the size of "
	  "the special file\n - sizes are displayed in a more readable "
	  "format\n - MP3 files are detected; additional info is displayed "
	  "for them\n\n");
  return 0;
 }
 if(argc>1) rootname=argv[1];
       else rootname=".";
 if(argc>2) title=argv[2];
       else title=rootname;
 root=malloc(sizeof(struct TREE));
 root->name=strdup(title);
 root->len=0;
 t_scan(root,rootname);
 t_fix(root,&tt);
 t_print(root,"");
 t_free(root);
 return 0;
}

void t_scan(struct TREE *t, char *r) {
 DIR *dir;
 struct dirent *ent;
 struct stat st;
 char buf[4096];
 int m=0;
 struct TREE *p=NULL;

 dir=opendir(r);
 if(!dir) return;
 while((ent=readdir(dir))) {
  if(!strcmp(ent->d_name,".")||!strcmp(ent->d_name,"..")) continue;
  if(m) p=p->brother=malloc(sizeof(struct TREE));
   else p=t->son=malloc(sizeof(struct TREE));
  m=1;
  p->name=strdup(ent->d_name);
  sprintf(buf,"%s/%s",r,ent->d_name);
  p->son=NULL;
  lstat(buf,&st);
  p->len=st.st_size;
  p->time=0;
  if(st.st_mode&S_IFDIR) {
   t_scan(p,buf);
  } else {
   if((st.st_mode&S_IFREG)&&(endswith(ent->d_name,".mp3")
			   ||endswith(ent->d_name,".MP3")))
    mp3info(buf,p);
  }
 }
 if(p) p->brother=NULL;
 closedir(dir);
}

int t_fix(struct TREE *t, unsigned long *tim) {
 unsigned long len;
 
 if(t->son)
  t->len=t_fix(t->son,&t->time);
 if(t->brother) {
  len=t->len+t_fix(t->brother,tim);
  *tim+=t->time;
  return len;
 } else {
  *tim+=t->time;
  return t->len;
 }
}

void t_print(struct TREE *t, char *pref) {
 char npref[256];
 
 if(t->son&&t->time) {
  sprintf(npref,"  <%s>",nicetime(t->time));
  t->name=realloc(t->name,strlen(t->name)+strlen(npref)+1);
  strcat(t->name,npref);
 }
 printf("%s%c-- [%11s] %s\n",pref,t->brother?'|':'`',nicenum(t->len),t->name);
 if(t->son) {
  sprintf(npref,"%s%c  ",pref,t->brother?'|':' ');
  t_print(t->son,npref);
 }
 if(t->brother) t_print(t->brother,pref);
}

void t_free(struct TREE *t) {
 if(t->son) t_free(t->son);
 if(t->brother) t_free(t->brother);
 free(t->name);
 free(t);
}
