/*
 * dnode3.c - Pyramid DC/OSx and Reliant UNIX node functions for lsof
 *
 * This module must be separate to keep separate the multiple kernel inode
 * structure definitions.
 */

/*
 * Copyright 1999 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1999 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dnode3.c,v 1.2 99/02/25 20:01:37 abe Exp $";
#endif


#include "lsof.h"


/*
 * bsock (socket) socket structure addressed by v_data
 */

struct bsock {
	int d1[3];
	void *pcb;			/* protocol control block address */
	void *proto;			/* protocol switch address */
	void *d2[2];
	int d3;
	void *d4;
	short d5[2];
	int (*d6)();
	int d7;
	long d9;
	struct bsbf {			/* buffer controls */
	    u_int cc;			/* character count */
	    u_int d10[4];
	    int d11;
	    void *d12[3];
	    int d13;
	    void (*d14)();
	    int d15[5];
	    void *d16;
	    void (*d17)();
	} rcv, snd;
};


/*
 * process_bsdsock - process a BSD socket file node
 */

int
process_bsdsock(na, vp)
	KA_T *na;			/* vnode kernel address */
	struct vnode *vp;		/* address of local copy of vnode */
{
	struct bsdsnode bn;
	int fam;
	KA_T la;
	char *pr;
	struct protosw p;
	struct vnode rv;
	struct bsock s;
	SZOFFTYPE sz;
	char tbuf[32];
/*
 * Get the real vnode address from the extended vnode -- i.e., the msockfs
 * node.  Read the real vnode.  If it has a stream pointer, return it to the
 * caller to deal with as a stream.  If it has no stream pointer, its  v_data
 * pointer addresses a bsock (socket) structure.
 */
	if (!(la = *na) || kread(la, (char *)&bn, sizeof(bn))) {
	    (void) sprintf(Namech, "vnode@%s: can't bsdsnode",
		print_kptr(la, tbuf));
	    enter_nm(Namech);
	    return(1);
	}
	if (!bn.bn_realvp
	||  kread((KA_T)bn.bn_realvp, (char *)&rv, sizeof(rv))) {
	    (void) sprintf(Namech, "bsdsnode@%s: can't read real vnode@%s",
		print_kptr(la, tbuf),
		print_kptr((KA_T)bn.bn_realvp, (char *)NULL));
	    enter_nm(Namech);
	    return(1);
	}
	if (rv.v_stream) {
	    *na = (KA_T)bn.bn_realvp;
	    *vp = rv;
	    return(0);
	}
	vp = &rv;
/*
 * Read the bsock (socket) structure to which v_data points.
 */
	if (!vp->v_data
	||  kread((KA_T)vp->v_data, (char *)&s, sizeof(s))) {
	    (void) sprintf(Namech,
		"bsdsnode real vnode@%s: can't read socket@%s",
		print_kptr((KA_T)bn.bn_realvp, tbuf),
		print_kptr((KA_T)vp->v_data, (char *)NULL));
	    enter_nm(Namech);
	    return(1);
	}
/*
 * Read the bsock's (socket's) protocol switch and domain family.
 */
	if (!s.proto
	||  kread((KA_T)s.proto, (char *)&p, sizeof(p))) {
	    (void) sprintf(Namech, "socket@%s: can't read protosw@%s",
		print_kptr((KA_T)vp->v_data, tbuf),
		print_kptr((KA_T)s.proto, (char *)NULL));
	    enter_nm(Namech);
	    return(1);
	}
	if (!p.pr_domain
	||  kread((KA_T)p.pr_domain, (char *)&fam, sizeof(fam))) {
	    (void) sprintf(Namech, "protosw@%s: can't read domain family@%s",
		print_kptr((KA_T)s.proto, tbuf),
		print_kptr((KA_T)p.pr_domain, (char *)NULL));
	    enter_nm(Namech);
	    return(1);
	}
/*
 * Process socket according to its domain.
 */
	switch (fam) {

	/*
	 * Process an AF_INET socket.
	 */

	case AF_INET:
	    switch (p.pr_protocol) {
	    case IPPROTO_TCP:
		pr = "TCP";
		break;
	    case IPPROTO_UDP:
		pr = "UDP";
		break;
	    default:
		(void) sprintf(Namech,
		    "socket@%s has unknown protocol: %d",
		    print_kptr((KA_T)vp->v_data, (char *)NULL),
		    (int)p.pr_protocol);
		enter_nm(Namech);
		return(1);
	    }
	    if (Lf->access == 'r')
		sz = (SZOFFTYPE)s.rcv.cc;
	    else if (Lf->access == 'w')
		sz = (SZOFFTYPE)s.snd.cc;
	    else
		sz = (SZOFFTYPE)(s.rcv.cc + s.snd.cc);
	    process_socket(pr, (KA_T)s.pcb, sz);
	    return(1);
	default:
	    (void) sprintf(Namech, "socket@%s: unknown address family: %d",
		print_kptr((KA_T)vp->v_data, (char *)NULL), fam);
	    enter_nm(Namech);
	}
	return(1);
}
