/*
 * dfile.c - Linux file processing functions for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1994 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dfile.c,v 1.10 99/06/22 08:18:25 abe Exp $";
#endif


#include "lsof.h"


/*
 * process_file() - process file
 */

void
process_file(fp)
	KA_T fp;		/* kernel file structure address */
{

#if	defined(HASDENTRY)
	struct dentry de;
#endif	/* defined(HASDENTRY) */

	int flag;

	Lf->off = (SZOFFTYPE)((struct file *)fp)->f_pos;
	if (((struct file *)fp)->f_count) {

#if	defined(HASFSTRUCT)
	/*
	 * Save file structure values.
	 */
	    if (Fsv & FSV_CT) {
		Lf->fct = (long)(((struct file *)fp)->f_count);
		Lf->fsv |= FSV_CT;
	    }
	    if (Fsv & FSV_FA) {
		Lf->fsa = (KA_T)Cfp;
		Lf->fsv |= FSV_FA;
	    }
	    if (Fsv & FSV_FG) {
		Lf->ffg = (long)((((struct file *)fp)->f_flags & ~3)
			|        (((struct file *)fp)->f_mode  &  3));
		Lf->fsv |= FSV_FG;
	    }
#endif	/* defined(HASFSTRUCT) */

	/*
	 * Construct access code.
	 */
	    if ((flag = (((struct file *)fp)->f_mode & 3)) == 1)
		Lf->access = 'r';
	    else if (flag == 2)
		Lf->access = 'w';
	    else if (flag == 3)
		Lf->access = 'u';
	/*
	 * Process inode.
	 */

#if	defined(HASDENTRY)
		if (((struct file *)fp)->f_dentry
		&&  !kread((KA_T)((struct file *)fp)->f_dentry, (char *)&de,
		     sizeof(de))
		&&  de.d_inode) {

# if	defined(HASFSTRUCT)
		    if (Fsv & FSV_NI) {
			Lf->fna = (KA_T)de.d_inode;
			Lf->fsv |= FSV_NI;
		    }
# endif	/* defined(HASFSTRUCT) */
		    process_inode(de.d_inode, ((struct file *)fp)->f_op);
		    return;
		}
#else	/* !defined(HASDENTRY) */
		if (((struct file *)fp)->f_inode) {
# if	defined(HASFSTRUCT)
		    if (Fsv & FSV_NI) {
			Lf->fna = (KA_T)(((struct file *)fp)->f_inode);
			Lf->fsv |= FSV_NI;
		    }
# endif	/* defined(HASFSTRUCT) */
		    process_inode(((struct file *)fp)->f_inode,
			((struct file *)fp)->f_op);
		    return;
		}
#endif	/* defined(HASDENTRY) */

	}
	enter_nm("no more information");
}
