
/*----------------------------------------------------------------------------*

	LinuxInfo_common.c - common functions 
		by Alex Buell
			September 1998

 ----------------------------------------------------------------------------- 

	Derived from Vince Weaver's Linux Logo 2.10	

 ----------------------------------------------------------------------------- 

	HISTORY

	1.0.1 - Initial Development
	1.0.2 - Modifications to enable libc5 & glibc2 compatiblity.
	1.0.3 - Bug fix for glibc-2.0.x (not glibc-2.0.9x - works fine).
	1.0.4 - Gave up in disgust and used a clever hack :o) Sit back and
		admire the elegance of this code!

 -----------------------------------------------------------------------------*/

#include "linuxinfo.h"

void GetOperatingSystemInfo(struct os_stat *os)
{
#ifndef system_unknown
	struct utsname buf;
	uname(&buf);

	strcpy(os->os_hostname, buf.nodename);
	strcpy(os->os_name, buf.sysname);
	strcpy(os->os_version, buf.release);
	strcpy(os->os_revision, buf.version);
#else
	strcpy(os->os_hostname, "Unknown");
	strcpy(os->os_name, "Unknown");
	strcpy(os->os_version, "Unknown");
	strcpy(os->os_revision, "Unknown");
#endif /* system_unknown */
}

/* Really neat hack to detect all libraries known on Linux */
#ifndef system_unknown
asm (".weak gnu_get_libc_version");
asm (".weak __libc_version");
asm (".weak __linux_C_lib_version");

extern char *gnu_get_libc_version (void);
extern char *__linux_C_lib_version;
extern char __libc_version [];
#endif /* only define if on a Linux system :o) */

void GetSystemLibcInfo(struct lib_stat *lib)
{
	int libc_major = 0, libc_minor = 0, libc_teeny = 0;
	char *ptr;

	/* initialise to unknown */
	strcpy(lib->lib_version, "Unknown");

#ifndef system_unknown
	if (gnu_get_libc_version != 0)
        {
		ptr = gnu_get_libc_version();
        }
        else if (&__libc_version != 0)
        {
		ptr = __libc_version;
        }
        else
        	ptr = __linux_C_lib_version;

        while (!isdigit (*ptr))
	        ptr++;

        sscanf (ptr, "%d.%d.%d", &libc_major, &libc_minor, &libc_teeny);
	sprintf(lib->lib_version, "%d.%d.%d", libc_major, libc_minor, libc_teeny);
#endif /* system_unknown */
}

char *GetStringFromFile(FILE *infile, char *str)
{
	int ch, i = 0;
	char temp[BUFSIZ];

	strcpy(temp, "");

	while ((ch = fgetc(infile)) == ' ');

	while ((ch != '\n') && (ch != EOF)) 
	{
		temp[i] = ch; 
		i++;
		ch = fgetc(infile);
	}

	if (ch == EOF)
		return NULL;

	temp[i] = '\0';

	strcpy(str, temp);

	return(str);
}

int splitstring(char *first_string, char *second_string)
{
	char *p;

	p = strchr(first_string, ':');
	if (!p)
		return 0;

	*(p-1) = '\0', p++; 
	while (isspace(*p)) p++;
	strcpy(second_string, p);
}
