/* lib.c - MemTest-86  Version 2.2
 *
 * Copyright 1999,  Chris Brady
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without fee
 * is granted provided that the above copyright notice appears in all copies.
 * It is provided "as is" without express or implied warranty.
 */
#include "io.h"
#include "serial.h"
#include "test.h"

extern void do_test();
extern int bail;
extern struct vars *v;
extern struct tseq tseq[];

int slock = 0, lsr = 0;
char save[POP_H][POP_W];
char buf[18];

char *codes[] = {
	"  Divide",
	"   Debug",
	"     NMI",
	"  Brkpnt",
	"Overflow",
	"   Bound",
	"  Inv_Op",
	" No_Math",
	"Double_Fault",
	"Seg_Over",
	" Inv_TSS",
	"  Seg_NP",
	"Stack_Fault",
	"Gen_Prot",
	"Page_Fault",
	"   Resvd",
	"     FPE",
	"Alignment",
	" Mch_Chk",
};

/*
 * Scroll the error message area of the screen
 * Starts at line LINE_SCROLL and ends at line 24
 */
void scroll() {
	int i, j;
	char *s;
        for (i=LINE_SCROLL; i<=22; i++) {
		s = (char *)(SCREEN_ADR + ((i+1) * 160));
                for (j=0; j<160; j++, s++) {
			*(s-160) = *s;
		}
	}
}

/*
 * Print characters on screen
 */
void cprint(int y, int x, char *text)
{
	register int i;
	char *dptr;

	dptr = (char *)(SCREEN_ADR + (160*y) + (2*x));
	for (i=0; text[i]; i++) {
		*dptr = text[i];
		dptr += 2;
	}
	ttyprint(y,x,text);
}

void itoa(char s[], int n) 
{
  int i, sign;

  if((sign = n) < 0)
    n = -n;
  i=0;
  do {
    s[i++] = n % 10 + '0';
  } while ((n /= 10) > 0);
  if(sign < 0)
    s[i++] = '-';
  s[i] = '\0';
  reverse(s);
}

void reverse(char s[])
{
  int c, i, j;

  for(i=0, j = strlen(s) -1; i < j; i++, j--) {
    c = s[i];
    s[i] = s[j];
    s[j] = c;
  }
}

void ttyprintc(int y, int x, char c)
{
  static char cbuf[2];

  cbuf[0] = c;
  cbuf[1] = '\0';
  ttyprint(y,x,cbuf);
}


void ttyprint(int y, int x, char *p)
{
       static char sx[3];
       static char sy[3];

       sx[0]='\0';
       sy[0]='\0';
       x++; y++;
       itoa(sx, x);
       itoa(sy, y);
       serial_echo_print("[");
       serial_echo_print(sy);
       serial_echo_print(";");
       serial_echo_print(sx);
       serial_echo_print("H");
       serial_echo_print(p);
}

void serial_echo_init()
{
	int comstat, hi, lo;
	
	/* read the Divisor Latch */
	comstat = serial_echo_inb(UART_LCR);
	serial_echo_outb(comstat | UART_LCR_DLAB, UART_LCR);
	hi = serial_echo_inb(UART_DLM);
	lo = serial_echo_inb(UART_DLL);
	serial_echo_outb(comstat, UART_LCR);

	/* now do hardwired init */
	serial_echo_outb(0x03, UART_LCR); /* No parity, 8 data bits, 1 stop */
	serial_echo_outb(0x83, UART_LCR); /* Access divisor latch */
	serial_echo_outb(0x00, UART_DLM); /* 9600 baud */
	serial_echo_outb(0x0c, UART_DLL);
	serial_echo_outb(0x03, UART_LCR); /* Done with divisor */

	/* Prior to disabling interrupts, read the LSR and RBR
	 * registers */
	comstat = serial_echo_inb(UART_LSR); /* COM? LSR */
	comstat = serial_echo_inb(UART_RX);	/* COM? RBR */
	serial_echo_outb(0x00, UART_IER); /* Disable all interrupts */

	return;
}

void serial_echo_print(char *p)
{
  /* Now, do each character */
  while (*p) {
    WAIT_FOR_XMITR;

    /* Send the character out. */
    serial_echo_outb(*p, UART_TX);
    if(*p==10) {
      WAIT_FOR_XMITR;
      serial_echo_outb(13, UART_TX);
    }
    p++;
  }
}
/*
 * Print a people friendly address
 */
void aprint(int y, int x, unsigned long val)
{
	if (val < 10000) {
		dprint(y, x, val, 5, 0);
	} else if (val < 1024*9999) {
		dprint(y, x, val/1024, 4, 0);
		cprint(y, x+4, "k");
	} else {
		dprint(y, x, val/(1024*1024), 4, 0);
		cprint(y, x+4, "m");
	}
}

/*
 * Print a decimal number on screen
 */
void dprint(int y, int x, unsigned long val, int len, int right)
{
	unsigned long j, k;
	int i, flag=0;

	for(i=0, j=1; i<len-1; i++) {
	j *= 10;
	}
	if (!right) {
		for (i=0; j>0; j/=10) {
			k = val/j;
			if (k > 9) {
				j *= 100;
				continue;
			}
			if (flag || k || j == 1) {
				buf[i++] = k + '0';
				flag++;
			} else {
				buf[i++] = ' ';
			}
			val -= k * j;
		}
	} else {
		for(i=0; i<len; j/=10) {
			if (j) {
				k = val/j;
					if (k > 9) {
					j *= 100;
					len++;
					continue;
				}
				if (k == 0 && flag == 0) {
					continue;				
				}
				buf[i++] = k + '0';
				val -= k * j;
			} else {
                                if (flag == 0 &&  i < len-1) {
                                        buf[i++] = '0';
                                } else {
                                        buf[i++] = ' ';
                                }
			}
			flag++;
		}
	}
	buf[i] = 0;
	cprint(y,x,buf);
}

/*
 * Print a hex number on screen
 */
void hprint(int y,int x, unsigned long val)
{
	unsigned long j;
	int i, idx, flag = 0;

        for (i=0, idx=0; i<8; i++) {
                j = val >> (28 - (4 * i));
		j &= 0xf;
		if (j < 10) {
			if (flag || j || i == 7) {
		                buf[idx++] = j + '0';
				flag++;
			} else {
				buf[idx++] = '0';
			}
		} else {
			buf[idx++] = j + 'a' - 10;
			flag++;
		}
        }
        buf[idx] = 0;
	cprint(y,x,buf);
}

/*
 * Print an address in 0000m0000k0000 notation
 */
void xprint(int y,int x, unsigned long val)
{
        unsigned long j;

	j = (val & 0xffc00000) >> 20;
	dprint(y, x, j, 4, 0);
	cprint(y, x+4, "m");
	j = (val & 0xffc00) >> 10;
	dprint(y, x+5, j, 4, 0);
	cprint(y, x+9, "k");
	j = val & 0x3ff;
	dprint(y, x+10, j, 4, 0);
}
	
void inter()
{
	cprint(18, 0, "Unexpected Interrupt - Halting");
	cprint(19, 0, "    Type: ");
	cprint(20, 0, "   Eflag: ");
	cprint(21, 0, "      CS: ");
	cprint(22, 0, "      PC: ");
	cprint(23, 0, "Err Code: ");
	if (trap_regs[0] <= 18) {
		cprint(19, 10, codes[trap_regs[0]]);
	} else {
		hprint(19, 10, trap_regs[0]);
	}
	hprint(20, 10, trap_regs[1]);
	hprint(21, 10, trap_regs[2]);
	hprint(22, 10, trap_regs[3]);
	hprint(23, 10, trap_regs[4]);
	while(1);
}

void set_cache(int val) {
	switch(val) {
	case 0:
		cache_off();	
		if (v->cache_flag) {
			cprint(LINE_CACHE, 9, "OFF");
		} else {
			cprint(LINE_CACHE, 9, "off");
		}
		break;
	case 1:
		cache_on();
		if (v->cache_flag) {
			cprint(LINE_CACHE, 9, "ON ");
		} else {
			cprint(LINE_CACHE, 9, "on ");
		}
		break;
	}
}

void set_refresh(int val) {
	switch(val) {
	case 0:
		/* set refresh to 15ms */
		outb(0x74, 0x43);
		outb(0x12, 0x41);
		outb(0x00, 0x41);
		cprint(LINE_REF, 9, "NORMAL (15ms)   ");
		break;
	case 1:
		/* set refresh to 150ms */
		outb(0x74, 0x43);
		outb(0xb4, 0x41);
		outb(0x00, 0x41);
		cprint(LINE_REF, 9, "EXTENDED (150ms)");
		break;
	case 2:
		/* set refresh to 500ms */
		outb(0x74, 0x43);
		outb(0x58, 0x41);
		outb(0x02, 0x41);
		cprint(LINE_REF, 9, "XLONG (500ms)   ");
		break;
	}
}

int get_key() {
	int c;

	c = inb(0x64);
	if ((c & 1) == 0) {
		return(0);
	}
	c = inb(0x60);
	return((c));
}

void check_input()
{
	unsigned char c;

	if ((c = get_key())) {
		switch(c & 0x7f) {
		case 1:	
			/* "ESC" key was pressed, bail out.  */
			cprint(2, 42, "Halting... ");

			/* tell the BIOS to do a warm start */
			*((unsigned short *)0x472) = 0x1234;
			cache_on();
			outb(0xfe,0x64);
			break;
		case 46:
			/* c - Configure */
			get_config();
			break;
		case 28:
			/* SP - set scroll lock */
			slock = 0;
			footer();
			break;
		case 57:
			/* CR - clear scroll lock */
			slock = 1;
			footer();
			break;
		}
	}
}

void get_config()
{
	int flag = 0, i;
	long addr;
	popup();
	cprint(POP_Y+1, POP_X+2, "Configuration:");
	cprint(POP_Y+3, POP_X+6, "(1) Cache Mode");
	cprint(POP_Y+4, POP_X+6, "(2) Refresh Timing");
	cprint(POP_Y+5, POP_X+6, "(3) Test Selection");
	cprint(POP_Y+6, POP_X+6, "(4) Address Range");
	cprint(POP_Y+7, POP_X+6, "(0) Cancel");

	/* Wait for key release */
	while ((get_key() & 0x80) == 0);
	while(!flag) {
		switch(get_key()) {
		case 2:
			/* 1 - Set cache mode */
			popclear();
			cprint(POP_Y+1, POP_X+2, "Cache Mode:");
			cprint(POP_Y+3, POP_X+6, "(1) Test Controlled");
			cprint(POP_Y+4, POP_X+6, "(2) Always On");
			cprint(POP_Y+5, POP_X+6, "(3) Always Off");
			cprint(POP_Y+6, POP_X+6, "(0) Cancel");
			cprint(POP_Y+3+v->cache_flag, POP_X+5, ">");
			while ((get_key() & 0x80) == 0);
			while (!flag) {
				switch(get_key()) {
				case 2:
					/* test controled */
					v->cache_flag = 0;
					set_cache(tseq[v->test].cache);
					flag++;
					break;
				case 3:
					/* Cache on */
					v->cache_flag = 1;
					if (tseq[v->test].cache == 0)  {
						bail++;
					}
					set_cache(1);
					flag++;
					break;
				case 4:
					/* Cache off */
					v->cache_flag = 2;
					if (tseq[v->test].cache == 1)  {
						bail++;
					}
					flag++;
					break;
				case 11:
					flag++;
					break;
				}
			}
			break;
		case 3:
			/* 2 - Set refresh mode */
			popclear();
			cprint(POP_Y+1, POP_X+2, "Refresh  Timing:");
			cprint(POP_Y+3, POP_X+6, "(1) Test Controlled");
			cprint(POP_Y+4, POP_X+6, "(2) Normal (15ms)");
			cprint(POP_Y+5, POP_X+6, "(3) Extended (150ms)");
			cprint(POP_Y+6, POP_X+6, "(4) Extra Long (500ms)");
			cprint(POP_Y+7, POP_X+6, "(0) Cancel");
			cprint(POP_Y+3+v->ref_flag, POP_X+5, ">");
			while ((get_key() & 0x80) == 0);
			while (!flag) {
				switch(get_key()) {
				case 2:
					/* Test Controlled */
					v->ref_flag = 0;
					set_refresh(tseq[v->test].ref);
					flag++;
					break;
				case 3:
					/* refresh normal */
					v->ref_flag = 1;
					set_refresh(0);
					flag++;
					break;
				case 4:
					/* refresh extended */
					v->ref_flag = 2;
					set_refresh(1);
					flag++;
					break;
				case 5:
					/* refresh way long */
					v->ref_flag = 3;
					set_refresh(2);
					flag++;
					break;
				case 11:
					flag++;
					break;
				}
			}
			break;
		case 4:
			/* 3 - Test Selection */
			popclear();
			cprint(POP_Y+1, POP_X+2, "Test Selection:");
			cprint(POP_Y+3, POP_X+6, "(1) Default Tests");
			cprint(POP_Y+4, POP_X+6, "(2) Extended Tests");
			cprint(POP_Y+5, POP_X+6, "(3) All Tests");
			cprint(POP_Y+6, POP_X+6, "(4) Skip Current Test");
			cprint(POP_Y+7, POP_X+6, "(5) Select Test");
			cprint(POP_Y+8, POP_X+6, "(0) Cancel");
			if (v->testsel < 0) {
				cprint(POP_Y+3+v->xtst_flag, POP_X+5, ">");
			} else {
				cprint(POP_Y+7, POP_X+5, ">");
			}
			while ((get_key() & 0x80) == 0);
			while (!flag) {
				switch(get_key()) {
				case 2:
					/* Default */
					v->xtst_flag = 0;
					if (v->test > DEFTESTS) {
						bail++;
					}
					v->testsel = -1;
					flag++;
					break;
				case 3:
					/* Extended */
					v->xtst_flag = 1;
					if (v->test <= DEFTESTS) {
						bail++;
					}
					v->testsel = -1;
					flag++;
					break;
				case 4:
					/* All */
					v->xtst_flag = 2;
					v->testsel = -1;
					flag++;
					break;
				case 5:
					/* Skip test */
					bail++;
					flag++;
					break;
				case 6:
					/* Select test */
					popclear();
					cprint(POP_Y+1, POP_X+2,
						"Test Selection:");
					cprint(POP_Y+3, POP_X+4,
						"Test Number [0-10]: ");
					i = getval(POP_Y+3, POP_X+24);
					if (i <= 10) {
						v->testsel = i;
					}
					flag++;
					bail++;
					break;
				case 11:
					flag++;
					break;
				}
			}
			break;
		case 5:
			/* 4 - Address Range */
			popclear();
			cprint(POP_Y+1, POP_X+2, "Test Address Range:");
			cprint(POP_Y+3, POP_X+6, "(1) Set Lower Limit");
			cprint(POP_Y+4, POP_X+6, "(2) Set Upper Limit");
			cprint(POP_Y+5, POP_X+6, "(3) Test All Memory");
			cprint(POP_Y+6, POP_X+6, "(0) Cancel");
			while ((get_key() & 0x80) == 0);
			while (!flag) {
				switch(get_key()) {
				case 2:
					/* Lower Limit */
					popclear();
					cprint(POP_Y+2, POP_X+4,
						"Lower Limit: ");
					cprint(POP_Y+4, POP_X+4,
						"Current: ");
					aprint(POP_Y+4, POP_X+13, v->lim_lower);
					cprint(POP_Y+6, POP_X+4,
						"New: ");
					addr = getval(POP_Y+6, POP_X+9);
					addr &= ~0x3ff;
					if (addr+1024 <= v->lim_upper) {
						v->lim_lower = addr;
						bail++;
					}
					flag++;
					break;
				case 3:
					/* Upper Limit */
					popclear();
					cprint(POP_Y+2, POP_X+4,
						"Upper Limit: ");
					cprint(POP_Y+4, POP_X+4,
						"Current: ");
					aprint(POP_Y+4, POP_X+13, v->lim_upper);
					cprint(POP_Y+6, POP_X+4,
						"New: ");
					addr = getval(POP_Y+6, POP_X+9);
					addr &= ~0x3ff;
					if (addr-1024 >= v->lim_lower) {
						v->lim_upper = addr;
						bail++;
					}
					flag++;
					break;
				case 4:
					/* All of memory */
					v->lim_lower = 0;
					v->lim_upper =
						(long)v->rmap[v->msegs-1].end;
					bail++;
					flag++;
					break;
				case 11:
					/* 0 - Cancel */
					flag++;
					break;
				}
			}
			break;
		case 11:
			/* 0 - Cancel */
			flag++;
			break;
		}
	}
	popdown();
}

void popup()
{
	int i, j;
	char *pp;
	
	for (i=POP_Y; i<POP_Y + POP_H; i++) { 
		for (j=POP_X; j<POP_X + POP_W; j++) { 
			pp = (char *)(SCREEN_ADR + (i * 160) + (j * 2));
			save[i-POP_Y][j-POP_X] =  *pp;	/* Save screen */
			*pp = ' ';		/* Clear */
			pp++;
			*pp = 0x07;		/* Change Background to black */
		}
	}
}

void popdown()
{
	int i, j;
	char *pp;
	
	for (i=POP_Y; i<POP_Y + POP_H; i++) { 
		for (j=POP_X; j<POP_X + POP_W; j++) { 
			pp = (char *)(SCREEN_ADR + (i * 160) + (j * 2));
			*pp = save[i-POP_Y][j-POP_X];	/* Restore screen */
			pp++;
			*pp = 0x17;		/* Reset background color */
		}
	}
}

void popclear()
{
	int i, j;
	char *pp;
	
	for (i=POP_Y; i<POP_Y + POP_H; i++) { 
		for (j=POP_X; j<POP_X + POP_W; j++) { 
			pp = (char *)(SCREEN_ADR + (i * 160) + (j * 2));
			*pp = ' ';		/* Clear screen */
			pp++;
		}
	}
}

void footer()
{
	cprint(24, 0, "(ESC)exit  (c)configuration  (SP)scroll_lock  (CR)scroll_unlock");
	if (slock) {
		cprint(24, 74, "Locked");
	} else {
		cprint(24, 74, "      ");
	}
}

long getval(x, y)
{
	int flag=0, c, n=0;
	long i, val, mult;
	char buf[16];
	char str[2];

	str[1] = 0;
	while ((get_key() & 0x80) == 0);
	while (!flag) {
		c = get_key();

		/* If CR and something has been entered, bail */
		if (c == 28 && n) {
			break;
		}

		/* M */
		if (c == 50 && n) {
			cprint(x, y+n, "m");
			buf[n] = 'm';
			if (n < 12) {
				n++;
			}
			continue;
		}

		/* K */
		if (c == 37 && n) {
			cprint(x, y+n, "k");
			buf[n] = 'k';
			if (n < 12) {
				n++;
			}
			continue;
		}

		/* Backspace */
		if (c == 14 && n) {
			n--;
			str[0] = ' ';
			cprint(x, y+n, str);
		}

		c--;
		if (c < 1 || c > 10) {
			continue;
		}
		if (c == 10) {
			c = 0;
		}

		str [0] = '0'+c;
		cprint(x, y+n, str);
		buf[n] = c;
		if (n < 12) {
			n++;
		}
	}

	/* Convert stored values to an integer */
	i = 1;
	val = 0;
	mult = 1;
	while (n--) {
		if (buf[n] == 'm') {
			mult = 1048576;
			continue;
		}
		if (buf[n] == 'k') {
			mult = 1024;
			continue;
		}

		val += buf[n] * i;
		i *= 10;
	}
	return(val * mult);
}
