/* irqtune.P -- function prototypes generated by pgmtypex */
#ifndef _irqtune_P_
#define _irqtune_P_

/* FILE: ./lib/cmd.c */
#ifndef __ASSEMBLER__
#pragma member irqtune.h

	/* cmdopen -- open command pipe */
	/* RETURNS: stream pointer */
#ifndef cmdopen
	struct cmdblk *
	cmdopen(const char *cmdbf);
#endif /*cmdopen*/

	/* cmdclose -- close command pipe */
	/* RETURNS: final status */
#ifndef cmdclose
	int
	cmdclose(struct cmdblk *cmd);
#endif /*cmdclose*/

	/* cmdcoredump -- decide if program terminated due to core dump */
	/* RETURNS: 0=normal, 1=limited, 2=dumped */
#ifndef cmdcoredump
	int
	cmdcoredump(int status);
#endif /*cmdcoredump*/

	/* cmdread -- read in command line */
	/* RETURNS: length (-1=EOF or error) */
#ifndef cmdread
	int
	cmdread(struct cmdblk *cmd,char *bf,int bflen);
#endif /*cmdread*/

	/* cmdsigon -- enable signal handler */
#ifndef cmdsigon
	void
	cmdsigon(void);
#endif /*cmdsigon*/

	/* cmdsigoff -- disable signal handler */
#ifndef cmdsigoff
	void
	cmdsigoff(void);
#endif /*cmdsigoff*/

	/* cmdsighdr -- command signal handler */
#ifndef cmdsighdr
	void
	cmdsighdr(int signo);
#endif /*cmdsighdr*/

	/* vsystem -- execute program */
	/* RETURNS: error code */
#ifndef vsystem
	int
	vsystem(int verbose,const char *tag0,const char *tag1,const char *tag2,const char *cmdbf0);
	/* tag0 -- primary command (e.g. loading, unloading, etc.) */
	/* tag1 -- primary tag */
	/* tag2 -- secondary tag */
	/* cmdbf0 -- actual command buffer */
#endif /*vsystem*/
#endif /*__ASSEMBLER__*/

/* FILE: ./lib/file.c */
#ifndef __ASSEMBLER__
#pragma member irqtune.h

	/* filecpy -- copy file */
	/* RETURNS: error code */
#ifndef filecpy
	int
	filecpy(int goflg,const char *dirdst,const char *dirsrc,const char *tail);
#endif /*filecpy*/

	/* filehead -- get head of name */
	/* RETURNS: pointer to head */
#ifndef filehead
	char *
	filehead(char *name);
	/* name -- name to get head of */
#endif /*filehead*/

	/* filetail -- get tail of name */
	/* RETURNS: pointer to tail */
#ifndef filetail
	char *
	filetail(char *name);
	/* name -- name to get tail of */
#endif /*filetail*/

	/* pathdir -- insure a directory is in $PATH */
	/* RETURNS: pointer to $PATH match (or NULL) */
#ifndef pathdir
	char *
	pathdir(const char *dir);
#endif /*pathdir*/

	/* pathlook -- lookup file in $PATH */
	/* RETURNS: pointer to directory name (or NULL) */
#ifndef pathlook
	char *
	pathlook(const char *tail,const char *dir);
	/* tail -- file to locate */
#endif /*pathlook*/
#endif /*__ASSEMBLER__*/

/* FILE: ./lib/opt.c */
#ifndef __ASSEMBLER__
#pragma member irqtune.h

	/* optget -- get options */
	/* RETURNS: 1=ok, 0=error */
#ifndef optget
	int
	optget(struct optblk *opt,char *cp);
#endif /*optget*/

	/* optusage -- show option usage */
#ifndef optusage
	void
	optusage(const struct optblk *opt);
#endif /*optusage*/
#endif /*__ASSEMBLER__*/

/* FILE: ./lib/sys.c */
#ifndef __ASSEMBLER__
#pragma member irqtune.h

	/* sysexit -- do cleanup and exit */
#ifndef sysexit
	void
	sysexit(int code);
#endif /*sysexit*/

	/* sysfault -- output howfar to stxerr */
	/* RETURNS: length of output string */
#ifndef sysfault
	int
	sysfault(const char *fmt,...);
	/* fmt -- format */
#endif /*sysfault*/
#endif /*__ASSEMBLER__*/

/* FILE: ./lib/xstr.c */
#ifndef __ASSEMBLER__
#pragma member irqtune.h

	/* xstrargv -- split buffer into tokens */
	/* RETURNS: number of tokens */
#ifndef xstrargv
	int
	xstrargv(char **argv,int argc,char *bf);
#endif /*xstrargv*/
#endif /*__ASSEMBLER__*/

/* FILE: ./src/irqtune.c */
#ifndef __ASSEMBLER__
#pragma member irqtune.h

	/* main -- main program */
#ifndef main
	void
	main(int argc,char **argv);
#endif /*main*/

	/* install -- install program */
#ifndef install
	void
	install(int argc,char **argv);
#endif /*install*/

	/* loader -- load module */
#ifndef loader
	void
	loader(void);
#endif /*loader*/

	/* probechk -- check dynamic configuration */
#ifndef probechk
	void
	probechk(mskof_t actmsk,const char *fmt,...);
#endif /*probechk*/

	/* probectl -- probe control (to probe 1) */
#ifndef probectl
	void
	probectl(void);
#endif /*probectl*/

	/* probectl2 -- probe control (to probe 2) */
#ifndef probectl2
	void
	probectl2(void);
#endif /*probectl2*/

	/* probeins -- probe for insmod */
#ifndef probeins
	void
	probeins(void);
#endif /*probeins*/

	/* probeknl -- probe the kernel */
#ifndef probeknl
	void
	probeknl(void);
#endif /*probeknl*/

	/* probeksyms -- probe /proc/ksyms */
#ifndef probeksyms
	void
	probeksyms(void);
#endif /*probeksyms*/

	/* verdcd -- decode version number */
	/* RETURNS: decoded version number */
#ifndef verdcd
	u_long
	verdcd(char *bf);
#endif /*verdcd*/

	/* tblfind -- find table entry */
	/* RETURNS: pointer to /proc/interrupts table entry */
#ifndef tblfind
	struct tblblk *
	tblfind(u_char irq_no);
#endif /*tblfind*/

	/* tblinit -- initialize to default */
#ifndef tblinit
	void
	tblinit(void);
#endif /*tblinit*/

	/* tblread -- read in /proc/interrupts table */
#ifndef tblread
	void
	tblread(int goflg,char *file);
#endif /*tblread*/

	/* tblshow -- show table */
#ifndef tblshow
	void
	tblshow(void);
#endif /*tblshow*/

	/* _usage -- show program usage */
#ifndef _usage
	void
	_usage(void);
#endif /*_usage*/

	/* usage -- show program usage and exit */
#ifndef usage
	void
	usage(void);
#endif /*usage*/
#endif /*__ASSEMBLER__*/

#endif /*_irqtune_P_*/
