#include <kapp.h>
#include <qmessagebox.h>
#include "query-user.h"

/***********************************************************************/

void gnc_info_dialog(const char *message)
{
  QMessageBox::information(kapp->topWidget(), kapp->getCaption(), message);
}

void gnc_warning_dialog(const char *message)
{
  QMessageBox::warning(kapp->topWidget(), kapp->getCaption(), message);
}

void gnc_error_dialog(const char *message)
{
  QMessageBox::critical(kapp->topWidget(), kapp->getCaption(), message);
}

int gnc_verify_dialog(const char *message, int yes_is_default)
{
  int default_button = yes_is_default ? 0 : 1;
  int rc = QMessageBox::information(kapp->topWidget(),
                                    kapp->getCaption(),
                                    message, "Yes", "No", 0, default_button);
  return (rc == 0);
}

/******************************* E N D *********************************/
