/********************************************************************\
 * PriceMenu.h -- the price source menu for gnucash                 *
 *                  (general utility)                               *
 * Copyright (C) 1997, 1999 Linas Vepstas                           *
 *                                                                  *
 * This program is free software; you can redistribute it and/or    *
 * modify it under the terms of the GNU General Public License as   *
 * published by the Free Software Foundation; either version 2 of   *
 * the License, or (at your option) any later version.              *
 *                                                                  *
 * This program is distributed in the hope that it will be useful,  *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of   *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the    *
 * GNU General Public License for more details.                     *
 *                                                                  *
 * You should have received a copy of the GNU General Public License*
 * along with this program; if not, write to the Free Software      *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.        *
\********************************************************************/

#ifndef __XACC_PRICE_MENU_H__
#define __XACC_PRICE_MENU_H__

#include <Xm/Xm.h>

#include "config.h"

typedef struct _priceMenu  PriceMenu;

extern PriceMenu  *xaccBuildPriceMenu       (Widget parent, const char * label);
extern void        xaccFreePriceMenu        (PriceMenu  *menu);

extern Widget     xaccGetPriceMenuWidget    (PriceMenu  *menu);
extern char      *xaccGetPriceMenuSelection (PriceMenu  *menu);
extern void       xaccPriceMenuAddCallback  (PriceMenu  *menu, 
                                             XtCallbackProc callback,
                                             XtPointer client_data);

/* The xaccPriceMenuSetValue() routine sets the current value of the 
 * menu list */
extern void       xaccPriceMenuSetValue     (PriceMenu *menu, const char * val);

#endif /* __XACC_PRICE_MENU_H__ */
