/*****************************************************************************
 *  Backup Copy                                                              *
 *  Programmed by: Kevin Lindsay                                             *
 *  Copyright (c) 1998 NetNation Communications Inc                          *
 * ***************************************************************************/ 

#include <stdio.h>
#include <stdlib.h>

#include "link.h"
#include "statmalloc.h"

/* Initialize 2D List */

dir_item *
init_2D_list()
{
   dir_item *listptr;
   
   if ((listptr = (dir_item *)statmalloc(sizeof(dir_item))) == NULL) {
      fprintf(stderr,"Could not allocate memory for init_2D_list!\n");
   }
   
   listptr->name = NULL;
   listptr->up = NULL;
   listptr->down = NULL;
   listptr->left = NULL;
   listptr->right = NULL;
   listptr->dir_info = NULL;
   listptr->empty = 0;
   listptr->mod_time = 0;
   listptr->fsize = 0;
   
   return(listptr);
}

/* Initialize Dest Item List */

dest_item *
init_dest_list()
{
   dest_item *destptr;
   
   if ((destptr = (dest_item *)statmalloc(sizeof(dest_item))) == NULL) {
      fprintf(stderr,"Could not allocate memory for init_dest_list!\n");
   }
   
   destptr->name = NULL;
   destptr->prev = NULL;
   destptr->next = NULL;
   destptr->name_len = 0;
   destptr->type = 0;
   destptr->delete = 1;
   destptr->mod_time = 0;
   destptr->fsize = 0;
   
   return(destptr);
}

/* Add Next to Dest List */

dest_item *
add_next(dest_item *destptr)
{
   
   if ((destptr->next = (dest_item *)statmalloc(sizeof(dest_item))) == NULL) {
      fprintf(stderr,"Could not allocate memory for Add Next!\n");
   }
   
   destptr->next->prev = destptr;
   destptr->next->next = NULL;
   destptr->next->name = NULL;
   destptr->next->name_len = 0;
   destptr->next->type = 0;
   destptr->next->delete = 1;
   destptr->next->mod_time = 0;
   destptr->next->fsize = 0;   
   
   return(destptr);
}

/* Add Right to 2D List */

dir_item *
add_right(dir_item *listptr)
{
   
   if ((listptr->right = (dir_item *)statmalloc(sizeof(dir_item))) == NULL) {
      fprintf(stderr,"Could not allocate memory for add_right!\n");
   }
   
   listptr->right->left = listptr;   
   listptr->right->up = NULL;
   listptr->right->down = NULL;
   listptr->right->right = NULL;
   listptr->right->name = NULL;
   listptr->right->dir_info = NULL;
   listptr->right->empty=0;
   listptr->right->name_len = 0;
   listptr->right->type = 0;
   listptr->right->mod_time = 0;
   listptr->right->fsize = 0;   
   
   return(listptr);
}

/* Add Down to 2D List */

dir_item *
add_down(dir_item *listptr)
{
   if ((listptr->down = (dir_item *)statmalloc(sizeof(dir_item))) == NULL) {
      fprintf(stderr,"Could not allocate memory for add_down!\n");      
   }
   
   listptr->down->up = listptr;
   listptr->down->left = listptr->left;
   listptr->down->down = NULL;
   listptr->down->right = NULL;
   listptr->down->name = NULL;   
   listptr->down->dir_info = NULL;
   listptr->down->empty = 0;
   listptr->down->name_len = 0;
   listptr->down->type = 0;   
   listptr->down->mod_time = 0;
   listptr->down->fsize = 0;   
   
   return(listptr);   
}

/* Free Dest Item List */
dir_item *
free_dirinfo(dir_item *curptr)
{
   dest_item *destptr;
   
   destptr = curptr->dir_info;
   
   while (destptr->next != NULL)
       destptr = destptr->next;
   
   while (destptr->prev != NULL) {
      destptr = destptr->prev;
      freemalloc(destptr->next->name);
      freemalloc(destptr->next);
   }
   freemalloc(destptr->name);
   freemalloc(destptr);
   
   return(curptr);
}

/* Free 2D List Right */

dir_item *
free_right(dir_item *listptr)
{
   if (listptr->right != NULL) {
      listptr = listptr->right;
      
      while (listptr->down != NULL)
	listptr = listptr->down;
      
      while (listptr->up != NULL) {
         listptr = listptr->up;
         if (listptr->down->dir_info != NULL) {
            listptr->down = free_dirinfo(listptr->down);
         }
         freemalloc(listptr->down->name);         
         freemalloc(listptr->down);
      }
      listptr = listptr->left;
      freemalloc(listptr->right->name);
      freemalloc(listptr->right);
      listptr->right = NULL;
   }
   return(listptr);
}

