/*
AutoConvert, a Chinese HZ/GB/Big5 encodings auto-converter
Copyright (C) 1999  ڹ  Yu Guanghui <ygh@dlut.edu.cn>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or any
later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.
*/
/* 
* author: Yu Guanghui <ygh@rose.dlut.edu.cn>
*	  Network Center
* 	  Dalian Univ. of Tech.	
*	  $Header: /home/ygh/.cvsroot/autoconvert/autogb.c,v 1.6 1999/12/28 04:52:00 ygh Exp $
*/

#include <stdio.h>
#include "config.h"


int j_code(char* buff,int count);
int incode;
int outcode;


main(int argc,char*argv[])
{
	char buff[MAX_BUFFER+4];
	char *pbuf;
	char *ps;


	int count;
	FILE *pout;

	int inst=0;
	char *half='\0';

	pbuf=&buff[1];

	if( strstr(argv[0],"autogb") != '\0' ){
		outcode=GB_CODE;
	}else if(strstr(argv[0],"autob5") != '\0'){
	
		outcode=BIG5_CODE;
	}
	/*else if(strstr(argv[0],"autohz") != '\0'){
		outcode=HZ_CODE;
	}
	*/
	

	if((count=read(0,pbuf,MAX_BUFFER))< 0){
		fprintf(stderr,"Cant read stdin\n");
	}

	incode=j_code(pbuf,count);
	

	gb2big_init();
	big2gb_init();
	hz2gb_init();

	do{

		if(outcode==BIG5_CODE)
		{
			switch(incode){
				case BIG5_CODE:
					write(1,pbuf,count);
					break;
				case GB_CODE:
					ps=gb2big(pbuf,&count,0);
					write(1,ps,count);
					break;
				case HZ_CODE:
					ps=hz2gb(pbuf,&count,0);
					ps=gb2big(ps,&count,0);
					write(1,ps,count);
					break;
				default:
					write(1,pbuf,count);
					break;
			}
		}else if(outcode==GB_CODE)
		{
			switch(incode){
				case GB_CODE:
					write(1,pbuf,count);
					break;
				case BIG5_CODE:
					ps=big2gb(pbuf,&count,0);
					write(1,ps,count);
					break;
					
				case HZ_CODE:
					ps=hz2gb(pbuf,&count,0);
					write(1,ps,count);
					break;
				default:
					write(1,pbuf,count);
			}
		}
		/*else if(outcode==HZ_CODE)
		{
			switch(incode){
				case GB_CODE:
					ps=gb2hz(pbuf,&count,0);
					write(1,ps,count);
					break;
				case BIG5_CODE:
					ps=big2gb(pbuf,&count,0);
					ps=gb2hz(ps,&count,0);
					write(1,ps,count);
					break;
				case HZ_CODE:
					write(1,pbuf,count);
					break;
				default:
					write(1,pbuf,count);
			}
			
		}
		*/
		fflush(0);
	}while((count=read(0,pbuf,MAX_BUFFER))>0);
	
}
