#!@SHELL@

# Don't hack this script by hand if it's in one of your PATH directories.
# Instead, modify scripts/yodl2dvi.sh in the YODL source package and do a 
# "make -C scripts install".

#################################################### Print error msg and die.
error()
{
    echo yodl2dvi: $@ 1>&2
    exit 1
}

################################################### Print usage info and die.
usage()
{
    cat << ENDUSAGE
Yodl2dvi @TOPLEVEL_VERSION@

Usage: yodl2dvi [OPTION]... FILE
Options:
    for processing, run "yodl" without arguments to see
This converter runs "yodl2latex" to convert the input file to LaTeX format, 
then runs "@LATEX@" to convert it to dvi format. The LaTeX job is repeated
up to three times when necessary.
ENDUSAGE

    exit 1
}

###################################################### Start of main program.

# get all flags
flags=""
inf=""
while [ "$1" != "" ] ; do
    case $1 in
        -*)
            flags="$flags $1"
            shift
            ;;
        *)
            inf=$1
            shift
            ;;
    esac
done

# no input file, nogo
if [ "$inf" = "" ] ; then
    usage
fi

# determine output file, logfile, dvi file
# ash chokes on these
#if [ "x${inf%%.yo}.yo" = "x$inf".yo ]; then
#    texf=${inf%%.yo}.latex
#    logf=${inf%%.yo}.log
#    dvif=${inf%%.yo}.dvi
#else
    texf=`echo $inf | sed 's/\.yo//'`.latex
    logf=`echo $inf | sed 's/\.yo//'`.log
    dvif=`echo $inf | sed 's/\.yo//'`.dvi
#fi

yodl2latex $flags $inf || error "YODL to LaTeX conversion failed"
@LATEX@ $texf || error "First LaTeX to dvi conversion failed"
grep Warning $logf > /dev/null 2>&1
if [ $? -eq 0 ] ; then
    @LATEX@ $texf || error "Second LaTeX to dvi conversion failed"
fi
grep Warning $logf > /dev/null 2>&1
if [ $? -eq 0 ] ; then
    @LATEX@ $texf || error "Third LaTeX to dvi conversion failed"
fi
