#!/bin/sh
#
#  makerpms.sh - Make all RPM files.
#
#  $Id: makerpms.sh,v 1.2 1998/07/28 18:28:28 cg Exp $
#
#  SGMLtools - an SGML toolkit.
#  Copyright (C) 1998 Cees A. de Groot
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#
#  This walks through the packagelist, runs make for every package
#  and finally calls my hacked version of 'rpm' which accepts a
#  -bx switch (which does an install and then builds a binary package,
#  a sort of short-circuiting that isn't allowed with plain rpm).
#
TOP=$(pwd)
cat packages/packagelist | grep -v ^# | grep -v noinstall |
    while read tag pkg vers build
do
    echo "$tag $pkg $vers $build"
    cd $TOP/packages/BUILD
    rm ${pkg}*
    ln -s ../cvs/$pkg $pkg-$vers
    cd $TOP/packages/SOURCES
    case $pkg in
	hyperref)		src=none;;
	jadetex)		src=none;;
	docbook-dtd)		src=docbk30.tar.Z;;
	docbook-stylesheets)	src=db107.zip;;
	iso-entities)		src=iso-entities-8879.1986.2.tar.gz;;
	jade)			src=jade1_1_1.zip;;
	sgmltools)		src=sgmltools-1.1-base.tar.bz2;;
    esac
    [ $src = none ] || echo "Hello, world" >$src
    cd $TOP
    make build-$pkg.force || exit
    /opt/rpm/bin/rpm  \
	-bx -v \
	--rcfile .rpmrc \
	packages/SPECS/$pkg-$vers.spec || exit
    rm -r /tmp/$pkg*
done
