/*
 * Copyright (c) 1997  Motoyuki Kasahara
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef RFC1413_H
#define RFC1413_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <sys/types.h>


/*
 * The string represents unknown user.
 */
#ifndef UNKNOWN_USER
#define UNKNOWN_USER		"?"
#endif


/*
 * The maximum length of the user-id, described in RFC1413.
 */
#define MAXLEN_USER_ID		127


/*
 * Function declarations.
 */
#ifdef __STDC__
int identify_user(int, char *, int);
#else
int identify_user();
#endif

#endif /* not RFC1413_H */
