/*
 *  kakasi.c -- Kakasi module
 *  Copyright (C) 1999 GOTO Kentaro
 */

#include <string.h>
#include "ruby.h"
#include "libkakasi.h"

#define OPTMAX 1024
#define min(x,y) ((x)<(y) ? (x) : (y))

static int dic_closed = 1, len = 0;
static char prev_opt_ptr[OPTMAX];

static VALUE
rb_kakasi_kakasi(obj, opt, src)
    VALUE obj, opt, src;
{
    int argc = 0;
    char **argv, **opts;
    char *buf, *opt_ptr, *t;
    VALUE dst;

    Check_Type(src, T_STRING);

    /* return "" immediately if source str is empty */
    if (*(RSTRING(src)->ptr) == '\0')
	return rb_str_new2("");

    Check_Type(opt, T_STRING);

     /* initialize kakasi iff opt != previous opt */
    if (0 == len || 0 != strncmp(RSTRING(opt)->ptr, prev_opt_ptr, 
				 min(RSTRING(opt)->len, len))) {
	strncpy(prev_opt_ptr, RSTRING(opt)->ptr, RSTRING(opt)->len);
	len = RSTRING(opt)->len; 

	if (!dic_closed) {
	    kakasi_close_kanwadict();
	    dic_closed = 1;
	}

	argv = opts = ALLOCA_N(char*, RSTRING(opt)->len);
	*opts++ = "kakasi";
	argc++;

	opt_ptr = ALLOCA_N(char, 1 + RSTRING(opt)->len);
	strncpy(opt_ptr, RSTRING(opt)->ptr, RSTRING(opt)->len);

	if (*opts++ = strtok(opt_ptr, " \t")) {
	    argc++;
	    while (t = strtok(NULL, " \t")) {
		*opts++ = t;
		argc++;
	    }
	}
	
	if (0 != kakasi_getopt_argv(argc, argv))
	    rb_raise(rb_eRuntimeError, "failed to initialize kakasi");
	dic_closed = 0;
    }

    buf = kakasi_do(RSTRING(src)->ptr);
    dst = rb_str_new2(buf);
    free(buf);

    return dst;
}

void
Init_kakasi()
{
    VALUE mKakasi = rb_define_module("Kakasi");

    rb_define_module_function(mKakasi, "kakasi", rb_kakasi_kakasi, 2);
}
