/*
 * GUI file view header
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifndef __GDIFF_FILEVIEW_H__
#define __GDIFF_FILEVIEW_H__


#include "properties.h" /* for FViewPref */
#include "gdiffoverview.h" /* for GdiffOverview */

#ifdef __cplusplus 
extern "C" {
#endif /* __cplusplus */

/*
 * Contant number
 */
#define WIDTH_OVERVIEW		10/*XXX: hard-code is not good? */

/* marks added line numbers. The lengthes of three strings should be same. */
#define MARK_FILE1		"< "
#define MARK_FILE2		"> "
#define MARK_COMMON		"  "
#define MARK_LENGTH		(sizeof(MARK_COMMON)-1)


/* 
 * Data structure definitions
 */
/* File view data
 * From an intuitive perspective, this is related to diff results.
 * Note: For one back-end data(DiffFiles), two instances can exist,
 * i.e. one is for one-pane mode, the other is for two-pane mode. */
struct _GDiffFileViews {
	/* Back-end data */
	char *filename1;
	char *filename2;

	/* For reference.
	   GDiffFileViews itself doesn't care about these memory allocations. */
	DiffFiles *dfiles;
	GDiffWindow *gdwin;
	GDiffDirViews *gdirviews;
	const GList *cur_dlines_list;/* For navigation,
									to keep the current difference. */
	
	/* Front-end data */
	FViewPref pref;
	GtkWidget *base;/* A virtual base widget, which points to a real widget. */
	union {
		struct {
			GtkHBox *hbox;
			GtkLabel *label;/* For notebook */
			GtkText *text;
			GtkDrawingArea *darea;
			GdiffOverview *overview[NUM_COMPARE_FILES];
		} one;
		struct {
			GtkHBox *hbox;
			GtkLabel *label;/* For notebook */
			GtkText *text[NUM_COMPARE_FILES];
			GtkDrawingArea *darea;
			GdiffOverview *overview[NUM_COMPARE_FILES];
			GtkVScrollbar *vscrollboth;
		} two;
	} pane;

	/* Number of merged lines, used in one-pane mode */
	int merged_nline;
};


/* Global function declarations */
/* fileview.h */
extern GDiffFileViews* gdiff_fileviews_new(GDiffWindow *gdwin, GDiffDirViews *gdirviews, DiffFiles *dfiles, PaneMode pmode);
extern void gdiff_fileviews_delete(GDiffFileViews *gfileviews);

/* onepane.c */
extern void onepane_create_widgets(GDiffFileViews *gfileviews);
extern void onepane_display(GDiffFileViews *gfileviews);
extern void onepane_show_linenum(GDiffFileViews *gfileviews, gboolean to_show);
extern void onepane_move_diff(GDiffFileViews *gfileviews, MoveDiff mv_diff);

/* twopane.c */
extern void twopane_create_widgets(GDiffFileViews *gfileviews);
extern void twopane_display(GDiffFileViews *gfileviews);
extern void twopane_show_linenum(GDiffFileViews *gfileviews, gboolean to_show);
extern void twopane_move_diff(GDiffFileViews *gfileviews, MoveDiff mv_diff);

	
#ifdef __cplusplus
} 
#endif /* __cplusplus */
 
#endif /* __GDIFF_FILEVIEW_H__ */
