/*
 * GUI actions module header
 *
 * Basically, every action by a user gets to one of functions in this module.
 * Every action that a user can do should be operated by menu-bar's menu.
 * See menu.c.
 * Moreover, some actions can be operated by right-click menu.
 * See rmenu.c.
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifndef __GDIFF_ACTIONS_H__
#define __GDIFF_ACTIONS_H__

#include "hide.h" /* for RowHideFunc */


#ifdef __cplusplus 
extern "C" {
#endif /* __cplusplus */

/* Global function declarations */
/* Actions for directory view */
extern void act_dv_show_path(GDiffDirViews *gdviews, gboolean b_show_path);
extern void act_dv_add_rowhide(GDiffDirViews *gdviews, RowHideFunc rh_func);
extern void act_dv_rowhide_stat(GDiffDirViews *gdviews, FilesSpecialStatus hide_mask, gboolean mask_on);
extern void act_dv_remove_rowhide(GDiffDirViews *gdviews, RowHideFunc rh_func);
extern void act_dv_reload(GDiffDirViews *gdviews);

/* Actions for file view */
extern void act_fv_mode_change(GDiffFileViews *gfviews, PaneMode mode);
extern void act_fv_linenum_show(GDiffFileViews *gfviews, gboolean to_show);
extern void act_fv_go_dirview(GDiffFileViews *gfviews);
extern void act_fv_toggle_textwrap(GDiffFileViews *gfviews, gboolean to_wrap);
extern void act_fv_move_diff(GDiffFileViews *gfviews, MoveDiff mv_diff);
extern void act_fv_reload(GDiffFileViews *gfviews);
extern void act_fv_edit_file(GDiffFileViews *gfviews, const char *filename);

#ifdef __cplusplus
} 
#endif /* __cplusplus */
 
#endif /* __GDIFF_ACTIONS_H__ */
