dnl eb.m4 --- Automake macros for working with EB library.
dnl Copyright (C) 1999 Keisuke Nishida <knishida@ring.gr.jp>
dnl  
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2, or (at your option)
dnl any later version.
dnl 
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl 
dnl You should have received a copy of the GNU General Public License
dnl along with this software; see the file COPYING.  If not, write to
dnl the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
dnl Boston, MA 02111-1307 USA

AC_DEFUN([EB_CONFIG],[
  AC_MSG_CHECKING(for EB)
  dnl
  dnl check for EB library
  dnl
  AC_ARG_WITH(eb-includes,
	      [  --with-eb-includes=DIR    EB include files are in DIR],
	      EB_INCLUDES=$withval, EB_INCLUDES=$includedir)

  AC_ARG_WITH(eb-libraries,
	      [  --with-eb-libraries=DIR   EB library files are in DIR],
	      EB_LIBRARIES=$withval, EB_LIBRARIES=$libdir)

  AC_ARG_WITH(zlib-includes,
	      [  --with-zlib-includes=DIR  zlib include files are in DIR],
	      ZLIB_INCLUDES=$withval, ZLIB_INCLUDES=$includedir)

  AC_ARG_WITH(zlib-libraries,
	      [  --with-zlib-libraries=DIR zlib library files are in DIR],
	      ZLIB_LIBRARIES=$withval, ZLIB_LIBRARIES=$libdir)

  EB_CFLAGS="-I$EB_INCLUDES"
  if test $EB_INCLUDES != $ZLIB_INCLUDES; then
    EB_CFLAGS="$EB_CFLAGS -I$ZLIB_INCLUDES"
  fi
  EB_LDADD="-L$EB_LIBRARIES"
  if test $EB_LIBRARIES != $ZLIB_LIBRARIES; then
    EB_LDADD="$EB_LDADD -L$ZLIB_LIBRARIES"
  fi
  EB_LDADD="$EB_LDADD -leb -lz"
  AC_SUBST(EB_CFLAGS)
  AC_SUBST(EB_LDADD)
  AC_MSG_RESULT(yes)
])
