/* ndscEventHandler.h	-- Henry Thompson
 *
 */

#ifndef _NDSCEVENTHANDLER_H
#define _NDSCEVENTHANDLER_H

#ifdef __GNUG__
#pragma interface
#endif

#include <stdio.h>
#include "Event.h"
#include "ErrorCountEventHandler.h"
#include "IQueue.h"
#include "StringC.h"
#include "Named.h"
#include "Dtd.h"

#define SHOULDNT fprintf(stderr,"Shouldn't happen: %s:%d\n",__FILE__,__LINE__)

/* default is to let the first specified type determine */
#ifndef DEF_STYPE
#define DEF_STYPE undef
#endif

#ifndef DSSSL_PID
#define DSSSL_PID "ISO/IEC 10179:1996//NOTATION DSSSL Architecture Definition Document//EN"
#endif

#ifdef SP_NAMESPACE
namespace SP_NAMESPACE {
#endif
  extern StringC makeStringC(const char *);

  class NamedSpec : public Named {
  public:
    NamedSpec(const StringC &name,StartElementEvent &event);
    StartElementEvent &specEvent_;
    IQueue<Event> bodyQueue_;
    IQueue<Event> declQueue_;
    Boolean isConref_;
  };

  class SpecResult  {
    friend class ndscEventHandler;
    friend class NdscApp;
  public:
    SpecResult();
    void noteDtd(const Dtd &dtd);
    NamedTable<NamedSpec> &specTable();
    const StringC *firstOne();
  private:
    NamedTable<NamedSpec> specTable_;
    const StringC *firstOne_;
    const ElementType *dssslSpecET_;
    const ElementType *extSpecET_;
    const ElementType *styleSpecET_;
    const ElementType *styleBodyET_;
    const ElementType *transSpecET_;
    const ElementType *transBodyET_;
    static const StringC dssslSpecSC_;
    static const StringC extSpecSC_;
    static const StringC styleSpecSC_;
    static const StringC styleBodySC_;
    static const StringC transSpecSC_;
    static const StringC transBodySC_;
  };

  class ndscEventHandler : public ErrorCountEventHandler {
  public:
    enum DataType {none,body,decl};
    /* features,baseset-encoding,literal-described-char,
       add-name-chars,add-separator-chars,standard-chars,
       other-chars,combin-char,map-sdata-entity,char-repertoire,
       sgml-grove-plan}; */
    ndscEventHandler(SpecResult &specResult);
    void startElement(StartElementEvent *event);
    void endElement(EndElementEvent *event);
    void data(DataEvent *event);
    void endProlog(EndPrologEvent *event);
    ~ndscEventHandler();
  private:
    static const StringC idStr_;
    static const StringC topStr_;
    static const StringC firstStr_;

    NamedSpec *curSpec_;
    DataType inElt_;
    SpecResult &specResult_;
  };

  class XndscEventHandler : public ndscEventHandler {
  public:
    XndscEventHandler(Messenger *,SpecResult &);
    void message(MessageEvent *);
    Messenger *messenger_;
  };


#ifdef SP_NAMESPACE
}
#endif

#endif
