/*
 * ndsc.C -- Henry S. Thompson
 * Derived from spam from the SP-1.1.1 by James Clark
 * Copyright (c) 1995, 1996 James Clark, Henry S. Thompson
 * See the file COPYING for copying permission.
 */

#ifndef lint
const char *rcsid =
"$Header: /home/ht/work/dsssl/dsc-1.0/src/RCS/ndsc.C,v 1.38 1997/01/27 14:45:22 ht Exp $";
#endif

extern "C" {
#include <unistd.h>
#include <stdio.h>
#include <errno.h>
#ifdef HAVE_STRNCASECMP
#include <string.h>
#else
extern int strncasecmp(const char *, const char *, size_t);
#endif
//
void elk_init_dread();
void elk_init_quantity();
};

#include "config.h"
#include "GroveApp.h"
#include "ArcEngine.h"
#include "InputSource.h"
#include "ErrnoMessageArg.h"
#include "NamedTable.h"
#include "Options.h"
#include "sptchar.h"
#include "macros.h"
//
#include "ndscEventHandler.h"
#include "ndscMessages.h"
#include "node.h"
#ifdef SP_NAMESPACE
using namespace SP_NAMESPACE;
#endif

// An internal interface application which parses and pre-processes a DSSSL spec
class NdscApp : public ParserApp {
public:
  NdscApp();
  enum SpecType {undef,style,transform};
  int run(int argc, AppChar **argv, int top=1,
	  const StringC *sid=0, const StringC *sn=0, SpecType st=DEF_STYPE);
  void processOption(AppChar opt, const AppChar *arg); // CmdLineApp
  int processOptions(int argc, AppChar **argv, int &firstArg); // CmdLineApp
  int procOpts(int argc, AppChar **argv, int &nextArg);
  StringC usageString(void);
  int processArguments(int argc, AppChar **argv); // CmdLineApp
  int generateEvents(ErrorCountEventHandler *eceh); // ParserApp
  void parseAll(class SgmlParser &,
		class EventHandler &,
		const volatile int *);
  ErrorCountEventHandler *makeEventHandler(); // ParserApp
  processResults(const StringC *specName);
  void out(const Char *ptr, unsigned n);
private:
  SpecResult specResult_;
  const StringC *specName_;
  const StringC *specSysId_;
  SpecType specType_;
  int top_;
  Boolean arcSpecified_;
  Boolean featUsage_;
  Boolean debugOutput_;
  // class variables
  static FILE *tmp;
  static char tmpname[L_tmpnam], buf[L_tmpnam + 20];
  static int optc_;
  static int argc_;
  static int specc_;
  static AppChar **argv_;
  static const StringC useStr_;
  static const StringC docStr_;
  static const StringC contentStr_;
  static const StringC specidStr_;
  static const StringC sepString_;
};

// a Grove application which processes the source document
class NDGApp : public GroveApp {
public:
  NDGApp(NdscApp::SpecType specType, Boolean debugOutput);
private:
  void processGrove();
  NdscApp::SpecType specType_;
  Boolean debugOutput_;
};

NDGApp::NDGApp(NdscApp::SpecType specType, Boolean debugOutput)
: specType_(specType), debugOutput_(debugOutput) {};

void NDGApp::processGrove() {
  // Hand over to scheme
  Set_Error_Tag("interpreting spec");
  GC_Node2;
  Object dodo,rno;
  GC_Link2(dodo,rno);
  (void)Funcall(dodo=(SYMBOL(Intern("dodsssl"))->value),
		Cons(rno=Make_Node(&*rootNode_),
		     Cons(Make_Integer(specType_),
			  Cons(debugOutput_?True:False,Null))),
		0);
}

// this expands to main(...)
SP_DEFINE_APP(NdscApp)

// class variable initialisations
const StringC NdscApp::useStr_(makeStringC("USE"));
const StringC NdscApp::docStr_(makeStringC("DOCUMENT"));
const StringC NdscApp::specidStr_(makeStringC("SPECID"));
const StringC NdscApp::contentStr_(makeStringC("CONTENT"));
const StringC NdscApp::sepString_(makeStringC("d!part-separator"));
FILE *NdscApp::tmp=0;
char NdscApp::tmpname[L_tmpnam], NdscApp::buf[L_tmpnam + 20];
int NdscApp::optc_;
int NdscApp::argc_;
int NdscApp::specc_;
CmdLineApp::AppChar **NdscApp::argv_;

NdscApp::NdscApp() : arcSpecified_(0), featUsage_(0), debugOutput_(0)
{
  registerOption('s', SP_T("spec_name"));
  registerOption('t', SP_T("spec_type"));
  registerOption('u'); // show feature usage
  registerOption('d'); // debug -- print internal forms and exit
}

// Called w/o defaults from above, with defaults in case of 'use'
int NdscApp::run(int argc, AppChar **argv, int top,
		 const StringC *sid, const StringC *sn, SpecType st) {

  specSysId_=sid;
  specName_=sn;
  specType_=st;
  top_=top;

  if (top) {
    argv_=argv;
    
    char *elk_argv[] = {argv[0],
			(char*)"-p",
			(char*)DSCSRCDIR,
			0};

    Set_App_Name(argv[0]);
    Elk_Init(3, elk_argv, 0, 0);
    Set_Error_Tag("loading dsc code");

    elk_init_dread();
    elk_init_node();
    elk_init_quantity();
    Load_File((char*)"ndsc-top.scm");

    // Put the output in a temporary file

    tmpnam(tmpname);
    tmp = fopen(tmpname, "w");
    if (!tmp) {
      message(tmpLosingError,
	      ErrnoMessageArg(errno));
      return 1;
    };
  };

  int parseWin=ParserApp::run(argc,argv);
  if (parseWin) {
    message(specLosingError);
    return parseWin;
  };

  int status=0;
  if (specName_) {
    status=processResults(specName_);
  }
  else if (specResult_.firstOne_) {
    status=processResults(specResult_.firstOne_);
  }
  else {
    message(emptySpecWarning);
  };

  if (top) {
    fclose(tmp);
  };

  if(status != 0)
      return status;

  if (top) {

    // Run read-spec on the file
  
    Set_Error_Tag("reading spec");
    GC_Node3;
    Object dsco,tso,epo;
    GC_Link3(dsco,tso,epo);
    (void)Funcall(dsco=(SYMBOL(Intern("dsc"))->value),
		  Cons(tso=Make_String(tmpname,strlen(tmpname)),
		       Cons(epo=Make_Port(0,stderr,Make_String("stderr",6)),
			    Cons(debugOutput_?True:False,
				 Cons(featUsage_?True:False,Null)))),
		  0);
    remove(tmpname);
    GC_Unlink;

    // Now read in the source SGML file if any

    if (specc_<argc) {
      NDGApp realapp(specType_,debugOutput_);
      argv[specc_]=argv[0];
      int rres=realapp.run(argc-specc_,argv+specc_);
      return rres;
    };
  };
  return 0;
}

int NdscApp::processResults(const StringC *specName) {
  NamedSpec *ns=NULL;
  Event *qe;
  unsigned n;
  if (!(ns=specResult_.specTable_.lookup(*specName))) {
    message(specNotFoundError,
	    StringMessageArg(*specName));
    return 1;
  };
  // Check for external Specs
  const AttributeList &atl(ns->specEvent_.attributes());
  if (ns->specEvent_.elementType()==specResult_.extSpecET_) {
    if (atl.attributeIndex(docStr_,n) && atl.specified(n)) {
      const AttributeSemantics *atsem=atl.semantics(n);
      if (atsem->nEntities()!=1) {SHOULDNT;};
      const ExternalEntity
	*ent=atsem->entity(0)->asExternalEntity();
      if (ent) {
	const StringC *sysid=ent->effectiveSystemIdPointer();
	if (!sysid) {
	  sysid=ent->systemIdPointer();
	};
	if (sysid) {
	  const StringC *specid=NULL;
	  if (atl.attributeIndex(specidStr_,n) && atl.specified(n)) {
	    const AttributeValue *specv=atl.value(n);
	    specid=new
	      StringC(((const TokenizedAttributeValue*)specv)->token(0));
	  };
	  NdscApp subapp;
	  int sv=subapp.run(optc_,argv_,0,sysid,specid,specType_);
	  if (sv) {
	    return sv;
	  };
	  // retrieve declarations?
	}
	else {
	  message(noEntityError,
		  StringMessageArg(*specName));
	  return 1;
	};
      }
      else {
	SHOULDNT;
      };
    }
    else {
      SHOULDNT;
    };
  }
  else {
    /* Should handle declarations at this point */
    // Check or set spec type
    SpecType thisType=(ns->specEvent_.elementType()==specResult_.styleSpecET_)
	 ?style:transform;
    switch (specType_) {
    case undef:
      specType_=thisType;
      break;
    default:
      if (thisType!=specType_) {
	message(specTypeWarning,
		StringMessageArg(ns->name()),
		StringMessageArg((specType_==style)?
		makeStringC("style"):
		makeStringC("transform")));
	return 0;
      };
      break;
    };
    // Check for conref
    if (ns->isConref_) {
      qe=ns->bodyQueue_.get();
      const AttributeList &atl(((StartElementEvent*)qe)->attributes());
      if (atl.attributeIndex(contentStr_,n) && atl.specified(n)) {
	const AttributeSemantics *atsem=atl.semantics(n);
	if (atsem->nEntities()!=1) {SHOULDNT;};
	const InternalEntity *ient=atsem->entity(0)->asInternalEntity();
	if (ient) {
	  out(ient->string().data(),ient->string().size());
	}
	else {
	  const ExternalEntity *eent=atsem->entity(0)->asExternalEntity();
	  if (eent) {
	    const StringC *sysid=eent->effectiveSystemIdPointer();
	    if (!sysid) {
	      sysid=eent->systemIdPointer();
	    };
	    if (sysid) {
	      InputSource *in = entityManager()->open(*sysid,
						      systemCharset_,
						      new InputSourceOrigin,
						      0,
						      *this);
	      if (!in)
		return 1;
	      for (;;) {
		Xchar c = in->get(*this);
		if (c == InputSource::eE)
		  break;
		in->extendToBufferEnd();
		out(in->currentTokenStart(), in->currentTokenLength());
	      };
	    }
	    else {
	      SHOULDNT;
	    };
	  }
	  else {
	    SHOULDNT;
	  };
	};
      }
      else {
	SHOULDNT;
      };
      delete qe;
    }
    else {
      while (!ns->bodyQueue_.empty()) {
	qe=ns->bodyQueue_.get();
	out(((DataEvent*)qe)->data(),((DataEvent*)qe)->dataLength());
	delete qe;
      };
    };
    // Check for 'use' attribute
    if (atl.attributeIndex(useStr_,n) && atl.specified(n)) {
      const AttributeValue *usev=atl.value(n);
      unsigned nt = ((TokenizedAttributeValue*)usev)->nTokens();
      for (unsigned i = 0; i<nt; i++) {
	out(sepString_.data(),sepString_.size());
	putc('\n',tmp);
	processResults(new StringC(((TokenizedAttributeValue*)usev)->token(i)));
      };
    };
  };

  return 0;
}

// Downsize to 8-bit chars for now
void NdscApp::out(const Char *ptr, unsigned n) {
#if 0
      fwrite(ptr, 1, n, tmp);
#else
      for (; n>0; n--,ptr++) {
	putc(*ptr == '\r' ? '\n' : *ptr, tmp);
      };
#endif
}

int NdscApp::processArguments(int argc, AppChar **argv) {
  if (top_) {
    return EntityApp::processArguments(specc_-optc_,argv+optc_);
  }
  else {
    return processSysid(*specSysId_);
  };
}

int NdscApp::processOptions(int argc, AppChar **argv, int &firstArg) {
  /* need to catch firstArg on the way out to exclude arguments from sub-proc
     and to partition args */
  int myfirst,res,i;
  if (top_) {
    argc_=argc;
    for (i=0;i<argc;i++) {
      if (!strcmp(argv[i],"-+")) {
	break;
      };
    };
    specc_=i;
  };
  res=procOpts(specc_, argv, myfirst);
  if (top_) {
    optc_=myfirst;
  };
  firstArg=0; /* we do our own fix at processArguments, so bypass the one
		 in CmdLineApp::run */
  if (!arcSpecified_) {
    processOption('A',"dsssl"); // provide a default
  };
  return res;
};
  
/* Copied from first half of CmdLineOpts::processOptions, in order
   to provide own usage message (note usageString() is NOT virtual */
int NdscApp::procOpts(int argc, AppChar **argv, int &nextArg) {
  AppChar ostr[2];
  optstr_ += SP_T('\0');
  Options<AppChar> options(argc, argv, optstr_.data());
  AppChar opt;
  while (options.get(opt)) {
    switch (opt) {
    case ':':
      ostr[0] = options.opt();
      ostr[1] = SP_T('\0');
      message(CmdLineAppMessages::missingOptionArgError,
	      StringMessageArg(convertInput(ostr)));
      message(CmdLineAppMessages::usage,
	      StringMessageArg(usageString()));
      return 1;
    case '?':
      ostr[0] = options.opt();
      ostr[1] = SP_T('\0');
      message(CmdLineAppMessages::invalidOptionError,
	      StringMessageArg(convertInput(ostr)));
      message(CmdLineAppMessages::usage,
	      StringMessageArg(usageString()));
      return 1;
    default:
      processOption(opt, options.arg());
      break;
    }
  }
  nextArg = options.ind();
  int dummy;
  return CmdLineApp::processOptions(0,0,dummy); // to get output streams right
}

StringC NdscApp::usageString() {
  StringC newu(CmdLineApp::usageString());
  newu.resize(newu.size()-8); // get rid of sysid...
  /* cheat like hell to get rid of my switches */
  optstr_.resize(optstr_.size()-7); // why 7 and not 6???
  StringC *tmp=&CmdLineApp::usageString();
  unsigned i;
  for (i=0;(char)((*tmp)[i])!=' ';i++); // find end of progName
  StringC rest(tmp->data()+i,tmp->size()-i);
  rest.resize(rest.size()-8); // get rid of sysid...
  newu+=(makeStringC("spec sysid... [-+"));
  rest+=(makeStringC("source sysid...]
In short:  dsc spec_switches_and_ids [-+ source_switches_and_ids]
Switches are all standard SP application switches, plus, for spec only:
 -d Produce debugging output on stdout;
 -u Produce feature summary on stderr;
 -s <id>: ID of specification to use (defaults to first in document);
 -t <type>: Type of spec/dsssl operation (style/transform)
             (defaults to type of spec. found in document)."));
  return newu+=(rest);
};

void NdscApp::processOption(AppChar opt, const AppChar *arg)
{
  switch (opt) {
  case 's':
    // ignore command line if we've got a value already (for sub-cases)
    if (!specName_) {
      for (unsigned i = 0; arg[i] != SP_T('\0'); i++) {
	SP_TUCHAR c = totupper(SP_TUCHAR(arg[i]));
#ifdef SP_WIDE_SYSTEM
	if (c > (unsigned char)-1)
	  return 0;
#endif
	((AppChar *)arg)[i] = char(c);
      }
      specName_=new StringC(convertInput(arg));
    };
    break;
  case 't':
    if (specType_==undef) {
      if (!strncasecmp(arg,"style",5)) {
	specType_=style;
      }
      else if (!strncasecmp(arg,"transform",9)) {
	specType_=transform;
      }
      else {
	message(typeArgWarning,
		StringMessageArg(convertInput(arg)));
      };
    };
    break;
  case 'd':
    debugOutput_=1;
    break;
  case 'u':
    featUsage_=1;
    break;
  case 'A':
    arcSpecified_=1; // fall through
  default:
    ParserApp::processOption(opt, arg);
    break;
  }
}

// Shadow this so we can check Public ID for Architecture is correct
class  NdscSelectOneArcDirector : public SelectOneArcDirector {
public:
  NdscSelectOneArcDirector(const Vector<StringC> &select, EventHandler &eh);
  EventHandler *arcEventHandler(const Notation *,
				const Vector<StringC> &,
				const SubstTable<Char> *);
private:
  static const StringC dssslPid_;
};

// exact copy of ParserApp version, here to allow our parseAll to shadow
int NdscApp::generateEvents(ErrorCountEventHandler *eceh)
{
  Owner<EventHandler> eh(eceh);
  parseAll(parser_, *eh, eceh->cancelPtr());
  unsigned errorCount = eceh->errorCount();
  if (errorLimit_ != 0 && errorCount >= errorLimit_)
    message(errorLimitExceeded,
	    NumberMessageArg(errorLimit_));
  return errorCount > 0;
}

void NdscApp::parseAll(SgmlParser &parser,
			 EventHandler &eh,
			 const volatile sig_atomic_t *cancelPtr)
{
  if (arcNames_.size() > 0) {
    NdscSelectOneArcDirector director(arcNames_, eh);
    ArcEngine::parseAll(parser, director, director, cancelPtr);
  }
  else {
    SHOULDNT;
  };
}

NdscSelectOneArcDirector::NdscSelectOneArcDirector(
    const Vector<StringC> &select,
    EventHandler &eh) : SelectOneArcDirector(select,eh) {
};

const StringC NdscSelectOneArcDirector::dssslPid_(
					  makeStringC(DSSSL_PID));

// Called twice, second time when notation is non-NULL is time we check
EventHandler *NdscSelectOneArcDirector::arcEventHandler(
			      const Notation *notation,
			      const Vector<StringC> &name,
			      const SubstTable<Char> *table) {
  if (!notation || (dssslPid_==*notation->publicIdPointer())) {
    return SelectOneArcDirector::arcEventHandler(notation,name,table);
  }
  else {
    message(badArchError,
	    StringMessageArg(dssslPid_),
	    StringMessageArg(*notation->publicIdPointer()));
    return NULL;
  };
}
    

ErrorCountEventHandler *NdscApp::makeEventHandler()
{
  return new XndscEventHandler(this,specResult_);
}

XndscEventHandler::XndscEventHandler(Messenger *mgr,SpecResult &specResult)
: messenger_(mgr),
  ndscEventHandler(specResult)
{
}

void XndscEventHandler::message(MessageEvent *event)
{
  messenger_->dispatchMessage(event->message());
  ndscEventHandler::message(event);
}
