## -*- perl -*-
## ----------------------------------------------------------------------
## DebianDoc_SGML/Map/LaTeX: Data map for LaTeX output format
## ----------------------------------------------------------------------
## Copyright (C) 1999,2000 Ardo van Rangelrooij
##
## This is free software; see the GNU General Public Licence
## version 2 or later for copying conditions.  There is NO warranty.
## ----------------------------------------------------------------------

## ----------------------------------------------------------------------
## package interface definition
#package DebianDoc_SGML::Map::LaTeX;
#use strict;
#use vars qw( @ISA @EXPORT );
#use Exporter;
#@ISA = ( 'Exporter' );
#@EXPORT = qw ();

## ----------------------------------------------------------------------
%sdata_mapping = (
		  "[acute]" => "\\'",
		  "[breve]" => "\\u{",
		  "[caron]" => "\\{caron\\}",
		  "[cedil]" => "\\c{",
		  "[circ]" => "\\^{}",
		  "[dblac]" => "\\{dblac\\}",
		  "[die]" => "\\\"",
		  "[dot]" => "\\.",
		  "[grave]" => "\\`",
		  "[macr]" => "\\=",
		  "[ogon]" => "\\{ogon\\}",
		  "[ring]" => "\\accent23",
		  "[tilde]" => "\\~{}",
		  "[uml]" => "\\\"",
		  "[aacute]" => "\\'a",
		  "[Aacute]" => "\\'A",
		  "[acirc]" => "\\^a",
		  "[Acirc]" => "\\^A",
		  "[agrave]" => "\\`a",
		  "[Agrave]" => "\\`A",
		  "[aring]" => "\\aa{}",
		  "[Aring]" => "\\AA{}",
		  "[atilde]" => "\\~a",
		  "[Atilde]" => "\\~A",
		  "[auml]" => "\\\"a",
		  "[Auml]" => "\\\"A",
		  "[aelig]" => "\\ae{}",
		  "[AElig]" => "\\AE{}",
		  "[ccedil]" => "\\c c",
		  "[Ccedil]" => "\\c C",
		  "[eth]" => "\\dh{}",
		  "[ETH]" => "\\DH{}",
		  "[eacute]" => "\\'e",
		  "[Eacute]" => "\\'E",
		  "[ecirc]" => "\\^e",
		  "[Ecirc]" => "\\^E",
		  "[egrave]" => "\\`e",
		  "[Egrave]" => "\\`E",
		  "[euml]" => "\\\"e",
		  "[Euml]" => "\\\"E",
		  "[iacute]" => "\\'\\i{}",
		  "[Iacute]" => "\\'I",
		  "[icirc]" => "\\^\\i{}",
		  "[Icirc]" => "\\^I",
		  "[igrave]" => "\\`\\i{}",
		  "[Igrave]" => "\\`I",
		  "[iuml]" => "\\\"\\i{}",
		  "[Iuml]" => "\\\"I",
		  "[ntilde]" => "\\~n",
		  "[Ntilde]" => "\\~N",
		  "[oacute]" => "\\'o",
		  "[Oacute]" => "\\'O",
		  "[ocirc]" => "\\^o",
		  "[Ocirc]" => "\\^O",
		  "[ograve]" => "\\`o",
		  "[Ograve]" => "\\`O",
		  "[oslash]" => "\\o{}",
		  "[Oslash]" => "\\O{}",
		  "[otilde]" => "\\~o",
		  "[Otilde]" => "\\~O",
		  "[ouml]" => "\\\"o",
		  "[Ouml]" => "\\\"O",
		  "[szlig]" => "\\ss{}",
		  "[thorn]" => "\\th{}",
		  "[THORN]" => "\\TH{}",
		  "[uacute]" => "\\'u",
		  "[Uacute]" => "\\'U",
		  "[ucirc]" => "\\^u",
		  "[Ucirc]" => "\\^U",
		  "[ugrave]" => "\\`u",
		  "[Ugrave]" => "\\`U",
		  "[uuml]" => "\\\"u",
		  "[Uuml]" => "\\\"U",
		  "[yacute]" => "\\'y",
		  "[Yacute]" => "\\'Y",
		  "[yuml]" => "\\\"y",
		  "[abreve]" => "\\u a",
		  "[Abreve]" => "\\u A",
		  "[amacr]" => "\\=a",
		  "[Amacr]" => "\\=A",
		  "[aogon]" => "\\{aogon\\}",
		  "[Aogon]" => "\\{Aogon\\}",
		  "[cacute]" => "\\'c",
		  "[Cacute]" => "\\'C",
		  "[ccaron]" => "\\{ccaron\\}",
		  "[Ccaron]" => "\\{Ccaron\\}",
		  "[ccirc]" => "\\^c",
		  "[Ccirc]" => "\\^C",
		  "[cdot]" => "\\.c",
		  "[Cdot]" => "\\.C",
		  "[dcaron]" => "\\{dcaron\\}",
		  "[Dcaron]" => "\\{Dcaron\\}",
		  "[dstrok]" => "\\{dstrok\\}",
		  "[Dstrok]" => "\\{Dstrok\\}",
		  "[ecaron]" => "\\{ecaron\\}",
		  "[Ecaron]" => "\\{Ecaron\\}",
		  "[edot]" => "\\.e",
		  "[Edot]" => "\\.E",
		  "[emacr]" => "\\=e",
		  "[Emacr]" => "\\=E",
		  "[eogon]" => "\\{eogon\\}",
		  "[Eogon]" => "\\{Eogon\\}",
		  "[gacute]" => "\\'g",
		  "[gbreve]" => "\\u g",
		  "[Gbreve]" => "\\u G",
		  "[Gcedil]" => "\\c G",
		  "[gcirc]" => "\\^g",
		  "[Gcirc]" => "\\^G",
		  "[gdot]" => "\\.g",
		  "[Gdot]" => "\\.G",
		  "[hcirc]" => "\\^h",
		  "[Hcirc]" => "\\^H",
		  "[hstrok]" => "\\{hstrok\\}",
		  "[Hstrok]" => "\\{Hstrok\\}",
		  "[Idot]" => "\\.I",
		  "[Imacr]" => "\\=I",
		  "[imacr]" => "\\=\\i{}",
		  "[ijlig]" => "ij",
		  "[IJlig]" => "IJ",
		  "[inodot]" => "\\i{}",
		  "[iogon]" => "\\{iogon\\}",
		  "[Iogon]" => "\\{Iogon\\}",
		  "[itilde]" => "\\~\\i{}",
		  "[Itilde]" => "\\~I",
		  "[jcirc]" => "\\^\\j{}",
		  "[Jcirc]" => "\\^J",
		  "[kcedil]" => "\\c k",
		  "[Kcedil]" => "\\c K",
		  "[kgreen]" => "\\{kgreen\\}",
		  "[lacute]" => "\\'l",
		  "[Lacute]" => "\\'L",
		  "[lcaron]" => "\\{lcaron\\}",
		  "[Lcaron]" => "\\{Lcaron\\}",
		  "[lcedil]" => "\\c l",
		  "[Lcedil]" => "\\c L",
		  "[lmidot]" => "\\{lmidot\\}",
		  "[Lmidot]" => "\\{Lmidot\\}",
		  "[lstrok]" => "\\{lstrok\\}",
		  "[Lstrok]" => "\\{Lstrok\\}",
		  "[nacute]" => "\\'n",
		  "[Nacute]" => "\\'N",
		  "[eng]" => "\\{eng\\}",
		  "[ENG]" => "\\{ENG\\}",
		  "[napos]" => "\\{napos\\}",
		  "[ncaron]" => "\\{ncaron\\}",
		  "[Ncaron]" => "\\{Ncaron\\}",
		  "[ncedil]" => "\\c n",
		  "[Ncedil]" => "\\c N",
		  "[odblac]" => "\\{odblac\\}",
		  "[Odblac]" => "\\{Odblac\\}",
		  "[Omacr]" => "\\=O",
		  "[omacr]" => "\\=o",
		  "[oelig]" => "\\oe{}",
		  "[OElig]" => "\\OE{}",
		  "[racute]" => "\\'r",
		  "[Racute]" => "\\'R",
		  "[rcaron]" => "\\{rcaron\\}",
		  "[Rcaron]" => "\\{Rcaron\\}",
		  "[rcedil]" => "\\c r",
		  "[Rcedil]" => "\\c R",
		  "[sacute]" => "\\'s",
		  "[Sacute]" => "\\'S",
		  "[scaron]" => "\\{scaron\\}",
		  "[Scaron]" => "\\{Scaron\\}",
		  "[scedil]" => "\\c s",
		  "[Scedil]" => "\\c S",
		  "[scirc]" => "\\^s",
		  "[Scirc]" => "\\^S",
		  "[tcaron]" => "\\{tcaron\\}",
		  "[Tcaron]" => "\\{Tcaron\\}",
		  "[tcedil]" => "\\c t",
		  "[Tcedil]" => "\\c T",
		  "[tstrok]" => "\\{tstrok\\}",
		  "[Tstrok]" => "\\{Tstrok\\}",
		  "[ubreve]" => "\\u u",
		  "[Ubreve]" => "\\u U",
		  "[udblac]" => "\\{udblac\\}",
		  "[Udblac]" => "\\{Udblac\\}",
		  "[umacr]" => "\\=u",
		  "[Umacr]" => "\\=U",
		  "[uogon]" => "\\{uogon\\}",
		  "[Uogon]" => "\\{Uogon\\}",
		  "[uring]" => "\\accent23u",
		  "[Uring]" => "\\accent23U",
		  "[utilde]" => "\\~u",
		  "[Utilde]" => "\\~U",
		  "[wcirc]" => "\\^w",
		  "[Wcirc]" => "\\^W",
		  "[ycirc]" => "\\^y",
		  "[Ycirc]" => "\\^Y",
		  "[Yuml]" => "\\\"Y",
		  "[zacute]" => "\\'z",
		  "[Zacute]" => "\\'Z",
		  "[zcaron]" => "\\{zcaron\\}",
		  "[Zcaron]" => "\\{Zcaron\\}",
		  "[zdot]" => "\\.z",
		  "[Zdot]" => "\\.Z",
		  "[half]" => "\\(\\scriptstyle{1\\over2}\\)",
		  "[frac12]" => "\\(\\frac{1}{2}\\)",
		  "[frac14]" => "\\(\\frac{1}{4}\\)",
		  "[frac34]" => "\\(\\frac{3}{4}\\)",
		  "[frac18]" => "\\(\\frac{1}{8}\\)",
		  "[frac38]" => "\\(\\frac{3}{8}\\)",
		  "[frac58]" => "\\(\\frac{5}{8}\\)",
		  "[frac78]" => "\\(\\frac{7}{8}\\)",
		  "[sup1]" => "\\(^1\\)",
		  "[sup2]" => "\\(^2\\)",
		  "[sup3]" => "\\(^3\\)",
		  "[plus]" => "\\(+\\)",
		  "[plusmn]" => "\\(\\pm\\)",
		  "[lt]" => "\\(<\\)",
		  "[equals]" => "\\(=\\)",
		  "[gt]" => "\\(>\\)",
		  "[divide]" => "\\(\\div\\)",
		  "[times]" => "\\(\\times\\)",
		  "[curren]" => "\\{curren\\}",
		  "[pound]" => "\\pounds{}",
		  "[dollar]" => "\\\$",
		  "[cent]" => "\\{cent\\}",
		  "[yen]" => "\\{yen\\}",
		  "[num]" => "\\#",
		  "[percnt]" => "\\%",
		  "[amp]" => "\\&",
		  "[ast]" => "*",
		  "[commat]" => "@",
		  "[lsqb]" => "{[}",
		  "[bsol]" => "\\(\\backslash\\)",
		  "[rsqb]" => "{]}",
		  "[lcub]" => "\\(\\{\\)",
		  "[horbar]" => "{--}",
		  "[verbar]" => "\\(|\\)",
		  "[rcub]" => "\\(\\}\\)",
		  "[micro]" => "\\(\\mu\\)",
		  "[ohm]" => "\\(\\Omega\\)",
		  "[deg]" => "\\(^\\circ\\)",
		  "[ordm]" => "\\(^{\\underline{o}}\\)",
		  "[ordf]" => "\\(^{\\underline{a}}\\)",
		  "[sect]" => "\\S{}",
		  "[para]" => "\\P{}",
		  "[middot]" => "\\(\\cdot\\)",
		  "[larr]" => "\\(\\leftarrow\\)",
		  "[rarr]" => "\\(\\rightarrow\\)",
		  "[uarr]" => "\\(\\uparrow\\)",
		  "[darr]" => "\\(\\downarrow\\)",
		  "[copy]" => "\\copyright{}",
		  "[reg]" => "\\textregistered{}",
		  "[trade]" => "\\texttrademark{}",
		  "[brvbar]" => "\\{brvbar\\}",
		  "[not]" => "\\(\\neg\\)",
		  "[sung]" => "\\{sung\\}",
		  "[excl]" => "!",
		  "[iexcl]" => "{!`}",
		  "[quot]" => "{\\tt\\char`\\\"}",
		  "[apos]" => "'",
		  "[lpar]" => "(",
		  "[rpar]" => ")",
		  "[comma]" => ",",
		  "[lowbar]" => "\\_",
		  "[hyphen]" => "-",
		  "[period]" => ".",
		  "[sol]" => "/",
		  "[colon]" => ":",
		  "[semi]" => ";",
		  "[quest]" => "?",
		  "[iquest]" => "{?`}",
		  "[laquo]" => "\\(<<\\)",
		  "[raquo]" => "\\(>>\\)",
		  "[lsquo]" => "{`}",
		  "[rsquo]" => "{'}",
		  "[ldquo]" => "{``}",
		  "[rdquo]" => "{''}",
		  "[nbsp]" => "~",
		  "[shy]" => "\\-",
		  "[emsp]" => "\\hskip1em",
		  "[ensp]" => "\\hskip0.5em",
		  "[numsp]" => "\\hskip0.5em",
		  "[puncsp]" => "\\hskip0.25em",
		  "[thinsp]" => "\\hskip0.16667em",
		  "[hairsp]" => "\\hskip0.08333em",
		  "[mdash]" => "{---}",
		  "[ndash]" => "{--}",
		  "[dash]" => "\\(-\\)",
		  "[blank]" => "{\\tt\\char\"20}",
		  "[hellip]" => "\\(\\ldots\\)",
		  "[nldr]" => "\\{nldr\\}",
		  "[frac13]" => "\\sfrac1/3",
		  "[frac23]" => "\\sfrac2/3",
		  "[frac15]" => "\\sfrac1/5",
		  "[frac25]" => "\\sfrac2/5",
		  "[frac35]" => "\\sfrac3/5",
		  "[frac45]" => "\\sfrac4/5",
		  "[frac16]" => "\\sfrac1/6",
		  "[frac56]" => "\\sfrac5/6",
		  "[incare]" => "\\{incare\\}",
		  "[block]" => "\\{block\\}",
		  "[uhblk]" => "\\{uhblk\\}",
		  "[lhblk]" => "\\{lhblk\\}",
		  "[blk14]" => "\\{blk14\\}",
		  "[blk12]" => "\\{blk12\\}",
		  "[blk34]" => "\\{blk34\\}",
		  "[marker]" => "\\{marker\\}",
		  "[cir]" => "\\(\\mathchar\"20E\\)",
		  "[squ]" => "\\{squ\\}",
		  "[rect]" => "\\{rect\\}",
		  "[utri]" => "\\(\\bigtriangleup\\)",
		  "[dtri]" => "\\(\\bigtriangledown\\)",
		  "[star]" => "\\{star\\}",
		  "[bull]" => "\\(\\bullet\\)",
		  "[squf]" => "\\squf{}",
		  "[utrif]" => "\\{utrif\\}",
		  "[dtrif]" => "\\{dtrif\\}",
		  "[ltrif]" => "\\{ltrif\\}",
		  "[rtrif]" => "\\{rtrif\\}",
		  "[clubs]" => "\\(\\clubsuit\\)",
		  "[diams]" => "\\(\\diamondsuit\\)",
		  "[hearts]" => "\\(\\heartsuit\\)",
		  "[spades]" => "\\(\\spadesuit\\)",
		  "[malt]" => "\\{malt\\}",
		  "[dagger]" => "\\(\\dag\\)",
		  "[Dagger]" => "\\(\\ddag\\)",
		  "[check]" => "\\(\\surd\\)",
		  "[sharp]" => "\\(\\sharp\\)",
		  "[flat]" => "\\(\\flat\\)",
		  "[male]" => "\\male{}",
		  "[female]" => "\\female{}",
		  "[phone]" => "\\{phone\\}",
		  "[telrec]" => "\\{telrec\\}",
		  "[copysr]" => "\\{copysr\\}",
		  "[caret]" => "\\(\\mathchar\"1356\\)",
		  "[lsquor]" => "\\quotesinglbase{}",
		  "[ldquor]" => "\\quotedblbase{}",
		  "[fflig]" => "{ff}",
		  "[filig]" => "{fi}",
		  "[fjlig]" => "{fj}",
		  "[ffilig]" => "{ffi}",
		  "[ffllig]" => "{ffl}",
		  "[fllig]" => "{fl}",
		  "[mldr]" => "\\{mldr\\}",
		  "[rdquor]" => "{''}",
		  "[rsquor]" => "{'}",
		  "[vellip]" => "\\(\\vdots\\)",
		  "[hybull]" => "\\hybull{}",
		  "[loz]" => "\\{loz\\}",
		  "[lozf]" => "\\{lozf\\}",
		  "[ltri]" => "\\(\\triangleleft\\)",
		  "[rtri]" => "\\(\\triangleright\\)",
		  "[starf]" => "\\(\\star\\)",
		  "[natur]" => "\\(\\natural\\)",
		  "[rx]" => "\\{rx\\}",
		  "[sext]" => "\\{sext\\}",
		  "[target]" => "\\(\\mathchar\"2208\\)",
		  "[dlcrop]" => "\\{dlcrop\\}",
		  "[drcrop]" => "\\{drcrop\\}",
		  "[ulcrop]" => "\\{ulcrop\\}",
		  "[urcrop]" => "\\{urcrop\\}",
		  "[aleph]" => "\\(\\aleph\\)",
		  "[and]" => "\\(\\land\\)",
		  "[ang90]" => "\\{ang90\\}",
		  "[angsph]" => "\\{angsph\\}",
		  "[ap]" => "\\(\\approx\\)",
		  "[becaus]" => "\\{becaus\\}",
		  "[bottom]" => "\\(\\perp\\)",
		  "[cap]" => "\\(\\cap\\)",
		  "[cong]" => "\\(\\cong\\)",
		  "[conint]" => "\\(\\oint\\)",
		  "[cup]" => "\\(\\cup\\)",
		  "[equiv]" => "\\(\\equiv\\)",
		  "[exist]" => "\\(\\exists\\)",
		  "[forall]" => "\\(\\forall\\)",
		  "[fnof]" => "\\(f\\)",
		  "[ge]" => "\\(\\geq\\)",
		  "[iff]" => "iff.",
		  "[infin]" => "\\(\\infty\\)",
		  "[int]" => "\\(\\int\\)",
		  "[isin]" => "\\(\\in\\)",
		  "[lang]" => "\\(\\langle\\)",
		  "[lArr]" => "\\(\\Leftarrow\\)",
		  "[le]" => "\\(\\leq\\)",
		  "[minus]" => "\\(-\\)",
		  "[mnplus]" => "\\(\\mp\\)",
		  "[nabla]" => "\\(\\nabla\\)",
		  "[ne]" => "\\(\\not=\\)",
		  "[ni]" => "\\(\\ni\\)",
		  "[or]" => "\\(\\vee\\)",
		  "[par]" => "\\(\\parallel\\)",
		  "[part]" => "\\(\\partial\\)",
		  "[permil]" => "\\{permil\\}",
		  "[perp]" => "\\(\\perp\\)",
		  "[prime]" => "\\(^\\prime\\)",
		  "[Prime]" => "\\(^{\\prime\\prime}\\)",
		  "[prop]" => "\\(\\propto\\)",
		  "[radic]" => "\\(\\surd\\)",
		  "[rang]" => "\\(\\rangle\\)",
		  "[rArr]" => "\\(\\Rightarrow\\)",
		  "[sim]" => "\\(\\sim\\)",
		  "[sime]" => "\\(\\simeq\\)",
		  "[square]" => "\\{square\\}",
		  "[sub]" => "\\(\\subset\\)",
		  "[sube]" => "\\(\\subseteq\\)",
		  "[sup]" => "\\(\\supset\\)",
		  "[supe]" => "\\(\\supseteq\\)",
		  "[there4]" => "\\{there4\\}",
		  "[Verbar]" => "\\(\\Vert\\)",
		  "[angst]" => "\\AA{}",
		  "[bernou]" => "\\(\\cal B\\)",
		  "[compfn]" => "\\(\\circ\\)",
		  "[Dot]" => "\\\"{}",
		  "[DotDot]" => "\\{DotDot\\}",
		  "[hamilt]" => "\\(\\cal H\\)",
		  "[lagran]" => "\\(\\cal L\\)",
		  "[lowast]" => "\\{lowast\\}",
		  "[notin]" => "\\(\\not\\in\\)",
		  "[order]" => "\\{order\\}",
		  "[phmmat]" => "\\(\\cal M\\)",
		  "[tdot]" => "\\{tdot\\}",
		  "[tprime]" => "\\(^{\\prime\\prime\\prime}\\)",
		  "[wedgeq]" => "\\{wedgeq\\}",
		  );

## ----------------------------------------------------------------------
## don't forget this
1;

## ----------------------------------------------------------------------
