;; $Id: dbl1ro.dsl,v 1.1.1.2 1999/08/27 21:21:10 rosalia Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://nwalsh.com/docbook/dsssl/
;;

;; ----------------------------- Localization -----------------------------

;; If you create a new version of this file, please send it to
;; Norman Walsh, ndw@nwalsh.com

;; Provided by Dan N. Pomohaci

(define (ro-appendix-xref-string gi-or-name)
  (if %chapter-autolabel%
      "&Appendix; %n"
      "the &appendix; called %t"))

(define (ro-article-xref-string gi-or-name)
  (string-append %gentext-ro-start-quote%
		 "%t"
		 %gentext-ro-end-quote%))

(define (ro-bibliography-xref-string gi-or-name)
  "%t")

(define (ro-book-xref-string gi-or-name)
  "%t")

(define (ro-chapter-xref-string gi-or-name)
  (if %chapter-autolabel%
      "&Chapter; %n"
      "the &chapter; called %t"))

(define (ro-equation-xref-string gi-or-name)
  "(%n)")

(define (ro-example-xref-string gi-or-name)
  "&Example; %n")

(define (ro-figure-xref-string gi-or-name)
  "&Figure; %n")

(define (ro-glossary-xref-string gi-or-name)
  "%t")

(define (ro-index-xref-string gi-or-name)
  "%t")

(define (ro-listitem-xref-string gi-or-name)
  "%n")

(define (ro-part-xref-string gi-or-name)
  "&Part; %n")

(define (ro-preface-xref-string gi-or-name)
  "%t")

(define (ro-procedure-xref-string gi-or-name)
  "&Procedure; %n, %t")

(define (ro-reference-xref-string gi-or-name)
  "&Reference; %n, %t")

(define (ro-section-xref-string gi-or-name)
  (if %section-autolabel% 
      "&Section; %n" 
      "&section; numit\U-0103; %t"))

(define (ro-sect1-xref-string gi-or-name)
  (ro-section-xref-string gi-or-name))

(define (ro-sect2-xref-string gi-or-name)
  (ro-section-xref-string gi-or-name))

(define (ro-sect3-xref-string gi-or-name)
  (ro-section-xref-string gi-or-name))

(define (ro-sect4-xref-string gi-or-name)
  (ro-section-xref-string gi-or-name))

(define (ro-sect5-xref-string gi-or-name)
  (ro-section-xref-string gi-or-name))

(define (ro-sidebar-xref-string gi-or-name)
  "&sidebar; %t")

(define (ro-step-xref-string gi-or-name)
  "&step; %n")

(define (ro-table-xref-string gi-or-name)
  "&Table; %n")

(define (ro-default-xref-string gi-or-name)
  (let* ((giname (if (string? gi-or-name) gi-or-name (gi gi-or-name)))
	 (msg    (string-append "[&xrefto; "
				(if giname giname "&nonexistantelement;")
				" &unsupported;]"))
	 (err    (node-list-error msg (current-node))))
    msg))

(define (gentext-ro-xref-strings gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
      ((equal? name (normalize "appendix")) (ro-appendix-xref-string gind))
      ((equal? name (normalize "article"))  (ro-article-xref-string gind))
      ((equal? name (normalize "bibliography")) (ro-bibliography-xref-string gind))
      ((equal? name (normalize "book"))     (ro-book-xref-string gind))
      ((equal? name (normalize "chapter"))  (ro-chapter-xref-string gind))
      ((equal? name (normalize "equation")) (ro-equation-xref-string gind))
      ((equal? name (normalize "example"))  (ro-example-xref-string gind))
      ((equal? name (normalize "figure"))   (ro-figure-xref-string gind))
      ((equal? name (normalize "glossary")) (ro-glossary-xref-string gind))
      ((equal? name (normalize "index"))    (ro-index-xref-string gind))
      ((equal? name (normalize "listitem")) (ro-listitem-xref-string gind))
      ((equal? name (normalize "part"))     (ro-part-xref-string gind))
      ((equal? name (normalize "preface"))  (ro-preface-xref-string gind))
      ((equal? name (normalize "procedure")) (ro-procedure-xref-string gind))
      ((equal? name (normalize "reference")) (ro-reference-xref-string gind))
      ((equal? name (normalize "sect1"))    (ro-sect1-xref-string gind))
      ((equal? name (normalize "sect2"))    (ro-sect2-xref-string gind))
      ((equal? name (normalize "sect3"))    (ro-sect3-xref-string gind))
      ((equal? name (normalize "sect4"))    (ro-sect4-xref-string gind))
      ((equal? name (normalize "sect5"))    (ro-sect5-xref-string gind))
      ((equal? name (normalize "sidebar"))  (ro-sidebar-xref-string gind))
      ((equal? name (normalize "step"))     (ro-step-xref-string gind))
      ((equal? name (normalize "table"))    (ro-table-xref-string gind))
      (else (ro-default-xref-string gind)))))

(define (ro-auto-xref-indirect-connector before) 
    (literal " &in; "))

;; Should the TOC come first or last?
;;
(define %generate-ro-toc-in-front% #t)

;; gentext-element-name returns the generated text that should be 
;; used to make reference to the selected element.
;;
(define ro-abstract-name	"&Abstract;")
(define ro-appendix-name	"&Appendix;")
(define ro-article-name	"&Article;")
(define ro-bibliography-name	"&Bibliography;")
(define ro-book-name		"&Book;")
(define ro-calloutlist-name	"")
(define ro-caution-name	"&Caution;")
(define ro-chapter-name	"&Chapter;")
(define ro-copyright-name	"&Copyright;")
(define ro-dedication-name	"&Dedication;")
(define ro-edition-name	"&Edition;")
(define ro-equation-name	"&Equation;")
(define ro-example-name	"&Example;")
(define ro-figure-name	"&Figure;")
(define ro-glossary-name	"&Glossary;")
(define ro-glosssee-name	"&GlossSee;")
(define ro-glossseealso-name	"&GlossSeeAlso;")
(define ro-important-name	"&Important;")
(define ro-index-name		"&Index;")
(define ro-setindex-name	"&SetIndex;")
(define ro-isbn-name		"&ISBN;")
(define ro-legalnotice-name	"&LegalNotice;")
(define ro-msgaud-name	"&MsgAud;")
(define ro-msglevel-name	"&MsgLevel;")
(define ro-msgorig-name	"&MsgOrig;")
(define ro-note-name		"&Note;")
(define ro-part-name		"&Part;")
(define ro-preface-name	"&Preface;")
(define ro-procedure-name	"&Procedure;")
(define ro-pubdate-name	"&Published;")
(define ro-refentry-name      "&RefEntry;")
(define ro-reference-name	"&Reference;")
(define ro-refname-name	"&RefName;")
(define ro-revhistory-name	"&RevHistory;")
(define ro-refsect1-name      "&RefSection;")
(define ro-refsect2-name      "&RefSection;")
(define ro-refsect3-name      "&RefSection;")
(define ro-refsynopsisdiv-name      "&RefSynopsisDiv;")
(define ro-revision-name	"&Revision;")
(define ro-sect1-name		"&Section;")
(define ro-sect2-name		"&Section;")
(define ro-sect3-name		"&Section;")
(define ro-sect4-name		"&Section;")
(define ro-sect5-name		"&Section;")
(define ro-simplesect-name	"&Section;")
(define ro-seeie-name		"&See;")
(define ro-seealsoie-name	"&Seealso;")
(define ro-set-name		"&Set;")
(define ro-sidebar-name	"&Sidebar;")
(define ro-step-name		"&step;")
(define ro-table-name		"&Table;")
(define ro-tip-name		"&Tip;")
(define ro-toc-name		"&TableofContents;")
(define ro-warning-name	"&Warning;")

(define (gentext-ro-element-name gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
     ((equal? name (normalize "abstract"))	ro-abstract-name)
     ((equal? name (normalize "appendix"))	ro-appendix-name)
     ((equal? name (normalize "article"))	ro-article-name)
     ((equal? name (normalize "bibliography"))	ro-bibliography-name)
     ((equal? name (normalize "book"))		ro-book-name)
     ((equal? name (normalize "calloutlist"))	ro-calloutlist-name)
     ((equal? name (normalize "caution"))	ro-caution-name)
     ((equal? name (normalize "chapter"))	ro-chapter-name)
     ((equal? name (normalize "copyright"))	ro-copyright-name)
     ((equal? name (normalize "dedication"))	ro-dedication-name)
     ((equal? name (normalize "edition"))	ro-edition-name)
     ((equal? name (normalize "equation"))	ro-equation-name)
     ((equal? name (normalize "example"))	ro-example-name)
     ((equal? name (normalize "figure"))	ro-figure-name)
     ((equal? name (normalize "glossary"))	ro-glossary-name)
     ((equal? name (normalize "glosssee"))	ro-glosssee-name)
     ((equal? name (normalize "glossseealso"))	ro-glossseealso-name)
     ((equal? name (normalize "important"))	ro-important-name)
     ((equal? name (normalize "index"))		ro-index-name)
     ((equal? name (normalize "setindex"))	ro-setindex-name)
     ((equal? name (normalize "isbn"))		ro-isbn-name)
     ((equal? name (normalize "legalnotice"))	ro-legalnotice-name)
     ((equal? name (normalize "msgaud"))	ro-msgaud-name)
     ((equal? name (normalize "msglevel"))	ro-msglevel-name)
     ((equal? name (normalize "msgorig"))	ro-msgorig-name)
     ((equal? name (normalize "note"))		ro-note-name)
     ((equal? name (normalize "part"))		ro-part-name)
     ((equal? name (normalize "preface"))	ro-preface-name)
     ((equal? name (normalize "procedure"))	ro-procedure-name)
     ((equal? name (normalize "pubdate"))	ro-pubdate-name)
     ((equal? name (normalize "refentry"))	ro-refentry-name)
     ((equal? name (normalize "reference"))	ro-reference-name)
     ((equal? name (normalize "refname"))	ro-refname-name)
     ((equal? name (normalize "revhistory"))	ro-revhistory-name)
     ((equal? name (normalize "refsect1"))	ro-refsect1-name)
     ((equal? name (normalize "refsect2"))	ro-refsect2-name)
     ((equal? name (normalize "refsect3"))	ro-refsect3-name)
     ((equal? name (normalize "refsynopsisdiv"))	ro-refsynopsisdiv-name)
     ((equal? name (normalize "revision"))	ro-revision-name)
     ((equal? name (normalize "sect1"))		ro-sect1-name)
     ((equal? name (normalize "sect2"))		ro-sect2-name)
     ((equal? name (normalize "sect3"))		ro-sect3-name)
     ((equal? name (normalize "sect4"))		ro-sect4-name)
     ((equal? name (normalize "sect5"))		ro-sect5-name)
     ((equal? name (normalize "simplesect"))    ro-simplesect-name)
     ((equal? name (normalize "seeie"))		ro-seeie-name)
     ((equal? name (normalize "seealsoie"))	ro-seealsoie-name)
     ((equal? name (normalize "set"))		ro-set-name)
     ((equal? name (normalize "sidebar"))	ro-sidebar-name)
     ((equal? name (normalize "step"))		ro-step-name)
     ((equal? name (normalize "table"))		ro-table-name)
     ((equal? name (normalize "tip"))		ro-tip-name)
     ((equal? name (normalize "toc"))		ro-toc-name)
     ((equal? name (normalize "warning"))	ro-warning-name)
     (else (let* ((msg (string-append "gentext-ro-element-name: &unexpectedelementname;: " name))
		  (err (node-list-error msg (current-node))))
	     msg)))))

;; gentext-element-name-space returns gentext-element-name with a 
;; trailing space, if gentext-element-name isn't "".
;;
(define (gentext-ro-element-name-space giname)
  (string-with-space (gentext-element-name giname)))

;; gentext-intra-label-sep returns the seperator to be inserted
;; between multiple occurances of a label (or parts of a label)
;; for the specified element.  Most of these are for enumerated
;; labels like "Figure 2-4", but this function is used elsewhere
;; (e.g. REFNAME) with a little abuse.
;;

(define ro-equation-intra-label-sep "-")
(define ro-informalequation-intra-label-sep "-")
(define ro-example-intra-label-sep "-")
(define ro-figure-intra-label-sep "-")
(define ro-listitem-intra-label-sep ".")
(define ro-procedure-intra-label-sep ".")
(define ro-refentry-intra-label-sep ".")
(define ro-reference-intra-label-sep ".")
(define ro-refname-intra-label-sep ", ")
(define ro-refsect1-intra-label-sep ".")
(define ro-refsect2-intra-label-sep ".")
(define ro-refsect3-intra-label-sep ".")
(define ro-sect1-intra-label-sep ".")
(define ro-sect2-intra-label-sep ".")
(define ro-sect3-intra-label-sep ".")
(define ro-sect4-intra-label-sep ".")
(define ro-sect5-intra-label-sep ".")
(define ro-step-intra-label-sep ".")
(define ro-table-intra-label-sep "-")
(define ro-_pagenumber-intra-label-sep "-")
(define ro-default-intra-label-sep "")

(define (gentext-ro-intra-label-sep gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
     ((equal? name (normalize "equation"))	ro-equation-intra-label-sep)
     ((equal? name (normalize "informalequation"))	ro-informalequation-intra-label-sep)
     ((equal? name (normalize "example"))	ro-example-intra-label-sep)
     ((equal? name (normalize "figure"))	ro-figure-intra-label-sep)
     ((equal? name (normalize "listitem"))	ro-listitem-intra-label-sep)
     ((equal? name (normalize "procedure"))	ro-procedure-intra-label-sep)
     ((equal? name (normalize "refentry"))	ro-refentry-intra-label-sep)
     ((equal? name (normalize "reference"))	ro-reference-intra-label-sep)
     ((equal? name (normalize "refname"))	ro-refname-intra-label-sep)
     ((equal? name (normalize "refsect1"))	ro-refsect1-intra-label-sep)
     ((equal? name (normalize "refsect2"))	ro-refsect2-intra-label-sep)
     ((equal? name (normalize "refsect3"))	ro-refsect3-intra-label-sep)
     ((equal? name (normalize "sect1"))		ro-sect1-intra-label-sep)
     ((equal? name (normalize "sect2"))		ro-sect2-intra-label-sep)
     ((equal? name (normalize "sect3"))		ro-sect3-intra-label-sep)
     ((equal? name (normalize "sect4"))		ro-sect4-intra-label-sep)
     ((equal? name (normalize "sect5"))		ro-sect5-intra-label-sep)
     ((equal? name (normalize "step"))		ro-step-intra-label-sep)
     ((equal? name (normalize "table"))		ro-table-intra-label-sep)
     ((equal? name (normalize "_pagenumber"))	ro-_pagenumber-intra-label-sep)
     (else ro-default-intra-label-sep))))

;; gentext-label-title-sep returns the seperator to be inserted
;; between a label and the text following the label for the
;; specified element.  Most of these are for use between
;; enumerated labels and titles like "1. Chapter One Title", but
;; this function is used elsewhere (e.g. NOTE) with a little
;; abuse.
;;

(define ro-abstract-label-title-sep ": ")
(define ro-appendix-label-title-sep ". ")
(define ro-caution-label-title-sep "")
(define ro-chapter-label-title-sep ". ")
(define ro-equation-label-title-sep ". ")
(define ro-example-label-title-sep ". ")
(define ro-figure-label-title-sep ". ")
(define ro-footnote-label-title-sep ". ")
(define ro-glosssee-label-title-sep ": ")
(define ro-glossseealso-label-title-sep ": ")
(define ro-important-label-title-sep ": ")
(define ro-note-label-title-sep ": ")
(define ro-orderedlist-label-title-sep ". ")
(define ro-part-label-title-sep ". ")
(define ro-procedure-label-title-sep ". ")
(define ro-prefix-label-title-sep ". ")
(define ro-refentry-label-title-sep "")
(define ro-reference-label-title-sep ". ")
(define ro-refsect1-label-title-sep ". ")
(define ro-refsect2-label-title-sep ". ")
(define ro-refsect3-label-title-sep ". ")
(define ro-sect1-label-title-sep ". ")
(define ro-sect2-label-title-sep ". ")
(define ro-sect3-label-title-sep ". ")
(define ro-sect4-label-title-sep ". ")
(define ro-sect5-label-title-sep ". ")
(define ro-seeie-label-title-sep " ")
(define ro-seealsoie-label-title-sep " ")
(define ro-step-label-title-sep ". ")
(define ro-table-label-title-sep ". ")
(define ro-tip-label-title-sep ": ")
(define ro-warning-label-title-sep "")
(define ro-default-label-title-sep "")

(define (gentext-ro-label-title-sep gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
     ((equal? name (normalize "abstract")) ro-abstract-label-title-sep)
     ((equal? name (normalize "appendix")) ro-appendix-label-title-sep)
     ((equal? name (normalize "caution")) ro-caution-label-title-sep)
     ((equal? name (normalize "chapter")) ro-chapter-label-title-sep)
     ((equal? name (normalize "equation")) ro-equation-label-title-sep)
     ((equal? name (normalize "example")) ro-example-label-title-sep)
     ((equal? name (normalize "figure")) ro-figure-label-title-sep)
     ((equal? name (normalize "footnote")) ro-footnote-label-title-sep)
     ((equal? name (normalize "glosssee")) ro-glosssee-label-title-sep)
     ((equal? name (normalize "glossseealso")) ro-glossseealso-label-title-sep)
     ((equal? name (normalize "important")) ro-important-label-title-sep)
     ((equal? name (normalize "note")) ro-note-label-title-sep)
     ((equal? name (normalize "orderedlist")) ro-orderedlist-label-title-sep)
     ((equal? name (normalize "part")) ro-part-label-title-sep)
     ((equal? name (normalize "procedure")) ro-procedure-label-title-sep)
     ((equal? name (normalize "prefix")) ro-prefix-label-title-sep)
     ((equal? name (normalize "refentry")) ro-refentry-label-title-sep)
     ((equal? name (normalize "reference")) ro-reference-label-title-sep)
     ((equal? name (normalize "refsect1")) ro-refsect1-label-title-sep)
     ((equal? name (normalize "refsect2")) ro-refsect2-label-title-sep)
     ((equal? name (normalize "refsect3")) ro-refsect3-label-title-sep)
     ((equal? name (normalize "sect1")) ro-sect1-label-title-sep)
     ((equal? name (normalize "sect2")) ro-sect2-label-title-sep)
     ((equal? name (normalize "sect3")) ro-sect3-label-title-sep)
     ((equal? name (normalize "sect4")) ro-sect4-label-title-sep)
     ((equal? name (normalize "sect5")) ro-sect5-label-title-sep)
     ((equal? name (normalize "seeie")) ro-seeie-label-title-sep)
     ((equal? name (normalize "seealsoie")) ro-seealsoie-label-title-sep)
     ((equal? name (normalize "step")) ro-step-label-title-sep)
     ((equal? name (normalize "table")) ro-table-label-title-sep)
     ((equal? name (normalize "tip")) ro-tip-label-title-sep)
     ((equal? name (normalize "warning")) ro-warning-label-title-sep)
     (else ro-default-label-title-sep))))

(define (ro-set-label-number-format gind) "1")
(define (ro-book-label-number-format gind) "1")
(define (ro-prefix-label-number-format gind) "1")
(define (ro-part-label-number-format gind) "I")
(define (ro-chapter-label-number-format gind) "1")
(define (ro-appendix-label-number-format gind) "A")
(define (ro-reference-label-number-format gind) "I")
(define (ro-example-label-number-format gind) "1")
(define (ro-figure-label-number-format gind) "1")
(define (ro-table-label-number-format gind) "1")
(define (ro-procedure-label-number-format gind) "1")
(define (ro-step-label-number-format gind) "1")
(define (ro-refsect1-label-number-format gind) "1")
(define (ro-refsect2-label-number-format gind) "1")
(define (ro-refsect3-label-number-format gind) "1")
(define (ro-sect1-label-number-format gind) "1")
(define (ro-sect2-label-number-format gind) "1")
(define (ro-sect3-label-number-format gind) "1")
(define (ro-sect4-label-number-format gind) "1")
(define (ro-sect5-label-number-format gind) "1")
(define (ro-default-label-number-format gind) "1")

(define (ro-label-number-format gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
     ((equal? name (normalize "set")) (ro-set-label-number-format gind))
     ((equal? name (normalize "book")) (ro-book-label-number-format gind))
     ((equal? name (normalize "prefix")) (ro-prefix-label-number-format gind))
     ((equal? name (normalize "part")) (ro-part-label-number-format gind))
     ((equal? name (normalize "chapter")) (ro-chapter-label-number-format gind))
     ((equal? name (normalize "appendix")) (ro-appendix-label-number-format gind))
     ((equal? name (normalize "reference")) (ro-reference-label-number-format gind))
     ((equal? name (normalize "example")) (ro-example-label-number-format gind))
     ((equal? name (normalize "figure")) (ro-figure-label-number-format gind))
     ((equal? name (normalize "table")) (ro-table-label-number-format gind))
     ((equal? name (normalize "procedure")) (ro-procedure-label-number-format gind))
     ((equal? name (normalize "step")) (ro-step-label-number-format gind))
     ((equal? name (normalize "refsect1")) (ro-refsect1-label-number-format gind))
     ((equal? name (normalize "refsect2")) (ro-refsect2-label-number-format gind))
     ((equal? name (normalize "refsect3")) (ro-refsect3-label-number-format gind))
     ((equal? name (normalize "sect1")) (ro-sect1-label-number-format gind))
     ((equal? name (normalize "sect2")) (ro-sect2-label-number-format gind))
     ((equal? name (normalize "sect3")) (ro-sect3-label-number-format gind))
     ((equal? name (normalize "sect4")) (ro-sect4-label-number-format gind))
     ((equal? name (normalize "sect5")) (ro-sect5-label-number-format gind))
     (else (ro-default-label-number-format gind)))))

(define ($lot-title-ro$ gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond ((equal? name (normalize "table"))    "&ListofTables;")
	  ((equal? name (normalize "example"))  "&ListofExamples;")
	  ((equal? name (normalize "figure"))   "&ListofFigures;")
	  ((equal? name (normalize "equation")) "&ListofEquations;")
	  (else (let* ((msg (string-append "&ListofUnknown;: " name))
		       (err (node-list-error msg (current-node))))
		  msg)))))

(define %gentext-ro-start-quote% (dingbat "ldquo"))

(define %gentext-ro-end-quote% (dingbat "rdquo"))

(define %gentext-ro-start-nested-quote% (dingbat "lsquo"))

(define %gentext-ro-end-nested-quote% (dingbat "rsquo"))

(define %gentext-ro-by% "&by;") ;; e.g. Copyright 1997 "by" A. Nonymous
                           ;; Authored "by" Jane Doe

(define %gentext-ro-edited-by% "&Editedby;")
                           ;; "Edited by" Jane Doe

(define %gentext-ro-page% "")

(define %gentext-ro-and% "&and;")

(define %gentext-ro-bibl-pages% "&Pgs;")

(define %gentext-ro-endnotes% "&Notes;")

(define %gentext-ro-table-endnotes% "&TableNotes;:")

(define %gentext-ro-index-see% "&See;")

(define %gentext-ro-index-seealso% "&SeeAlso;")
