#
# Copyright (C) 1999  Motoyuki Kasahara
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

#
# Make finder window.
#
proc help_make_window {filename} {
    #
    # Toplevel.
    #
    if {![catch {winfo .help}]} {
	destroy .help
    }
    toplevel .help -class Popup
    wm title .help "Help"
    wm withdraw .help
    set x [expr [winfo rootx .] + 24]
    set y [expr [winfo rooty .] + 24]
    wm geometry .help +$x+$y
    wm deiconify .help
    bind .help <Return> {destroy .help}
    bind .help <Control-m> {destroy .help}
    bind .help <Escape> {destroy .help}

    #
    # Text.
    #
    frame .help.doc -relief flat
    pack .help.doc -side top -fill both -expand 1

    scrollbar .help.doc.scroll -command ".help.doc.text yview" -takefocus 0
    pack .help.doc.scroll -side right -fill y
    text .help.doc.text -relief sunken -borderwidth 2 -height 20 \
	    -yscrollcommand ".help.doc.scroll set"
    pack .help.doc.text -side left -fill both -expand 1

    #
    # Buttons.
    #
    frame .help.buttons
    pack  .help.buttons -fill x -padx 4 -pady 4 -side bottom -before .help.doc
    button .help.buttons.ok -width 6 -text "Ok" -default active \
	    -command {destroy .help}
    pack .help.buttons.ok -expand 1 -side left

    
    #
    # Read a help document.
    #
    help_read_file $filename

    .help.doc.text mark set insert 1.0
    focus .help.doc.text
}

#
# Read a help document.
#
proc help_read_file {filename} {
    global tcl_platform

    #
    # Disable and clear widgets.
    # 
    .help.doc.text delete 1.0 end

    #
    # Open a help file.
    #
    output_information "Load $filename..."
    if {[catch {set file [open $filename "r"]}]} {
	output_information "Cannot open $filename."
	return 0
    }

    #
    # Read a help file.
    #
    set error 0
    while {1} {
	if {[catch {gets $file line}]} {
	    set error 1
	    break
	}
	if {$tcl_platform(platform) != "unix"} {
	    set line [kanji conversion EUC SJIS $line]
	}
	.help.doc.text insert end "$line\n"
	if {[eof $file]} {
	    break
	}
    }

    #
    # Close a help file.
    #
    catch {close $file}

    if {!$error} {
	output_information "Load $filename...done."
    } else {
	output_information "Cannot read $filename."
    }

    return 1
}

