
#ifndef __autil_block_vector__
#define __autil_block_vector__


template <typename T>
class BlockVector {
  T * begin_;
  T * end_;
public:
  typedef T value_type;
  typedef size_t    size_type;
  typedef ptrdiff_t difference_type;
  typedef T *       iterator;
  typedef T *       const_iterator;
  typedef T &       reference;
  typedef const T & const_reference;
  typedef T *       pointer;
  typedef T *       const_pointer;
  BlockVector() : begin_(0), end_(0) {}
  BlockVector(size_type) : begin_(0), end_(0) {} // noop
  BlockVector(T * b, T * e) : begin_(b), end_(e) {}
  void set(T * b, T * e) {begin_ = b; end_ = e;}
  iterator begin() {return begin_;}
  iterator end()   {return end_;}
  const_iterator begin() const {return begin_;}
  const_iterator end()   const {return end_;}
  size_type size() const {return end_ - begin_;}
  bool empty() const {return begin_ != end_;}
  reference operator[](size_type i) {return *(begin_ + i);}
  const_reference operator[](size_type i) const {return *(begin_ + i);}
};



#endif
