
// POSIX headers
#include <unistd.h>
#include <time.h>
#include <sys/stat.h>


#include "writable_base.hh"
#include "file_util.hh"
#include "data_util.hh"
#include "file_exceps.hh"

namespace aspell {
  
  namespace writable_base {

    using namespace aspell::data_util; 

    void WritableBaseCode::update_date(fstream & f) {
      struct stat s;
      fstat(f.rdbuf()->fd(), &s);
      cur_file_date = s.st_mtime;
    }

    void WritableBaseCode::load(const string & file_name, 
				const Config * config)
    {
      string f = file_name;
      cur_file_name = file_name;
      fstream in;
    
      if (access(file_name.c_str(), F_OK) == 0) {
      
	open_file_readlock(in, f);
	merge(in, f, config);
      
      } else if (file_name.substr(file_name.size()-suffix.size(),suffix.size()) 
		 == suffix) {
      
	compatibility_file_name = file_name.substr(0,file_name.size()
						   -suffix.size());
	compatibility_file_name += compatibility_suffix;
	f = compatibility_file_name;
      
	try {
	  open_file_readlock(in, f);
	  merge(in, f, config);
	} catch (...) {
	  compatibility_file_name = "";
	  throw;
	}
      
      } else {
      
	throw CantReadFile(f);
      
      }

      update_date(in);
    }

    void WritableBaseCode::merge(const string & file_name) {
      fstream in;
      open_file_readlock(in, file_name);
      merge(in, file_name);
    }

    void WritableBaseCode::update(fstream & in, const string & file_name) {
      try {
      
	merge(in, file_name);
	update_date(in);
      
      } catch (CantReadFile &) {
      
	if (compatibility_file_name.empty())
	  throw;
      }
    }
    
    void WritableBaseCode::save2(fstream & out, const string & f) {
      out.flush();
      out.clear();
      out.seekp(0, ios::beg);
      ftruncate(out.rdbuf()->fd(),0);
    
      save(out,f);

      out.flush();
    }

    void WritableBaseCode::save_as(const string & file_name) {
      compatibility_file_name = "";
      cur_file_name = file_name;
      fstream inout;
      open_file_writelock(inout, cur_file_name);
      save2(inout, cur_file_name);
      update_date(inout);
    }

    void WritableBaseCode::save(bool do_update) {
      fstream inout;
      open_file_writelock(inout, cur_file_name);

      if (do_update) {
	struct stat s;
	fstat(inout.rdbuf()->fd(), &s);
	if (s.st_size != 0 && s.st_mtime > cur_file_date) {
	  update(inout, cur_file_name);
	}
      }

      save2(inout, cur_file_name);
      update_date(inout);
    
      if (compatibility_file_name.size() != 0) {
	unlink(compatibility_file_name.c_str());
	compatibility_file_name = "";
      }
    
    }
  
  }
}
