
#include "check.hh"
#include "map_repl_read.hh"

namespace aspell {

  UnknownFilter::UnknownFilter(const string & f) 
    : filter(f) 
  {
    message  = "Sorry, the filter \"";
    message += filter;
    message += "\" is not known.";
  }

  FilterItrPart * get_filter_itr_throw(const string & name, 
				       const ConfigData & opts)
  {
    try {
    
      FilterItrPart * i = get_filter_itr(name, (ConfigData&)opts); 
      // FIXME: decide if I really want opts to be non const.....
      if (!i) throw UnknownFilter(name);
      return i;

    } catch (MapReplReadError & err) {

      throw BadMapFile(err.file, &err);

    }
  }
}
