/* This is part of tmview, a dvi previewer. (c) 1995 Thomas Moor         */
/*                                                                       */
/* This program may be used without any warranty. It may be modified and */
/* distributed without any restrictions as far  I'm concerned ...        */

/* The code for reading vf-files is to some extent from vf.c of xdvi.    */
/* Therefore the original copyright is stated below.                     */



#include "defs.h"


/* #define DEBUGVF */


FILE* vffile;


void vfopen(char* fname) {
  if((vffile = fopen(fname, "rb"))==0) {
    pfprot("\n fatal error: vf-file \"%s\" disapeard. \n",fname);
    exit(1);
  }
}


#define vfclose()     fclose(vffile)
#define vfskip(delta) fseek(vffile,(long) delta,1)
#define vfposit(to)   fseek(vffile,to,0)
#define vftell()      ftell(vffile)


#define vfn1() (uchar) fgetc(vffile)


unsigned short vfn2(void)  {  
  short b;
  b = vfn1();  
  return (b * 256 + vfn1());
}

unsigned long vfn3(void)  {  
  long b;  
  short c;
  b = vfn1();  
  c = vfn1();
  return ((b * 256 + c) * 256 + vfn1());
}


unsigned long vfn4(void)  {  
  unsigned long b,c,d;  
  b = vfn1();  
  c = vfn1();
  d = vfn1();
  return (((b * 256 + c) * 256 +d)*256+ vfn1());
}


short vfi1(void)  {  
  short b;
  b = vfn1();  
  if (b > 127)  b -= 256;  
  return b;
}

short vfi2(void)  {  
  short b;
  b = vfn1();  
  if (b > 127)  b -= 256;
  return (b * 256 + vfn1());
}

long vfi3(void)  {  
  long b;
  b = vfi1();  return (b * 65536L + vfn2());
}

long vfi4(void)  {  
  long b;
  b = vfi2();  
  return (b * 65536L + vfn2());
}


void vfbytes(char *s, uchar  l) {
  if(l==0) return;
  s[0]=0;  
  s[l] = '\0';  
  if(fread(s,1,(long) l,vffile)==0) pfprot("vf-file ends prematurely ! ");
}

long vfnum(uchar b)  {  
  uchar i;  
  long n;
  uchar rbuf[4]={0,0,0,0};
  if(fread(rbuf, b, 1, vffile)==0) pfprot("vf-file ends prematurely ! ");
  n = 0;
  for (i = 1; i <= b; i++)  
    n = (n << 8) | (uchar) rbuf[i-1];  
  return n;
}




/* Since we are not that smart as the xdvi crew, we need to code fontdefinitions */
/* again. Bullshit. Why the hell did I start all this?                           */


void vffontdef(long fontnr, long vfscf, long vfdsz) { 
  uchar  p, q;
  int f,fdb,a;
  long dsz,scf,reldsz,relscf,chksum;
  float fontmag;  
  fontdesc *font;
  char ffpath[MAXPATHSTR], fftuto[MAXPATHSTR];
  char fontname[MAXPATHSTR];
  char messtr[MAXPATHSTR+20];

  if (fontnr < 0)  {
    dvibad("vf-file: negative fontnumber");
    return;
  } 
  chksum = vfi4();
  relscf = vfi4();  
  reldsz = vfi4();
  scf=vfscf;
  dsz=vfdsz;  /* something relative ? ignore ... */
  p = vfn1(); 
  q = vfn1();  
  vfbytes(fontname, q);
  if (p == 0)  strcpy(ffpath, fontprefix);  
  else vfbytes(ffpath, p); 
  fontmag = xres * (dvimag / 1000.0 * ((double)scf / dsz));
  pfprot("\n  prep. vffont: %8s at %6.1f ", fontname, fontmag);
  pfverb("(scf %d dsz %d) ",scf,dsz);
  if((fdb=searchfontdatabase(ffpath,fontname,dvimag,scf,dsz))!=-1) {
    pfprot(" - fontdatabase");
    font=fontdatabase+fdb;
  } else {
    fdb=allocfontdesc(ffpath,fontname,dvimag,scf,dsz);
    font=fontdatabase+fdb;  
    /* font->pkfile = NULL; */
    allocmem(&(font->chv),(MAXFONTS+1) * sizeof(chdesc)); 
    memset(font->chv,0,(MAXFONTS+1) * sizeof(chdesc));  
                                               /* unsused bitmaps=NULL */
                                               /* unused  fty  0 */
                                               /* unused dimensions 0*/
    /* vf's in vf's are not supported: looks too dangerous ...*/
    /*if(vffind(ffpath,fontname,fftuto)) {
      vfdef(fftuto,fdb,chksum);
    } else { */
    if(tfmfind(tfmprefix,fontname,fftuto))
      tfmdef(fftuto,fdb,chksum);
    if(pkfind(ffpath,fontname,fontmag,fftuto))
      pkdef(fftuto,fdb,chksum);
    reallocmem(&(font->chv),sizeof(chdesc)*(font->mch + 2));
                                            /* +1 is enuough ?? */
  }
  f = fontnr & 0xff;
  a = 0;
  if ((fontnr >= MAXFONTS) || (fontvect[f].fontdataptr != -1)) do {
    if (fontvect[a].fontdataptr == -1)  f = a;
    else if (fontvect[a].dfn == fontnr)  {
      dvibad("double fontnumber");
      return;
    }
    a++;
  } while (a<MAXFONTS);
  if (fontvect[f].fontdataptr != -1) {
    dvibad("too many fonts");
    return;
  }
  font->usecount++;
  fontvect[f].fontdataptr=fdb;
  fontvect[f].dfn = fontnr;
  /*pfprot("\n");*/
}




setvfname(char* fn, char* result) {

  *result=0;
  strcpy(result,fn);
  strcat(result,".vf");

}


int vffind(char* ffpath,char* fontname,char* fftuto)  {  
  char ffname[MAXPATHSTR];
  int delta, foundfile;
  FILE* fofile;
  
#ifdef KPATHSEA                            /* use kpathsea if wanted */
  char *name=kpse_find_vf(fontname);
  foundfile = (name!=NULL);
  if(name){
    strcpy(fftuto, name);
    freemem(&name);         
  }       
#else                                             /* use my own subs (slow) */
  setvfname(fontname,ffname);
  foundfile=msearch(ffpath,ffname,fftuto);      
#endif

  if(foundfile==0) { 
        return(0);
  }
  fofile=fopen(fftuto,"rb");
  if ((fgetc(fofile)!=0xf7)||(fgetc(fofile)!=202)){  
    pfprot(" - error in VFfile ");  
    fclose(fofile);
    return(0);
  }
  pfprot(" - VFfile ");
  pfverb("%s ",fftuto);
  fclose(fofile);
  return(1);
}


int vflookuppk(int fdb,long vffontnr)  {
  int i;
  long il,f;
  fontdesc *font;
  chdesc *achar;
  uchar  o;

  
#ifdef DEBUGVF
  pfprot("(vflookuppk: ");
#endif
  font=fontdatabase+fdb;
  vfopen(font->vffile);

/* Read preamble.*/
  vfposit(2);	/* skip comment */
  i=vfn1();
  vfskip(i);
  il = vfi4();
  vfskip(4);	   /* skip design size */

/* Read the fonts. */
#ifdef DEBUGVF
  pfprot(" %s -- lookup fonts: ",font->fonam);
#endif
  
  while ((o = vfn1()) >= 243 && o <= 246) {
     f = vfnum(o - 242);
     vffontdef((1+vffontnr)*MAXFONTS +f,font->foscf,font->fodsz);
     /* ^^^ this is not the definition !!!*/  
  }
  vfclose();
}

int vfdef(char* fftuto,int fdb,long chksum, long vffontnr)  {  
  short i, j;
  long il,f,laf;
  int mchvf;
  fontdesc *font;
  chdesc *achar;
  uchar  o;

  
#ifdef DEBUGVF
  pfprot("(vfdef: ");
#endif
  font=fontdatabase+fdb;
  allocmem(&(font->vffile),strlen(fftuto)+1);
  strcpy(font->vffile, fftuto);

/* Read preamble.*/
  vfopen(fftuto);	
  vfposit(2);	/* skip comment */
  i=vfn1();
  vfskip(i);
  il = vfi4();
  if (il !=0 && chksum !=0 && il != chksum ) 
    pfverb(" - wrong checksum "); 
  vfskip(4);	   /* skip design size */

/* Read the fonts. */
#ifdef DEBUGVF
  pfprot(" %s -- load fonts: ",font->fonam);
#endif
  
  while ((o = vfn1()) >= 243 && o <= 246) {
     f = vfnum(o - 242);
     /*printf("--%lu--",f);*/
     vffontdef((1+vffontnr)*MAXFONTS +f,font->foscf,font->fodsz);
     /* ^^^ this is not the definition !!!*/  
  }
  laf=f;

  mchvf=-1;
  for (; o <= 242; o = vfn1()) {
    int len;
    unsigned long c;
    long fpwidth;
     if (o == 242) {	/* long form packet */
       len =   vfn4();
       c =     vfn4();
       fpwidth = vfn4();
       if (c > 255) {
         pfprot(" -  ignoring character %lu ",c);
	 vfskip(len);
	 continue;
       }
     }
     else {	/* short form packet */
       len = o;
       c = vfn1();
       fpwidth = vfnum(3);
     }
     achar = font->chv+c;
     achar->fty |= VFTYPE;
     achar->fontdataptr = fdb;
     achar->ch = (uchar) c; 
     achar->tfw = scaled(fpwidth,font->foscf);
     achar->addr = vftell();
     achar->mlen = len;
     achar->lastf=laf;
     allocmem(&achar->macro,achar->mlen+1);
     vfbytes(achar->macro, achar->mlen);
#ifdef DEBUGVF
     pfprot(" c %d data 0x%x len %u", c, achar->macro,achar->mlen); 
#endif     
     /*vfskip(len);*/
     if (mchvf < (int) c)  mchvf = (int) c;
  }
  vfclose();
#ifdef DEBUGVF
  pfprot("... vfdef)");
#endif
  if (mchvf < 0 || o !=248) {
    pfprot(" - VFfile in error ");
    freemem(&(font->vffile));
    return(0);
  } else  pfverb(" - VFfile ok ");
  if (mchvf > font->mch)  font->mch=mchvf;
  return(1);
}


  
