
/********************************************************/
/* t4ht.c                              1999-06-18-10-53 */
/* Copyright (C) 1998--99    Eitan M. Gurari            */
/*                                                      */
/* This program can redistributed and/or modified under */
/* the terms of the LaTeX Project Public License        */
/* Distributed from CTAN archives in directory          */
/* macros/latex/base/lppl.txt; either version 1 of the  */
/* License, or (at your option) any later version.      */
/*                                                      */
/* However, you are allowed to modify this program      */
/* without changing its name, if you modify its         */
/* signature. Changes to the signature can be           */
/* introduced with a directive of the form              */
/*      #define PLATFORM "signature"                    */
/*                                                      */
/*                           gurari@cis.ohio-state.edu  */
/*               http://www.cis.ohio-state.edu/~gurari  */
/********************************************************/

/* **********************************************
    Compiler options                            *
    (uncommented | command line)                *
------------------------------------------------*
        Clasic C (CC)             default
#define ANSI                      ansi-c, c++
#define DOS_C
#define HAVE_STRING_H             <string.h>
#define HAVE_DIRENT_H             <dirent.h>
#define HAVE_SYS_NDIR_H           <sys/ndir.h>
#define HAVE_SYS_DIR_H            <sys/dir.h>
#define HAVE_NDIR_H               <ndir.h>
#define HAVE_IO_H                 <io.h>
#define HAVE_UNISTD_H             <unistd.h>
#define WIN32
#define KPATHSEA
#define SYSTEM_FUNCTION_OK
#define CDECL                    ..........
#define BCC32                    bordland c++

*************************************************
    Tex4ht variables                            *
    (uncommented | command line)                *
----------------------------------------------- */

#ifndef ENVFILE

#endif


/* ******************************************** */


#ifdef BCC32
#define WIN32
#define ANSI
#define HAVE_IO_H
#define HAVE_STRING_H
#define PLATFORM "ms-win32"
#endif



#ifdef BCC
#define DOS_C
#define ANSI
#define HAVE_IO_H
#define PLATFORM "ms-dos"
#endif



#ifdef __DJGPP__
#define DOS_WIN32
#define ANSI
#endif


#ifdef DOS_C
#define DOS
#endif
#ifdef DOS
#define DOS_WIN32
#ifndef HAVE_STRING_H
#define HAVE_STRING_H
#endif
#endif
#ifdef WIN32
#define DOS_WIN32
#endif

#ifdef DOS_WIN32
#define STRUCT_DIRENT
#endif



#ifdef KPATHSEA
#ifdef WIN32
#define KWIN32
#endif
#endif



#include <stdio.h>   
#include <stdlib.h>  


#ifdef HAVE_STRING_H
#include <string.h>
#endif


#ifdef HAVE_DIRENT_H

#include <dirent.h>


#else
#ifndef STRUCT_DIRENT
#define STRUCT_DIRECT
#endif

#ifdef HAVE_SYS_NDIR_H
#include <sys/ndir.h>
#endif
#ifdef HAVE_SYS_DIR_H
#include <sys/dir.h>
#endif
#ifdef HAVE_NDIR_H
#include <ndir.h>
#endif


#endif


#include <signal.h>




#ifndef __DJGPP__

#ifndef F_OK
#ifdef DOS_WIN32
#define  F_OK 0               
#endif
#ifndef KPATHSEA
#ifndef DOS_WIN32
#define HAVE_UNISTD_H
#endif
#endif
#endif
#ifdef HAVE_IO_H
#include <io.h>
#endif
#ifndef KPATHSEA
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#endif


#endif


#ifdef KPATHSEA
#include <kpathsea/config.h>
#include <kpathsea/c-errno.h>
#include <kpathsea/c-ctype.h>
#include <kpathsea/c-fopen.h>
#include <kpathsea/c-pathmx.h>
#include <kpathsea/proginit.h>
#include <kpathsea/tex-file.h>
#include <kpathsea/tex-make.h>
#include <signal.h>
#if !defined(_AMIGA) && !defined(WIN32)
#include <sys/time.h>
#endif
#include <fcntl.h>
#include <setjmp.h>
#endif 

#ifdef __DJGPP__

#ifndef F_OK
#ifdef DOS_WIN32
#define  F_OK 0               
#endif
#ifndef KPATHSEA
#ifndef DOS_WIN32
#define HAVE_UNISTD_H
#endif
#endif
#endif
#ifdef HAVE_IO_H
#include <io.h>
#endif
#ifndef KPATHSEA
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#endif


#endif






#ifdef DOS
#define PROTOTYP
#endif
#ifdef ANSI
#define PROTOTYP
#endif
#ifdef KWIN32
#define PROTOTYP
#endif


#ifdef KPATHSEA
#ifdef WIN32
#undef CDECL
#define CDECL                     __cdecl
#else
#define CDECL
#endif
#endif


#if defined(DOS_WIN32) || defined(__MSDOS__)
#define READ_BIN_FLAGS "rb"
#define READ_TEXT_FLAGS "r"
#define WRITE_BIN_FLAGS "wb"
#define WRITE_TEXT_FLAGS "w"
#else
#define READ_BIN_FLAGS "r"
#define READ_TEXT_FLAGS "r"
#define WRITE_BIN_FLAGS "w"
#define WRITE_TEXT_FLAGS "w"
#endif



#define Q_CHAR char
#define U_CHAR char
#define C_CHAR char
#define Q_NULL (Q_CHAR *) 0
#define U_NULL (U_CHAR *) 0
#define C_NULL (C_CHAR *) 0


#define IGNORED void


#ifndef EXIT_FAILURE
#define EXIT_FAILURE 1
#endif


#ifdef PROTOTYP
#define VOID void
#define ARG_I(x) x
#define ARG_II(x,y) x,y
#define ARG_III(x,y,z) x,y,z
#define ARG_IV(x,y,z,w) x,y,z,w
#define ARG_V(x,y,z,w,u) x,y,z,w,u
#else
#define VOID
#define ARG_I(x)
#define ARG_II(x,y)
#define ARG_III(x,y,z)
#define ARG_IV(x,y,z,w)
#define ARG_V(x,y,z,w,u)
#endif


#if defined(DOS_WIN32) || defined(__DJGPP__)
#define dir_path_slash(str) (is_forward_slash(str)? '/' : '\\')
#else
#define dir_path_slash(str)  '/'
#endif


struct htf_struct{
  Q_CHAR *key,  *body;
  struct htf_struct *next;
};


struct empty_pic_struct{
  long int n;
  struct empty_pic_struct *next;
};


#ifndef HTFDIR
#define HTFDIR      ""
#endif


struct sys_call_rec{
  Q_CHAR * filter;
  struct sys_call_rec *next;
};


struct script_struct{
  Q_CHAR *command;
  struct script_struct *next;
};


#define NULL_SCRIPT (struct script_struct *) 0


#define bad_arg            err_arg(0)
#define bad_mem             err_i(1)


#define eq_str(x,y) (!strcmp(x,y))


#define m_alloc(typ,n) (typ *) malloc_chk((int) ((n) * sizeof(typ)))


#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif
#ifndef BOOL
#define BOOL int
#endif


#define eq_str(x,y) (!strcmp(x,y))




static int eoln_ch;


static Q_CHAR *ch_mod = Q_NULL;
static Q_CHAR *debug = Q_NULL;
static Q_CHAR *dir = Q_NULL;
static Q_CHAR *htf_cfg = Q_NULL;
static Q_CHAR *lg_name  = Q_NULL;
static Q_CHAR *nopict = Q_NULL;


static struct htf_struct *htf_rec = (struct htf_struct *) 0;


static BOOL system_yes;
static struct sys_call_rec *system_calls = (struct sys_call_rec *) 0;


static BOOL status;


static int base_font_size = 10;


static struct script_struct
    * dvigif_script = NULL_SCRIPT,
    * dvigif_glyp_script = NULL_SCRIPT,
    * move_script = NULL_SCRIPT,
    * empty_fig_script = NULL_SCRIPT,
    * copy_script = NULL_SCRIPT,
    * chmod_script = NULL_SCRIPT;


static Q_CHAR* env_htf_sty = Q_NULL;


static FILE* lg_file;
static long  begin_lg_file;


static C_CHAR warning[] = "--- warning --- ";


static C_CHAR *warn_err_mssg[]={ 

"\n---------------------------------------------------------------\n\
t4ht filename ...\n\
  -d...  directory for output files       (default:  current)\n\
  -e...  location of tex4ht.env\n\
  -h...  configuration file for htf fonts (default: -h%s)\n\
  -i     debugging info\n\
  -m...  chmod ... for output files\n\
  -p     don't convert pictures           (default:  convert)\n\
  -S...  permission for system calls: *-always, filter\n\n\
Example: \n\
   t4ht name -d/WWW/temp/  -m644\n\
---------------------------------------------------------------\n"

,                            
"Insufficient memory\n",                                

"Illegal storage address\n", 
"Floating-point\n",          
"Interrupt with Cntr-C\n",   


"Can't find/open file `%s'\n",                         
"Can't access directory `%s\n'",                     

 "" };


static Q_CHAR command[255];
static int system_return;


static BOOL system_yes;


static Q_CHAR* match[10];
static int   max_match[10];



#if defined(DOS_WIN32) || defined(__DJGPP__)
   static BOOL is_forward_slash( ARG_I(Q_CHAR *) );
#endif


static void execute_script(
  ARG_V(struct script_struct*,Q_CHAR *,char *,Q_CHAR *,Q_CHAR *) );


static struct script_struct * add_script( ARG_I(struct script_struct *) );


static FILE* open_file( ARG_II(C_CHAR *, C_CHAR *) );


static void err_i( ARG_I(int) );


static void err_arg( ARG_I(int) );


static void warn_i_str( ARG_II(int,Q_CHAR *) );


static void

#ifdef CDECL
CDECL
#endif


sig_err(ARG_I(int));


#ifdef KWIN32
static BOOL sigint_handler(ARG_I(DWORD));
#endif


static void call_sys(ARG_I(Q_CHAR *));


static void strct( ARG_II(C_CHAR *, C_CHAR *) );


static long int get_long_int( ARG_I(Q_CHAR *) );


static void* malloc_chk(ARG_I(int));


static void* r_alloc(ARG_II(void *, size_t));


static BOOL scan_until_end_str( ARG_IV(C_CHAR *, int, BOOL, FILE *) );


static BOOL scan_until_str( ARG_IV(C_CHAR *, int, BOOL, FILE *) );


static BOOL scan_str( ARG_III(C_CHAR *, BOOL, FILE *) );



#if defined(DOS_WIN32) || defined(__DJGPP__)

static BOOL is_forward_slash
#ifdef ANSI
#define SEP ,
(
                                    Q_CHAR * str
)
#undef SEP
#else
#define SEP ;
(str)
                                    Q_CHAR * str
;
#undef SEP
#endif
{
   while( *str ){  if( *(str++) == '/' ) { return TRUE; } }
   return FALSE;
}
#endif



static void execute_script
#ifdef ANSI
#define SEP ,
(
                    struct script_struct* script SEP 
                    Q_CHAR * match_1 SEP 
                    Q_CHAR * match_2 SEP 
                    Q_CHAR * match_3 SEP 
                    Q_CHAR * match_4

)
#undef SEP
#else
#define SEP ;
(script,match_1,match_2,match_3,match_4)
                    struct script_struct* script SEP 
                    Q_CHAR * match_1 SEP 
                    Q_CHAR * match_2 SEP 
                    Q_CHAR * match_3 SEP 
                    Q_CHAR * match_4

;
#undef SEP
#endif
{                               struct script_struct* temp;
                                 Q_CHAR *p, *q, *t;
   temp = script;  system_return = 0;
   while( temp ){
      
p = temp->command;
q = command;
while( *p != '\0' ){
  *q = *(p++);
  if( (*q == '%') && (*p == '%')
     && ((*(p+1) == '%')  || ( (*(p+1) > '0') && (*(p+1) < '5') ) )
  ){  p++;
    switch( *(p++) ){
      case '%':{  q++; break; }
      case '1':{  t = match_1;
            while( *t != '\0' ){ *(q++) = *(t++); }  break; }
      case '2':{  t = match_2;
            while( *t != '\0' ){ *(q++) = *(t++); }  break; }
      case '3':{  t = match_3;
            while( *t != '\0' ){ *(q++) = *(t++); }  break; }
      case '4':{  t = match_4;
            while( *t != '\0' ){ *(q++) = *(t++); }  break; }
      default: {  }
  }} else { q++; }
}
*q = '\0';


      if( (command[0] != '\0') && !system_return ){
         
(IGNORED) call_sys(command);

 }
      temp = temp->next;
}  }



static struct script_struct * add_script
#ifdef ANSI
#define SEP ,
(
                           struct script_struct * script

)
#undef SEP
#else
#define SEP ;
(script)
                           struct script_struct * script

;
#undef SEP
#endif
{
   struct script_struct* temp, * q;
   temp = (struct script_struct *)
                      m_alloc(struct script_struct, (int) 1);
   temp->command = match[1];
   if( debug ){
      (IGNORED) printf(".......   %s\n", temp->command); }
   temp->next = NULL_SCRIPT;
   match[1] = (Q_CHAR *) malloc(70);
   max_match[1] = 70;
   if( script ){
      q = script;
      while( q->next ){ q = q->next; }
      q->next = temp;
   } else {
      script = temp;
   }
   return script;
}


#if defined(DOS_WIN32) || defined(__MSDOS__)


char *get_env_dir
#ifdef ANSI
#define SEP ,
(
      Q_CHAR *progname

)
#undef SEP
#else
#define SEP ;
(progname)
      Q_CHAR *progname

;
#undef SEP
#endif
{    int  i;
      Q_CHAR *p;
  if(! progname || ! *progname)  return NULL;  
  i = (int) strlen(progname);
  while( (progname[--i] != dir_path_slash(progname) )
        && i > 0) ;                               
  if(i == 0)  return NULL;                        
  p = (Q_CHAR *) malloc(i+12);
  if(p == NULL)  return NULL;     
  strncpy(p, progname, i+1);                         
  strcpy(&p[i+1],"tex4ht.env");                       
  return p;
}


#endif



static FILE* open_file
#ifdef ANSI
#define SEP ,
(
                         Q_CHAR *name SEP  Q_CHAR *ext
)
#undef SEP
#else
#define SEP ;
(name,ext)
                         Q_CHAR *name SEP  Q_CHAR *ext
;
#undef SEP
#endif
{                       FILE* file;
                         C_CHAR filename[255], *p;
   (IGNORED) strcpy( filename,name );
   p = filename;
   while( TRUE ){
     if( *p == '.' ){ break; }
     if( *p == '\0' ){ (IGNORED) strcpy(p, ext); break; }
     p++;
   }
   (IGNORED) printf ("Entering %s\n", filename);
   file  = fopen(filename, READ_TEXT_FLAGS);
   if( !file ) {
      (IGNORED) warn_i_str(5,filename);
   }
   return file;
}



static void err_i
#ifdef ANSI
#define SEP ,
(      int  n

)
#undef SEP
#else
#define SEP ;
(n)      int  n

;
#undef SEP
#endif
{  (IGNORED) fprintf(stderr,"--- error --- ");
   (IGNORED) fprintf(stderr, warn_err_mssg[n]);
   exit(EXIT_FAILURE);
}



static void err_arg
#ifdef ANSI
#define SEP ,
(      int  n

)
#undef SEP
#else
#define SEP ;
(n)      int  n

;
#undef SEP
#endif
{  (IGNORED) fprintf(stderr,"--- error --- ");
   (IGNORED) fprintf(stderr, warn_err_mssg[n],
htf_cfg? htf_cfg : "htfcss.env"

);
   exit(EXIT_FAILURE);
}



static void warn_i_str
#ifdef ANSI
#define SEP ,
(
    int  n SEP 
    Q_CHAR *str

)
#undef SEP
#else
#define SEP ;
(n,str)
    int  n SEP 
    Q_CHAR *str

;
#undef SEP
#endif
{  (IGNORED) fprintf(stderr,warning);
   (IGNORED) fprintf(stderr,warn_err_mssg[n], str);
}



static void

#ifdef CDECL
CDECL
#endif


sig_err
#ifdef ANSI
#define SEP ,
(  int s
)
#undef SEP
#else
#define SEP ;
(s)  int s
;
#undef SEP
#endif
{
  (void) signal(s,SIG_IGN);  
  switch( s ){
#ifdef SIGSEGV
    case SIGSEGV: err_i(2);
#endif
    case SIGFPE : err_i(3);
#if defined(SIGINT) && !defined(WIN32)
    case SIGINT : err_i(4);
#endif
  }
  
#ifdef __DJGPP__
  if (s != SIGINT && s != SIGQUIT)
    exit(EXIT_FAILURE);
#endif


}


#ifdef KWIN32

static BOOL sigint_handler
#ifdef ANSI
#define SEP ,
(     DWORD dwCtrlType
)
#undef SEP
#else
#define SEP ;
(dwCtrlType)     DWORD dwCtrlType
;
#undef SEP
#endif
{
  err_i(32);
  return FALSE;      
}
#endif



static void call_sys
#ifdef ANSI
#define SEP ,
(  Q_CHAR * command
)
#undef SEP
#else
#define SEP ;
(command)  Q_CHAR * command
;
#undef SEP
#endif
{
   if( *command ){
      (IGNORED) printf("System call: %s\n", command);
      system_return = system_yes?  (int) system(command) : -1;
      (IGNORED) printf("%sSystem return: %d\n",
            system_return? "--- Warning --- " : "", system_return );
   }
}



static void strct
#ifdef ANSI
#define SEP ,
(
     Q_CHAR * str1 SEP 
     Q_CHAR * str2

)
#undef SEP
#else
#define SEP ;
( str1, str2 )
     Q_CHAR * str1 SEP 
     Q_CHAR * str2

;
#undef SEP
#endif
{   Q_CHAR * ch;
   ch = str1 + (int) strlen(str1);
   (IGNORED) strcpy( ch, str2 );
}



static long int get_long_int
#ifdef ANSI
#define SEP ,
(
                         Q_CHAR   *str
)
#undef SEP
#else
#define SEP ;
(str)
                         Q_CHAR   *str
;
#undef SEP
#endif
{                  long int    i;
                         Q_CHAR   *ch;
   ch = str;   i = 0;
   while( (*ch>= '0') && (*ch <='9') ){
     i = 10*i + *(ch++) - '0';
   }
   return i;
}



static void* malloc_chk
#ifdef ANSI
#define SEP ,
( int n
)
#undef SEP
#else
#define SEP ;
( n ) int n
;
#undef SEP
#endif
{      void* p;
   if((p = (void *) malloc( (size_t) n)) == NULL ) bad_mem;
   return p;
}



static void* r_alloc
#ifdef ANSI
#define SEP ,
(
      void   *q SEP 
      size_t  n
)
#undef SEP
#else
#define SEP ;
( q, n )
      void   *q SEP 
      size_t  n
;
#undef SEP
#endif
{    void*   p;
   if((p = (void *) realloc( q, (size_t) n)) == NULL) bad_mem;
   return p;
}



static BOOL  scan_until_end_str
#ifdef ANSI
#define SEP ,
(
                         Q_CHAR   *str SEP 
                         int    n SEP 
                         BOOL   flag SEP 
                         FILE*  file
)
#undef SEP
#else
#define SEP ;
(str,n,flag,file)
                         Q_CHAR   *str SEP 
                         int    n SEP 
                         BOOL   flag SEP 
                         FILE*  file
;
#undef SEP
#endif
{                       Q_CHAR   *p;
                         int i;
   if( !flag ) { return flag; }
   p = match[n];  i = 0;
   while( TRUE ){
     if( (i+1) >= max_match[n] ){
        max_match[n] += 10;
        p = match[n] = (Q_CHAR *)
                     r_alloc((void *) match[n], (size_t) max_match[n]);
     }
     p[i] = (char) (eoln_ch = getc(file));
     if( (eoln_ch == (int) '\n') || (eoln_ch == EOF) ){  break; }
     i++;
   }
   p[i] = '\0';
   i -= (int) strlen(str);
   if( i>= 0 ){  return eq_str(p+i,str);   }
   return FALSE;
}



static BOOL  scan_until_str
#ifdef ANSI
#define SEP ,
(
                         Q_CHAR   *str SEP 
                         int    n SEP 
                         BOOL   flag SEP 
                         FILE*  file
)
#undef SEP
#else
#define SEP ;
(str,n,flag,file)
                         Q_CHAR   *str SEP 
                         int    n SEP 
                         BOOL   flag SEP 
                         FILE*  file
;
#undef SEP
#endif
{                       Q_CHAR   *p, ch;
                         int i, j;
   if( !flag ) { return flag; }
   p = match[n];  i = 0;
   while( TRUE ){
     ch =  (char) (eoln_ch = getc(file));
     if( (eoln_ch == (int) '\n') || (eoln_ch == EOF) ){  return FALSE; }
     if( (i+1) >= max_match[n] ){
        max_match[n] += 10;
        p = match[n] = (Q_CHAR *)
                     r_alloc((void *) match[n], (size_t) max_match[n]);
     }
     p[i++] = ch;
     j =  i - (int) strlen(str);
     if( j>= 0 ){
       p[i] = '\0';
       if( eq_str(p+j,str) ) { return TRUE;  }
     }
   }
}



static BOOL  scan_str
#ifdef ANSI
#define SEP ,
(
                         Q_CHAR   *str SEP 
                         BOOL   flag SEP 
                         FILE*  file
)
#undef SEP
#else
#define SEP ;
(str,flag,file)
                         Q_CHAR   *str SEP 
                         BOOL   flag SEP 
                         FILE*  file
;
#undef SEP
#endif
{                       Q_CHAR *p;
                         int temp_eoln_ch;
   if( !flag ) { return flag; }
   p = str;
   while( *p != '\0' ){
     if( *(p++) != (temp_eoln_ch = getc(file)) ) {
        while( (temp_eoln_ch != (int) '\n')
            && (temp_eoln_ch != EOF) ){ temp_eoln_ch = getc(file); }
        eoln_ch = temp_eoln_ch;  return FALSE;
     }
   }
   return TRUE;
}



int 
#ifdef CDECL
CDECL
#endif

 main
#ifdef ANSI
#define SEP ,
(
       int  argc SEP 
       Q_CHAR **argv
)
#undef SEP
#else
#define SEP ;
(argc, argv)
       int  argc SEP 
       Q_CHAR **argv
;
#undef SEP
#endif
{ 
struct empty_pic_struct *empty_pic;


Q_CHAR * tex4ht_env_file = (Q_CHAR *) 0;
Q_CHAR * dos_env_file =
#if defined(DOS_WIN32) || defined(__MSDOS__)
  
get_env_dir(argv[0])

;
#endif
#if !defined(DOS_WIN32) && !defined(__MSDOS__)
  (Q_CHAR *) 0;
#endif



   

#ifdef SIGSEGV
  (void) signal(SIGSEGV,sig_err);
#endif
  (void) signal(SIGFPE,sig_err);
#ifdef KWIN32
  
SetConsoleCtrlHandler((PHANDLER_ROUTINE)sigint_handler, TRUE);


#else
#ifdef SIGINT
  (void) signal(SIGINT,sig_err);    
#endif
#endif


#ifdef PLATFORM
   (IGNORED) printf("t4ht.c (1999-06-18-10-53 %s)\n",PLATFORM);
#else
   (IGNORED) printf("t4ht.c (1999-06-18-10-53)\n");
#endif
   
{                   C_CHAR   *yes = NULL;
  system_yes = (
#ifdef SYSTEM_FUNCTION_OK
0
#else
system( yes ) != 0
#endif

);
}


{          int i;
  for( i=0;  i<=9; i++){
    match[i] = (Q_CHAR *) malloc(70);
    max_match[i] = 70;
  }
}



  
{      int i;
       Q_CHAR *p, *q;
  
#ifdef KPATHSEA
#ifdef DEBIAN
   kpse_set_program_name (argv[0], "tex4ht");
#else
   kpse_set_program_name (argv[0], NULL);
#endif
#endif


  
  if( argc == 1 ){ bad_arg; }
  for(i=1; i<argc; i++){
    if( *( p=argv[i] ) == '-' ){ 
if( (int) strlen( argv[i] ) == 2 ){
   if( (*(p+1)!='i')  && (*(p+1) != 'p') )
     { if( ++i == argc ) bad_arg; }
   q = argv[i];
} else q = p+2;
switch( *(p+1) ){
  case 'd':{ dir = q;  break; }
  case 'e':{ 
if( !access(p+2,F_OK) ) tex4ht_env_file = q;
else warn_i_str(6,q);

 break; }
  case 'h':{ htf_cfg = q;  break;}
  case 'i':{ debug = q-1;  break;}
  case 'm':{ ch_mod = q;  break; }
  case 'p':{ nopict = q-1;  break;}
  case 'S':{ 
{     struct sys_call_rec *q;
  q = m_alloc(struct sys_call_rec, 1);
  q->next = system_calls;
  q->filter = p + 2;
  system_calls = q;
}

 break; }
   default:{ bad_arg;  }
}

 }
    else lg_name = argv[i];
  }
  if( lg_name == NULL ){ bad_arg; }
}


   

{                                FILE* file;
   
{         Q_CHAR  str[512], *HOME_DIR;
   
file = tex4ht_env_file?
      fopen( tex4ht_env_file, READ_TEXT_FLAGS ) : NULL;
if( debug && file ){
      (IGNORED) printf(".......Open: %s\n", tex4ht_env_file); }


   if( !file ) {  file = fopen("tex4ht.env", READ_TEXT_FLAGS);
      if( debug && file ){
         (IGNORED) printf(".......Open: ./tex4ht.env\n"); }
   }
   if( !file ) { 
if( dos_env_file ){
   file =  fopen( dos_env_file, READ_TEXT_FLAGS ) ;
   if( debug && file ){
      (IGNORED) printf(".......Open: %s\n", dos_env_file); }
}

 }
#ifndef DOS_WIN32
   if( !file ) {  file = fopen(".tex4ht", READ_TEXT_FLAGS);
      if( debug && file ){
         (IGNORED) printf(".......Open: ./.tex4ht\n"); }
   }
#endif
   
if( !file ){
  HOME_DIR = getenv("HOME");
  if( HOME_DIR ){ (IGNORED) sprintf(str,
#if defined(DOS_WIN32) || defined(__DJGPP__)
  is_forward_slash(HOME_DIR)?  "%s/tex4ht.env" :  "%s\\tex4ht.env"
#else
  "%s/tex4ht.env"
#endif

, HOME_DIR);
     file = fopen(str,READ_TEXT_FLAGS);
     if( debug && file ){
        (IGNORED) printf(".......Open: %s\n", str); }
  }
}
#ifndef DOS_WIN32
  if( !file ){
     if( HOME_DIR ){  (IGNORED) sprintf(str,"%s/.tex4ht", HOME_DIR);
                      file = fopen(str,READ_TEXT_FLAGS);     }
  }
#endif
#if defined(DOS_WIN32) || defined(__MSDOS__)
   if( !file ){
      file = fopen("C:/tex4ht.env",READ_TEXT_FLAGS);
   }
#endif


#ifdef ENVFILE
   if( !file ) {
      file = fopen( ENVFILE,READ_TEXT_FLAGS);
      if( debug && file ){
         (IGNORED) printf(".......Open: %s\n", ENVFILE); }
   }
#endif
   
#ifdef KPATHSEA
if( !file )  {
   file = kpse_open_file ("tex4ht.env", kpse_program_text_format);
   if( debug && file ){
      (IGNORED) printf(".......Open kpathsea tex4ht.env\n"); }
}
#endif


   if( !file ) warn_i_str( 5, 
#ifdef  DOS_WIN32
   "tex4ht.env"
#endif
#ifndef  DOS_WIN32
   "tex4ht.env | .tex4ht"
#endif

);
}


   if( file ){
      
eoln_ch = (int) 'x';
while( eoln_ch != EOF ) {                Q_CHAR ch;
  ch = (char) (eoln_ch = getc(file));
  if( eoln_ch != (int) '\n' ){
     status = scan_until_end_str("", 1, TRUE, file);
     if( status ){
       switch( ch ){
         case 'A':{ 
if( debug ){
      (IGNORED) printf(".......'A' script\n"); }
chmod_script = add_script(chmod_script);

  break;}
         case 'C':{ 
if( debug ){
      (IGNORED) printf(".......'C' script\n"); }
copy_script = add_script(copy_script);

  break;}
         case 'E':{ 
if( debug ){
      (IGNORED) printf(".......'E' script\n"); }
empty_fig_script = add_script(empty_fig_script);

  break;}
         case 'F':{ 
if( debug ){
      (IGNORED) printf(".......'F' script\n"); }
dvigif_glyp_script = add_script(dvigif_glyp_script);

   break;}
         case 'G':{ 
if( debug ){
      (IGNORED) printf(".......'G' script\n"); }
dvigif_script = add_script(dvigif_script);

   break;}
         case 'H':{ 
env_htf_sty = match[1];
match[1] = (Q_CHAR *) malloc(70);
max_match[1] = 70;
if( debug ){
   (IGNORED) printf(".......'H' script: '%s'\n",
                            env_htf_sty); }

 break;}
         case 'M':{ 
if( debug ){
      (IGNORED) printf(".......'M' script\n"); }
move_script = add_script(move_script);

  break;}
         case 'S':{ 
{     struct sys_call_rec *q;
  q = m_alloc(struct sys_call_rec, 1);
  q->next = system_calls;
  q->filter = match[1];
              match[1] = (Q_CHAR *) malloc(70);  max_match[1] = 70;
  system_calls = q;
if( debug ){
   (IGNORED) printf(".......'S' script: '%s'\n",
                                q->filter); }
}

  break;}
         default:{ }
} }  }  }


      (IGNORED) fclose(file);
}  }



{                          FILE* file;
                           int int_ch;
   
if( htf_cfg ){
   file  = open_file(htf_cfg, ".env");
} else {                                  C_CHAR filename[255];
   file  = fopen("htfcss.env", READ_TEXT_FLAGS);
   if ( !file && env_htf_sty ){
      (IGNORED) strcpy(filename, env_htf_sty);
      (IGNORED) strct(filename, "htfcss.env");
      file = fopen(filename, READ_TEXT_FLAGS);
   }
   if ( !file ){
      (IGNORED) strcpy(filename, HTFDIR );
      (IGNORED) strct(filename, "htfcss.env");
      file = fopen(filename, READ_TEXT_FLAGS);
   }
   
#ifdef KPATHSEA
  if( !file )
    file = kpse_open_file ("htfcss.env", kpse_program_text_format);
#endif


   if( !file ) { (IGNORED) warn_i_str(5,"htfcss.env"); }
   else { (IGNORED) printf ("Entering htfcss.env\n"); }
}


   if( file  ) {
                      
char *key, *body;
int  key_n, body_n, max_key, max_body;


struct htf_struct *last_rec, *p;


      
key = (Q_CHAR *) m_alloc(char, (int) 255);
*key = '\0';  max_key = 255;
body = (Q_CHAR *) m_alloc(char, (int) 255);
*body = '\0'; max_body = 255; body_n = 0;


last_rec = (struct htf_struct *) 0;


      
while( (int_ch =getc(file)) != EOF){
  if( (int_ch != (int) ' ') && (int_ch != (int) '\n') ){ break; }
  while( (int_ch != (int) '\n') && (int_ch != EOF) ){
    int_ch = getc(file); }
}


      while( int_ch != EOF ) {
        if(  int_ch !=  (int) ' ' ){
          
if( (*key != '\0') && (*key != '\n') ) {
   p = m_alloc(struct htf_struct, 1);
   p->next =  (struct htf_struct *) 0;
   p->key =   m_alloc(char, (int) strlen(key) + 1);
   (IGNORED) strcpy( p->key, key );
   p->body =   m_alloc(char, (int) strlen(body) + 1);
   (IGNORED) strcpy( p->body, body );
   if( last_rec ){
      last_rec->next = p;  last_rec = p;
   } else {
      htf_rec = last_rec = p;
   }
   if( debug ){
      (IGNORED) printf(".......%s...%s\n", key, body);
} }


          
*key = int_ch; key_n = 1;   key[key_n] = '\0';
while( (int_ch =getc(file)) != EOF ) {
  if( key_n == max_key ){
     max_key +=10;
     key =  (Q_CHAR *)  r_alloc((void *) key,  (size_t) max_key);
  }
  if( (int_ch ==  (int)' ') ||  (int_ch == (int) '\n') ){
     key[key_n] = '\0'; break;
  }
  key[key_n++] = int_ch;
}
body_n = 0;
if( int_ch == (int) ' ') {
  while( (int_ch =getc(file)) == (int) ' ' ) { ; }
}
if( (int_ch != (int) '\n') && (int_ch != EOF) ){
  body[body_n++] = int_ch;
  while( (int_ch =getc(file)) != EOF ) {
    if( body_n == max_body ){
       max_body +=10;
       body =  (Q_CHAR *)  r_alloc((void *) body,  (size_t) max_body);
    }
    if( int_ch == (int) '\n' ){ break; }
    body[body_n++] = int_ch;
  }
}
body[body_n++] = '\0';


        } else {
          
if( body_n > max_body - 1 ){
   max_body +=10;
   body =  (Q_CHAR *)  r_alloc((void *) body,  (size_t) max_body);
}
body[body_n-1] = '\n';
body[body_n++] = (char) int_ch;
while( (int_ch =getc(file)) != EOF ) {
  if( body_n == max_body ){
     max_body +=10;
     body =  (Q_CHAR *)  r_alloc((void *) body,  (size_t) max_body);
  }
  if( int_ch == (int) '\n' ){ break; }
  body[body_n++] = int_ch;
}
body[body_n++] = '\0';


        }
        int_ch = getc(file);
      }
      
if( (*key != '\0') && (*key != '\n') ) {
   p = m_alloc(struct htf_struct, 1);
   p->next =  (struct htf_struct *) 0;
   p->key =   m_alloc(char, (int) strlen(key) + 1);
   (IGNORED) strcpy( p->key, key );
   p->body =   m_alloc(char, (int) strlen(body) + 1);
   (IGNORED) strcpy( p->body, body );
   if( last_rec ){
      last_rec->next = p;  last_rec = p;
   } else {
      htf_rec = last_rec = p;
   }
   if( debug ){
      (IGNORED) printf(".......%s...%s\n", key, body);
} }


      (IGNORED) fclose(file);
   }
}


lg_file = open_file(lg_name,".lg");
if( lg_file ) {
   
begin_lg_file = ftell(lg_file);


   
(IGNORED)  fseek(lg_file, begin_lg_file, 
0
);

  
eoln_ch = (int) 'x';
while( eoln_ch != EOF ) {
   status = scan_str("Font_Css_Plus ", TRUE, lg_file);
   status = scan_until_str(" ", 1, status, lg_file);
   status = scan_until_end_str("", 2, status, lg_file);
   if( status ){                          Q_CHAR *key;
      key = match[1];
      *(key + (int) strlen(key) - 1) = '\0';
      
if( (*key != '\0') && (*key != '\n') ) {
                            struct htf_struct *p;
   p = m_alloc(struct htf_struct, 1);
   p->next =  htf_rec;
   htf_rec = p;
   p->key =   m_alloc(char, (int) strlen(key) + 1);
   (IGNORED) strcpy( p->key, key );
   p->body =   m_alloc(char, (int) strlen(match[2]) + 1);
   (IGNORED) strcpy( p->body, match[2] );
   if( debug ){
      (IGNORED) printf(".......%s...%s\n", key, match[2]);
} }


} }


   
(IGNORED)  fseek(lg_file, begin_lg_file, 
0
);

  
{                             struct empty_pic_struct *last;
   last = empty_pic = (struct empty_pic_struct *) 0;
   while( TRUE ) {
      status = scan_str("--- empty picture --- ", TRUE, lg_file);
      status = scan_until_str( ".idv[" , 1, status, lg_file);
      status = scan_until_end_str("] ---", 1, status, lg_file);
      if( status ){ 
if( last == (struct empty_pic_struct *) 0 ){
   last = empty_pic = (struct empty_pic_struct *)
                   m_alloc(struct empty_pic_struct, (int) 1);
} else {
   last = last->next = (struct empty_pic_struct *)
                   m_alloc(struct empty_pic_struct, (int) 1);
}
last->next = (struct empty_pic_struct *) 0;
last->n = get_long_int(match[1]);

 }
      if ( eoln_ch == EOF ){ break; }
   }
   
if( last == (struct empty_pic_struct *) 0 ){
   last = empty_pic = (struct empty_pic_struct *)
                   m_alloc(struct empty_pic_struct, (int) 1);
} else {
   last = last->next = (struct empty_pic_struct *)
                   m_alloc(struct empty_pic_struct, (int) 1);
}
last->next = (struct empty_pic_struct *) 0;
last->n = get_long_int(match[1]);


   last->next = (struct empty_pic_struct *) 0;
   last->n = 100000;
}


   
(IGNORED)  fseek(lg_file, begin_lg_file, 
0
);

  
{                               BOOL characters, skip;
   characters = skip = FALSE;
   while( TRUE ) {
      status = scan_until_str("--- ", 1, TRUE, lg_file);
      status = scan_until_str( " ---" , 2, status, lg_file);
      if( status ) {
        if( eq_str(match[1],"--- ") ){
           if( eq_str(match[2],"needs ---") ){
                
status = scan_until_str(" ", 1, status, lg_file);
status = scan_until_str(".idv", 1, status, lg_file);
status = scan_until_str("[", 2, status, lg_file);
status = scan_until_str("] ==> ", 2, status, lg_file);
status = scan_until_str(" ", 3, status, lg_file);
   *(match[3] + (int) strlen(match[3]) - 1) = '\0';
status = scan_until_end_str("---", 4, status, lg_file);
if( status ) {
               long int gif_i;
               Q_CHAR *p;
   gif_i = get_long_int(match[2]);
   p = match[2];
   *(p + (int) strlen(p) - 6) = '\0';
   if( characters ){
      
                  Q_CHAR filename[255];
                  FILE* file;
(IGNORED) strcpy(filename, "");
if( dir ){ (IGNORED) strct(filename, dir); }
(IGNORED) strct(filename, match[3]);
file  = fopen(filename, READ_TEXT_FLAGS);
if( !file ){
   
(void) execute_script(dvigif_glyp_script?
   dvigif_glyp_script : dvigif_script,match[1],match[2],match[3],"");
if( dir && !system_return ){
  (void) execute_script(move_script,match[3],dir,".","");
}
if( ch_mod && !system_return ){
  (void) execute_script(chmod_script, ch_mod, dir?dir:"",match[3], "");
}


} else {
   (IGNORED) fclose(file);
   (IGNORED) printf("%s already in %s\n", match[3],
                           dir? dir : "current directory" );
}


   } else { 
if( gif_i == 
empty_pic->n

 ) {
  
if( !skip ){
   (void) execute_script(empty_fig_script,
                           dir? dir :"", match[3],"","");
   if( ch_mod && !system_return ){
     (void) execute_script(chmod_script, ch_mod,
                           dir?dir:"",match[3], "");
   }
}
empty_pic = empty_pic->next;


} else { 
if( !nopict && !skip ){
   
(void) execute_script(dvigif_script,match[1],match[2],match[3],"");
if( dir && !system_return ){
  (void) execute_script(move_script,match[3],dir,".","");
}
if( ch_mod && !system_return ){
  (void) execute_script(chmod_script, ch_mod, dir?dir:"",match[3], "");
}


}

 }

 }
}


           } else if( eq_str(match[2],"characters ---") ){
              
status = scan_until_end_str("", 1, status, lg_file);
characters = eq_str(match[1],"");


           } else { 
status = scan_until_end_str("", 1, status, lg_file);

 }
        } else { 
status = scan_until_end_str(" ignore ---", 2, status, lg_file);
if( status ){
  skip =  eq_str(match[2]," ignore ---") ? TRUE :
            ( eq_str(match[2]," end ignore ---") ? FALSE : skip );
}

 }
      }
      if ( eoln_ch == EOF ){ break; }
   }
}


   
(IGNORED)  fseek(lg_file, begin_lg_file, 
0
);

  
{
                               Q_CHAR   css_name[255], *p;
                               FILE   *css_file, *tmp_file;
                               BOOL   css_sty;
   
(IGNORED) strcpy( css_name, lg_name);
p = css_name;
while( *p  ){
   if( *p == '.' ){ *p = '\0';  break; }
   p++;
}
(IGNORED) strct(css_name, ".css");
css_file = fopen(css_name, READ_TEXT_FLAGS);


   if( css_file ){
      (IGNORED) printf ("Entering %s\n", css_name);
      tmp_file = fopen("tex4ht.tmp", WRITE_TEXT_FLAGS);
      if( !tmp_file ) {
         (IGNORED) warn_i_str(5,"tex4ht.tmp");
      } else { 
                   int ch;
while( (ch = getc(css_file)) != EOF ) {
  (IGNORED) putc( ch, tmp_file );
}
(IGNORED) fclose(tmp_file);
(IGNORED) fclose(css_file);

 }
      tmp_file = open_file("tex4ht.tmp", ".tmp");
      css_file = fopen(css_name, WRITE_TEXT_FLAGS);
      if( !tmp_file ) {
         (IGNORED) warn_i_str(5,"tex4ht.tmp");
      } else if( !css_file ) {
         (IGNORED) warn_i_str(5,css_name);
      } else {
        
css_sty = FALSE;
eoln_ch = (int) 'x';
while( eoln_ch != EOF ) {
  status = scan_until_end_str("", 1, TRUE, tmp_file);
  
{                          Q_CHAR *p, *q;
                           int  n;
  n = 0;  p = match[1];    q = match[2];
  while ( (*p != '\0') ){
    if (n == 13) { *(q-10) = '\0';  break;}
    if( *p != ' ' ){ *(q++) = *p; n++; }
    p++;
  }
  *q = '\0';
}


  if( eq_str(match[2], "/*css.sty*/") ){ css_sty = TRUE;  break; }
  (IGNORED) fprintf(css_file, "%s\n", match[1]);
}


        if( css_sty ){
           
(IGNORED) fprintf(css_file, "/* start css.sty */\n");

(IGNORED)  fseek(lg_file, begin_lg_file, 
0
);

  
eoln_ch = (int) 'x';
while( eoln_ch != EOF ) {
   status = scan_str("Font_Size: ", TRUE, lg_file);
   status = scan_until_end_str("", 1, status, lg_file);
   if( status ){
      base_font_size = (int) get_long_int(match[1]);
} }



(IGNORED)  fseek(lg_file, begin_lg_file, 
0
);

  
eoln_ch = (int) 'x';
while( eoln_ch != EOF ) {
   status = scan_str("Font(\"", TRUE, lg_file);
   status = scan_until_str("\",\"", 1, status, lg_file);
   status = scan_until_str("\",\"", 2, status, lg_file);
   status = scan_until_str("\",\"", 3, status, lg_file);
   status = scan_until_end_str("\")", 4, status, lg_file);
   if( status ){
                      Q_CHAR *p;
                      struct htf_struct *font_sty;
                      int second;
      p = match[1];
      *(p + (int) strlen(p) - 3) = '\0';
      p = match[2];
      *(p + (int) strlen(p) - 3) = '\0';
      p = match[3];
      *(p + (int) strlen(p) - 3) = '\0';
      p = match[4];
      *(p + (int) strlen(p) - 2) = '\0';
      
font_sty = htf_rec;
while ( font_sty  ) {
  if( eq_str(font_sty->key,match[1]) ){ break; }
  font_sty = font_sty->next;
}


      
{                                                  Q_CHAR *p;
                                                   int first;
   second =   (int)
              (  (first = (int) get_long_int(match[3]))
               * (int) get_long_int(match[4])
               / base_font_size
              );
   if( first > 100 ){  second /= 100; }
   p = match[3];
   while( *p != '\0' ){
     if( (*p < '0') || (*p > '9') ){ second = 100; break; }
     p++;
   }
}


      if( font_sty || (second != 100) ){
         
(IGNORED) fprintf(css_file, ".%s-%s", match[1], match[2]);
if( !eq_str(match[4],"100") ){
   (IGNORED) fprintf(css_file, "--%s", match[4]);
}
(IGNORED) fprintf(css_file, "{");
if( second != 100 ){
   (IGNORED) fprintf(css_file, "font-size:%d%c;", second, '%');
}
if( font_sty  ) {
   (IGNORED) fprintf(css_file, font_sty->body);
}
(IGNORED) fprintf(css_file, "}\n");


}  }  }



(IGNORED)  fseek(lg_file, begin_lg_file, 
0
);

  
eoln_ch = (int) 'x';
while( eoln_ch != EOF ) {
   status = scan_str("Font_Css(\"", TRUE, lg_file);
   status = scan_until_str("\"): ", 1, status, lg_file);
   status = scan_until_end_str("", 1, status, lg_file);
   if( status ){
      (IGNORED) fprintf(css_file, "%s\n", match[1]);
}  }



(IGNORED)  fseek(lg_file, begin_lg_file, 
0
);

  
eoln_ch = (int) 'x';
while( eoln_ch != EOF ) {
   status = scan_str("Css: ", TRUE, lg_file);
   status = scan_until_end_str("", 1, status, lg_file);
   if( status ){
      (IGNORED) fprintf(css_file, "%s\n", match[1]);
} }


(IGNORED) fprintf(css_file, "/* end css.sty */\n");


           
        }
      }
      (IGNORED) fclose(tmp_file);
      (IGNORED) fclose(css_file);
}  }


   
(IGNORED)  fseek(lg_file, begin_lg_file, 
0
);

  
eoln_ch = (int) 'x';
while( eoln_ch != EOF ) {
   status = scan_str("File: ", TRUE, lg_file);
   status = scan_until_end_str("", 1, status, lg_file);
   if( status && !eq_str(match[1],"tex4ht.tmp") ){
      if( dir ){
         (void) execute_script(copy_script, match[1],
                               dir? dir :"",".","");
      }
      if( ch_mod ){
         (void) execute_script(chmod_script, ch_mod,
                               dir? dir:"",match[1], "");
      }
}  }


   
(IGNORED)  fseek(lg_file, begin_lg_file, 
0
);

  
eoln_ch = (int) 'x';
while( eoln_ch != EOF ) {              Q_CHAR *command, ch;
                                       int n;
                                       struct sys_call_rec *p;
                                       BOOL flag;
   status = scan_str("l. ", TRUE, lg_file);
   status = scan_until_str(" --- needs --- \"", 1, status, lg_file);
   status = scan_until_str("\" ---", 2, status, lg_file);
   if( status ){
      command = match[2];
      *(command + (int) strlen(command) - 5) = '\0';
      
flag = FALSE;
p = system_calls;
while( p ){
  if( (n = (int) strlen(p->filter)) == 1 ) {
     if( *(p->filter) == '*' ){
         flag = TRUE; break;
     }
  }
  if( strlen(command) >= (unsigned int) n ) {
      ch = command[n]; command[n] = '\0';
      flag = flag || eq_str(p->filter,command);
      command[n] = ch;
  }
  p = p->next;
}


      if( flag ){
        
(IGNORED) call_sys(command);


      } else { (IGNORED) printf(
          "No permission for system call: %s\n", command); }
}  }


   (IGNORED) fclose(lg_file);
}


   return 0;
}


