;;; cjk-enc.el --- provide a coding system for LaTeX2e CJK package

;; Copyright (C) 1996, 1998 Electrotechnical Laboratory, JAPAN.

;; Author: Kenichi HANDA <handa@etl.go.jp>
;;         Werner LEMBERG <wl@gnu.org>

;; Keywords: CJK package, LaTeX2e, mule

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;;
;; CJK Version 4.2.0 (13-Dec-1998)
;;

;;; Code

;; The following tables map from Mule's internal encoding to LaTeX2e
;; macros.  Note that not all macros defined here really do exist. See
;; MULEenc.sty and cjk-enc.doc for further details.
;;
;; The active TeX character 0x80 is defined as a multiplex command which
;; executes its first argument. To make the macro expansion robust
;; against \uppercase and \lowercase, numbers are used as parameters which
;; index the various commands.
;;
;; 0xFF will be used as a parameter delimiting character.

(defconst latin-1
  [;0xa0
   "99\377"     "1\377"     "2\377"     "3\377"
   "4\377"      "5\377"     "6\377"     "7\377"
   "8\377\\ "   "9\377"     "10\377"    "11\377"
   "12\377"     "13\377"    "14\377"    "15\377\\ "

   ; 0xb0
   "16\377"     "17\377"    "18\377"    "19\377"
   "20\377\\ "  "21\377"    "22\377"    "23\377"
   "24\377\\ "  "25\377"    "26\377"    "27\377"
   "28\377"     "29\377"    "30\377"    "31\377"

   ; 0xc0
   "32\377A"    "20\377A"   "33\377A"   "34\377A"
   "8\377A"     "0\377\\AA" "0\377\\AE" "24\377C"
   "32\377E"    "20\377E"   "33\377E"   "8\377E"
   "32\377I"    "20\377I"   "33\377I"   "8\377I"

   ; 0xd0
   "0\377\\DJ"  "34\377N"   "32\377O"   "20\377O"
   "33\377O"    "34\377O"   "8\377O"    "38\377"
   "0\377\\O"   "32\377U"   "20\377U"   "33\377U"
   "8\377U"     "20\377Y"   "0\377\\TH" "0\377\\ss"

   ; 0xe0
   "32\377a"    "20\377a"   "33\377a"   "34\377a"
   "8\377a"     "0\377\\aa" "0\377\\ae" "24\377c"
   "32\377e"    "20\377e"   "33\377e"   "8\377e"
   "32\377\\i"  "20\377\\i" "33\377\\i" "8\377\\i"

   ; 0xf0
   "0\377\\dj"  "34\377n"   "32\377o"   "20\377o"
   "33\377o"    "34\377o"   "8\377o"    "45\377"
   "0\377\\o"   "32\377u"   "20\377u"   "33\377u"
   "8\377u"     "20\377y"   "0\377\\th" "8\377y"
  ])

(defconst latin-2
  [; 0xa0
   "99\377"     "48\377A"   "49\377\\ " "0\377\\L"
   "4\377"      "51\377L"   "20\377S"   "7\377"
   "8\377\\ "   "51\377S"   "24\377S"   "51\377T"
   "20\377Z"    "13\377"    "51\377Z"   "52\377Z"

   ; 0xb0
   "16\377"     "48\377a"   "48\377\\ " "0\377\\l"
   "20\377\\ "  "51\377l"   "20\377s"   "51\377\\ "
   "24\377\\ "  "51\377s"   "24\377s"   "51\377t"
   "20\377z"    "55\377\\ " "51\377z"   "52\377z"

   ; 0xc0
   "20\377R"    "20\377A"   "33\377A"   "49\377A"
   "8\377A"     "20\377L"   "20\377C"   "24\377C"
   "51\377C"    "20\377E"   "48\377E"   "8\377E"
   "51\377E"    "20\377I"   "33\377I"   "51\377D"

   ; 0xd0
   "0\377\\DJ"  "20\377N"   "51\377N"   "20\377O"
   "33\377O"    "55\377O"   "8\377O"    "38\377"
   "51\377R"    "53\377U"   "20\377U"   "55\377U"
   "8\377U"     "20\377Y"   "24\377T"   "0\377\\ss"

   ; 0xe0
   "20\377r"    "20\377a"   "33\377a"   "49\377a"
   "8\377a"     "20\377l"   "20\377c"   "24\377c"
   "51\377c"    "20\377e"   "48\377e"   "8\377e"
   "51\377e"    "20\377\\i" "33\377\\i" "51\377d"

   ; 0xf0
   "0\377\\dj"  "20\377n"   "51\377n"   "20\377o"
   "33\377o"    "55\377o"   "8\377o"    "45\377"
   "51\377r"    "53\377u"   "20\377u"   "55\377u"
   "8\377u"     "20\377y"   "24\377t"   "52\377\\ "
  ])

(defconst latin-3
  [; 0xa0
   "99\377"     "0\377\\TEXTMALTESEH"   "49\377\\ " "3\377"
   "4\377"      ""                      "33\377H"   "7\377"
   "8\377\\ "   "52\377I"               "24\377S"   "49\377G"
   "33\377J"    "13\377"                ""          "52\377Z"

   ; 0xb0
   "16\377"     "0\377\\textmalteseh"   "18\377"    "19\377"
   "20\377\\ "  "21\377"                "33\377h"   "23\377"
   "24\377\\ "  "0\377\\i"              "24\377s"   "49\377g"
   "33\377\\j"  "29\377"                ""          "52\377z"

   ; 0xc0
   "32\377A"    "20\377A"               "33\377A"   ""
   "8\377A"     "52\377C"               "33\377C"   "24\377C"
   "32\377E"    "20\377E"               "33\377E"   "8\377E"
   "32\377I"    "20\377I"               "33\377I"   "8\377I"

   ; 0xd0
   ""           "34\377N"               "32\377O"   "20\377O"
   "33\377O"    "52\377G"               "8\377O"    "38\377"
   "33\377G"    "32\377U"               "20\377U"   "33\377U"
   "8\377U"     "49\377U"               "33\377S"   "0\377\\ss"

   ; 0xe0
   "32\377a"    "20\377a"               "33\377a"   ""
   "8\377a"     "52\377c"               "33\377c"   "24\377c"
   "32\377e"    "20\377e"               "33\377e"   "8\377e"
   "32\377\\i"  "20\377\\i"             "33\377\\i" "8\377\\i"

   ; 0xf0
   ""           "34\377n"               "32\377o"   "20\377o"
   "33\377o"    "52\377g"               "8\377o"    "45\377"
   "33\377g"    "32\377u"               "20\377u"   "33\377u"
   "8\377u"     "49\377u"               "33\377s"   "52\377\\ "
  ])

(defconst latin-4
  [; 0xa0
   "99\377"         "48\377A"   "59\377"    "24\377R"
   "4\377"          "34\377I"   "24\377L"   "7\377"
   "8\377\\ "       "51\377S"   "15\377E"   "24\377G"
   "0\377\\TBAR"    "13\377"    "51\377Z"   "15\377\\ "

   ; 0xb0
   "16\377"         "48\377a"   "48\377\\ " "24\377r"
   "20\377\\ "      "34\377\\i" "24\377l"   "51\377\\ "
   "24\377\\ "      "51\377s"   "15\377e"   "24\377g"
   "0\377\\tbar"    "0\377\\NG" "51\377z"   "0\377\\ng"

   ; 0xc0
   "15\377A"        "20\377A"   "33\377A"   "34\377A"
   "8\377A"         "0\377\\AA" "0\377\\AE" "48\377I"
   "51\377C"        "20\377E"   "48\377E"   "8\377E"
   "52\377E"        "20\377I"   "33\377I"   "15\377I"

   ; 0xd0
   "0\377\\DJ"      "24\377N"   "15\377O"   "24\377K"
   "33\377O"        "34\377O"   "8\377O"    "38\377"
   "0\377\\O"       "48\377U"   "20\377U"   "33\377U"
   "8\377U"         "34\377U"   "15\377U"   "0\377\\ss"

   ; 0xe0
   "15\377a"        "20\377a"   "33\377a"   "34\377a"
   "8\377a"         "0\377\\aa" "0\377\\ae" "48\377i"
   "51\377c"        "20\377e"   "48\377e"   "8\377e"
   "52\377e"        "20\377\\i" "33\377\\i" "15\377\\i"

   ; 0xf0
   "0\377\\dj"      "24\377n"   "15\377o"   "24\377k"
   "33\377o"        "34\377o"   "8\377o"    "45\377"
   "0\377\\o"       "48\377u"   "20\377u"   "33\377u"
   "8\377u"         "34\377u"   "15\377u"   "52\377\\ "
  ])

(defconst latin-5               ; ISO 8859-9
  [; 0xa0
   "99\377"     "1\377"     "2\377"     "3\377"
   "4\377"      "5\377"     "6\377"     "7\377"
   "8\377\\ "   "9\377"     "10\377"    "11\377"
   "12\377"     "13\377"    "14\377"    "15\377\\ "

   ; 0xb0
   "16\377"     "17\377"    "18\377"    "19\377"
   "20\377\\ "  "21\377"    "22\377"    "23\377"
   "24\377\\ "  "25\377"    "26\377"    "27\377"
   "28\377"     "29\377"    "30\377"    "31\377"

   ; 0xc0
   "32\377A"    "20\377A"   "33\377A"   "34\377A"
   "8\377A"     "0\377\\AA" "0\377\\AE" "24\377C"
   "32\377E"    "20\377E"   "33\377E"   "8\377E"
   "32\377I"    "20\377I"   "33\377I"   "8\377I"

   ; 0xd0
   "49\377G"    "34\377N"   "32\377O"   "20\377O"
   "33\377O"    "34\377O"   "8\377O"    "38\377"
   "0\377\\O"   "32\377U"   "20\377U"   "33\377U"
   "8\377U"     "52\377I"   "24\377S"   "0\377\\ss"

   ; 0xe0
   "32\377a"    "20\377a"   "33\377a"   "34\377a"
   "8\377a"     "0\377\\aa" "0\377\\ae" "24\377c"
   "32\377e"    "20\377e"   "33\377e"   "8\377e"
   "32\377\\i"  "20\377\\i" "33\377\\i" "8\377\\i"

   ; 0xf0
   "49\377g"    "34\377n"   "32\377o"   "20\377o"
   "33\377o"    "34\377o"   "8\377o"    "45\377"
   "0\377\\o"   "32\377u"   "20\377u"   "33\377u"
   "8\377u"     "0\377\\i"  "24\377s"   "8\377y"
  ])

(defconst latin-jisx            ; JIS X 0201 lower half
  [; 0xa0
   ""       "0\377!"   "37\377"   "0\377\\#"
   "39\377" "0\377\\%" "0\377\\&" "40\377"
   "0\377(" "0\377)"   "0\377*"   "0\377+"
   "0\377," "0\377-"   "0\377."   "0\377/"

   ; 0xb0
   "0\3770" "0\3771" "0\3772" "0\3773"
   "0\3774" "0\3775" "0\3776" "0\3777"
   "0\3778" "0\3779" "0\377:" "0\377;"
   "41\377" "0\377=" "42\377" "0\377?"

   ; 0xc0
   "36\377" "0\377A" "0\377B" "0\377C"
   "0\377D" "0\377E" "0\377F" "0\377G"
   "0\377H" "0\377I" "0\377J" "0\377K"
   "0\377L" "0\377M" "0\377N" "0\377O"

   ; 0xd0
   "0\377P" "0\377Q" "0\377R" "0\377S"
   "0\377T" "0\377U" "0\377V" "0\377W"
   "0\377X" "0\377Y" "0\377Z" "0\377["
   "5\377"  "0\377]" "43\377" "44\377"

   ; 0xe0
   "46\377" "0\377a" "0\377b" "0\377c"
   "0\377d" "0\377e" "0\377f" "0\377g"
   "0\377h" "0\377i" "0\377j" "0\377k"
   "0\377l" "0\377m" "0\377n" "0\377o"

   ; 0xf0
   "0\377p" "0\377q" "0\377r" "0\377s"
   "0\377t" "0\377u" "0\377v" "0\377w"
   "0\377x" "0\377y" "0\377z" "47\377"
   "50\377" "54\377" "56\377" ""
  ])

(defconst cyrillic              ; ISO 8859-5
  [; 0xa0
   "99\377"          "0\377\\CYRYO"       "0\377\\CYRDJE"      "20\377\\CYRG"
   "0\377\\CYRIE"    "0\377\\CYRDZE"      "0\377\\CYRII"       "0\377\\CYRYI"
   "0\377\\CYRJE"    "0\377\\CYRLJE"      "0\377\\CYRNJE"      "0\377\\CYRTSHE"
   "20\377\\CYRK"    "13\377"             "0\377\\CYRUSHRT"    "0\377\\CYRDZHE"

   ; 0xb0
   "0\377\\CYRA"     "0\377\\CYRB"        "0\377\\CYRV"        "0\377\\CYRG"
   "0\377\\CYRD"     "0\377\\CYRE"        "0\377\\CYRZH"       "0\377\\CYRZ"
   "0\377\\CYRI"     "0\377\\CYRISHRT"    "0\377\\CYRK"        "0\377\\CYRL"
   "0\377\\CYRM"     "0\377\\CYRN"        "0\377\\CYRO"        "0\377\\CYRP"

   ; 0xc0
   "0\377\\CYRR"     "0\377\\CYRS"        "0\377\\CYRT"        "0\377\\CYRU"
   "0\377\\CYRF"     "0\377\\CYRH"        "0\377\\CYRC"        "0\377\\CYRCH"
   "0\377\\CYRSH"    "0\377\\CYRSHCH"     "0\377\\CYRHRDSN"    "0\377\\CYRERY"
   "0\377\\CYRSFTSN" "0\377\\CYREREV"     "0\377\\CYRYU"       "0\377\\CYRYA"

   ; 0xd0
   "0\377\\cyra"     "0\377\\cyrb"        "0\377\\cyrv"        "0\377\\cyrg"
   "0\377\\cyrd"     "0\377\\cyre"        "0\377\\cyrzh"       "0\377\\cyrz"
   "0\377\\cyri"     "0\377\\cyrishrt"    "0\377\\cyrk"        "0\377\\cyrl"
   "0\377\\cyrm"     "0\377\\cyrn"        "0\377\\cyro"        "0\377\\cyrp"

   ; 0xe0
   "0\377\\cyrr"     "0\377\\cyrs"        "0\377\\cyrt"        "0\377\\cyru"
   "0\377\\cyrf"     "0\377\\cyrh"        "0\377\\cyrc"        "0\377\\cyrch"
   "0\377\\cyrsh"    "0\377\\cyrshch"     "0\377\\cyrhrdsn"    "0\377\\cyrery"
   "0\377\\cyrsftsn" "0\377\\cyrerev"     "0\377\\cyryu"       "0\377\\cyrya"

   ; 0xf0
   "35\377"          "0\377\\cyryo"       "0\377\\cyrdje"      "20\377\\cyrg"
   "0\377\\cyrie"    "0\377\\cyrdze"      "0\377\\cyrii"       "0\377\\cyryi"
   "0\377\\cyrje"    "0\377\\cyrlje"      "0\377\\cyrnje"      "0\377\\cyrtshe"
   "20\377\\cyrk"    "7\377"              "0\377\\cyrushrt"    "0\377\\cyrdzhe"
  ])

(defconst viscii-lower
  [; 0xA0
   ""                    "20\377\\abreve"      "32\377\\abreve"      "71\377\\abreve"
   "20\377\\acircumflex" "32\377\\acircumflex" "73\377\\acircumflex" "71\377\\acircumflex"
   "34\377e"             "71\377e"             "20\377\\ecircumflex" "32\377\\ecircumflex"
   "73\377\\ecircumflex" "34\377\\ecircumflex" "71\377\\ecircumflex" "20\377\\ocircumflex"

   ; 0xB0
   "32\377\\ocircumflex" "73\377\\ocircumflex" "34\377\\ocircumflex" ""
   ""                    "71\377\\ocircumflex" "32\377\\ohorn"       "73\377\\ohorn"
   "71\377i"             ""                    ""                    ""
   ""                    "0\377\\ohorn"        "20\377\\ohorn"       ""

   ; 0xC0
   ""                    ""                    ""                    ""
   ""                    ""                    "73\377\\abreve"      "34\377\\abreve"
   ""                    ""                    ""                    ""
   ""                    ""                    ""                    "32\377y"

   ; 0xD0
   ""                    "20\377\\uhorn"       ""                    ""
   ""                    "71\377a"             "73\377y"             "32\377\\uhorn"
   "73\377\\uhorn"       ""                    ""                    "34\377y"
   "71\377y"             ""                    "34\377\\ohorn"       "0\377\\uhorn"

   ; 0xE0
   "32\377a"             "20\377a"             "0\377\\acircumflex"  "34\377a"
   "73\377a"             "0\377\\abreve"       "34\377\\uhorn"       "34\377\\acircumflex"
   "32\377e"             "20\377e"             "0\377\\ecircumflex"  "73\377e"
   "32\377i"             "20\377i"             "34\377i"             "73\377i"

   ; 0xF0
   "0\377\\dj"           "71\377\\uhorn"       "32\377o"             "20\377o"
   "0\377\\ocircumflex"  "34\377o"             "73\377o"             "71\377o"
   "71\377u"             "32\377u"             "20\377u"             "34\377u"
   "73\377u"             "20\377y"             "71\377\\ohorn"       ""
  ])

(defconst viscii-upper
  [; 0xA0
   ""                    "20\377\\ABREVE"      "32\377\\ABREVE"      "71\377\\ABREVE"
   "20\377\\ACIRCUMFLEX" "32\377\\ACIRCUMFLEX" "73\377\\ACIRCUMFLEX" "71\377\\ACIRCUMFLEX"
   "34\377E"             "71\377E"             "20\377\\ECIRCUMFLEX" "32\377\\ECIRCUMFLEX"
   "73\377\\ECIRCUMFLEX" "34\377\\ECIRCUMFLEX" "71\377\\ECIRCUMFLEX" "20\377\\OCIRCUMFLEX"

   ; 0xB0
   "32\377\\OCIRCUMFLEX" "73\377\\OCIRCUMFLEX" "34\377\\OCIRCUMFLEX" ""
   ""                    "71\377\\OCIRCUMFLEX" "32\377\\OHORN"       "73\377\\OHORN"
   "71\377I"             ""                    ""                    ""
   ""                    "0\377\\OHORN"        "20\377\\OHORN"       ""

   ; 0xC0
   ""                    ""                    ""                    ""
   ""                    ""                    "73\377\\ABREVE"      "34\377\\ABREVE"
   ""                    ""                    ""                    ""
   ""                    ""                    ""                    "32\377Y"

   ; 0xD0
   ""                    "20\377\\UHORN"       ""                    ""
   ""                    "71\377A"             "73\377Y"             "32\377\\UHORN"
   "73\377\\UHORN"       ""                    ""                    "34\377Y"
   "71\377Y"             ""                    "34\377\\OHORN"       "0\377\\UHORN"

   ; 0xE0
   "32\377A"             "20\377A"             "0\377\\ACIRCUMFLEX"  "34\377A"
   "73\377A"             "0\377\\ABREVE"       "34\377\\UHORN"       "34\377\\ACIRCUMFLEX"
   "32\377E"             "20\377E"             "0\377\\ECIRCUMFLEX"  "73\377E"
   "32\377I"             "20\377I"             "34\377I"             "73\377I"

   ; 0xF0
   "0\377\\DJ"           "71\377\\UHORN"       "32\377O"             "20\377O"
   "0\377\\OCIRCUMFLEX"  "34\377O"             "73\377O"             "71\377O"
   "71\377U"             "32\377U"             "20\377U"             "34\377U"
   "73\377U"             "20\377Y"             "71\377\\OHORN"       ""
  ])


;; the following encodings will be selected (if they occur in the input 
;; buffer) at the very beginning of the output buffer to load the
;; corresponding CJK macros.
(defconst CJKenc-table
  (let ((vec (make-vector 256 nil)))
    (aset vec lc-cn "GB")
    (aset vec lc-kana "SJIS")
    (aset vec lc-jp "JIS")
    (aset vec lc-jp2 "JIS2")
    (aset vec lc-kr "KS")
    (aset vec lc-big5-1 "Bg5")
    (aset vec lc-big5-2 "Bg5")
    (aset vec lc-cns1 "CNS1")
    (aset vec lc-cns2 "CNS2")
    (aset vec lc-cns3 "CNS3")
    (aset vec lc-cns4 "CNS4")
    (aset vec lc-cns5 "CNS5")
    (aset vec lc-cns6 "CNS6")
    (aset vec lc-cns7 "CNS7")
    vec))

(defconst CJKspace "\20064\377\377")
(defconst CJKnospace "\20065\377\377")

;; here we have the format specification table which defines what to do
;; for each encoding.
(defconst format-spec-table
  (let ((vec (make-vector 256 nil)))
    ;; Element is a vector VEC.  Each character is formatted as:
    ;;  (format "\200%s\377" (aref VEC (- char-code 160)))
    (aset vec lc-ltn1 latin-1)
    (aset vec lc-ltn2 latin-2)
    (aset vec lc-ltn3 latin-3)
    (aset vec lc-ltn4 latin-4)
    (aset vec lc-ltn5 latin-5)
    (aset vec lc-roman latin-jisx)
    ;; T2 encoding is used for Cyrillic letters. You must explicitly
    ;; switch between T2 and T1/OT1 encoding.
    (aset vec lc-crl cyrillic)
    ;; for Vietnamese a Vietnamese TeX-font has to be used which contains
    ;; ASCII characters too! You must explicitly switch between Vietnamese
    ;; ET5 and T1/OT1 encoding.
    (aset vec lc-vn-1 viscii-lower)
    (aset vec lc-vn-2 viscii-upper)

    ;; Element is a cons of header HEAD and formatter FORMAT.  HEAD is
    ;; printed first, then each character is formatted as:
    ;;  (format FORMAT char-code-1 char-code-2)
    (aset vec lc-kana '("\20070\377\377" . "%c\377"))
    (aset vec lc-jp '("\20066\377\377" . "%c%d\377"))
    (aset vec lc-cn '("\20067\377\377" . "%c%d\377"))
    (aset vec lc-big5-1 '("\20068\377\377" . "%c%d\377"))
    (aset vec lc-big5-2 '("\20068\377\377" . "%c%d\377"))
    (aset vec lc-kr '("\20069\377\377" . "%c%d\377"))

    ;; Element is a formatter string FORMAT.  Each character is
    ;; formatted as:
    ;;  (format FORMAT char-code-1 char-code-2)
    (aset vec lc-jp2  "\240JIS2\377%d\377%d\377")
    (aset vec lc-cns1 "\240CNS1\377%d\377%d\377")
    (aset vec lc-cns2 "\240CNS2\377%d\377%d\377")
    (aset vec lc-cns3 "\240CNS3\377%d\377%d\377")
    (aset vec lc-cns4 "\240CNS4\377%d\377%d\377")
    (aset vec lc-cns5 "\240CNS5\377%d\377%d\377")
    (aset vec lc-cns6 "\240CNS6\377%d\377%d\377")
    (aset vec lc-cns7 "\240CNS7\377%d\377%d\377")
    vec))


(make-coding-system
 '*cjk-coding* 0 ?c
 "Coding-system for LaTeX2e CJK Package" 1)


(put '*cjk-coding* 'pre-write-conversion 'encode-for-cjk-package)


(defun encode-for-cjk-package (from to)
  (save-excursion
    (save-restriction
      (narrow-to-region from to)
      (let ((mc-flag t)
            (re-multibyte-char "[\200-\237][\240-\377]+")
            (CJKenc (make-vector 256 nil))
            (CJKspace-state nil)
            (require-CJKexecute nil)
            prev-lc lc ch ch1 ch2 format-spec)
        (goto-char (point-min))
        (if (null (let (mc-flag) (re-search-forward re-multibyte-char nil t)))
            ;; No multilingual text.  Nothing to do.
            nil
          (goto-char (match-beginning 0))
          (setq prev-lc lc-ascii)
          (while (not (eobp))
            ;; Now we are at a multibyte character.
            ;; Set the following variables:
            ;;   LC  -- leading char
            ;;   CH1 -- first char code
            ;;   CH2 -- second char code (of two byte chars)
            (setq ch (following-char))
            (delete-char 1)
            (setq lc (char-component ch 0))
            (if (or (= lc lc-big5-1) (= lc lc-big5-2))
                ;; Mule has special encoding for Big5 characters.  We
                ;; must decode them to the normal Big5 codes.
                (let ((vec (g2b ch)))
                  (setq ch1 (aref vec 0) ch2 (aref vec 1)))
              (setq ch1 (char-component ch 1)
                    ch2 (char-component ch 2)))

            ;; FORMAT-SPEC tells how to encode this character.
            (setq format-spec (aref format-spec-table lc))
            (if (null format-spec)
                ;; Unsupported character set.
                nil
              ;; Ok, this character set is supported.  If this character
              ;; set is one of CJK, we need a special header at the
              ;; beginning of the file.
              (if (aset CJKenc lc (aref CJKenc-table lc))
                  (setq require-CJKexecute t))

              (cond ((consp format-spec)
                     ;; We may have to insert the car part of the cons
                     ;; and/or space controlling command
                     ;; (CJKspace/CJKnospace) depending on the current
                     ;; context.
                     (if (= lc lc-kr)
                         (or (eq CJKspace-state CJKspace)
                             (insert (setq CJKspace-state CJKspace)))
                       (or (eq CJKspace-state CJKnospace)
                           (insert (setq CJKspace-state CJKnospace))))
                     (if (/= prev-lc lc)
                         (insert (car format-spec)))
                     (insert (format (cdr format-spec) ch1 ch2)))

                    ((vectorp format-spec)
                     (insert (format "\200%s\377"
                                     (aref format-spec (- ch1 160)))))
                    (t ; FORMAT-SPEC is just a formatting string.
                     (insert (format format-spec ch1 ch2)))))

            ;; Prepare for the next loop.
            (setq prev-lc lc)
            ;; Skip spaces, etc.
            (skip-chars-forward " \t\n")
            ;; If there are any ASCII chars, skip them also, but set
            ;; PREV-LC to LC-ASCII.
            (if (and (< (following-char) 128)
                     (let (mc-flag)
                       (re-search-forward re-multibyte-char nil 'move)))
                (progn
                  (goto-char (match-beginning 0))
                  (setq prev-lc lc-ascii))))

          ;; Now, insert an appropriate header at the head of the file.
          (goto-char (point-min))
          (if require-CJKexecute
              (let ((i 128))
                (insert "\\def\\CJKhook{")
                (while (< i 256)
                  (if (aref CJKenc i)
                      (insert (format "\\CJKenc{%s}" (aref CJKenc i))))
                  (setq i (1+ i)))
                (insert "}")
                (insert "\\ifx\\CJKpreproc\\undefined")
                (insert "\\RequirePackage{MULEenc}")
                (insert "\\RequirePackage[global]{CJK}")
                (insert "\\AtBeginDocument{\\begin{CJK}{}{}\\CJKspace}")
                (insert "\\AtEndDocument{\\end{CJK}}")
                (insert "\\else\\CJKhook\\fi"))
            (insert "\\ifx\\CJKpreproc\\undefined")
            (insert "\\RequirePackage{MULEenc}")
            (insert "\\fi")))))))


(defun write-cjk-file ()
  "Save current buffer and <buffername>.cjk in *cjk-coding*.
Files of the form <buffername>.bib are saved as <buffername>-cjk.bib"

  (interactive)
  (let ((bufname (buffer-file-name))
        body
        extension
        newbufname)
    (string-match "\\(.*\\)\\(\\.[^/]*$\\)" bufname)
    (setq body (match-string 1 bufname)
          extension (match-string 2 bufname))
    (setq newbufname
      (concat body
        (if (string-equal (extension ".bib"))
            "-cjk.bib"
          ".cjk")))
    (message "Saving %s and %s" bufname newbufname)
    (let ((set-file-coding-system *cjk-coding*))
      (write-region (point-min) (point-max) newbufname))
    (save-buffer)))


;;; EOF
