% This is the cweb file bg5conv.w of the CJK Package Ver. 4.2.0  13-Dec-1998
%
% To print this CWEB file you should (but not must) use the CWEAVE of the
% c2cweb-package (found at the CTAN archives, e.g. ftp.dante.de) and then say
%
%           cweave +a bg5conv.w
%
% This (fully compatible) CWEAVE can transform CWEB-files with alternative
% output rules (look at the position of braces below!) the author (it's me
% too :-) prefer. Otherwise this file will be formatted traditionally.

\def\title{bg5conv (CJK Version 4.2.0)}

\def\topofcontents{
  \null\vfill
  \centerline{\titlefont The {\ttitlefont bg5conv} program}
  \vskip 20pt
  \centerline{(CJK Version 4.2.0)}
  \vfill}

\def\botofcontents{
  \vfill
  \noindent
  Copyright \copyright\ 1996, 1998 by Werner Lemberg
  \bigskip\noindent
  Permission is granted to make and distribute verbatim copies of this
  document provided that the copyright notice and this permission notice
  are preserved on all copies.

  \smallskip\noindent
  Permission is granted to copy and distribute modified versions of this
  document under the conditions for verbatim copying, provided that the
  entire resulting derived work is distributed under the terms of a
  permission notice identical to this one.}

\pageno=\contentspagenumber \advance\pageno by 1
\let\maybe=\iftrue
\fullpageheight=240mm
\pageheight=223mm
\pagewidth=158mm
\setpage
\frenchspacing

\noinx
\nosecs
\nocon

@* Function and Use.
This small program will convert Big 5 encoded Chinese in the same way
\.{Bg5conv.tex} will do. The need of this program arises from the fact that
the standard \TeX--distribution under \UNIX/, \.{web2c}, will not \.{\\write}
out characters |>= 0x80| but uses the \.{\char94\char94xx} form instead.

Use this program as a filter:

\hskip 2em \.{bg5conv < input\_file > output\_file}


@* The program.
The only function of this program is to replace all occurrences of Big 5
encoded characters \.{XY} (\.{X} and \.{Y} are the first and the second byte
of the character) with \.{XZZZ\char94\char94ff}, where \.{ZZZ} represents
the second byte as a decimal number followed by \.{0xFF} as a delimiter.

Additionally we define a \TeX\ macro at the very beginning to signal a
preprocessed file.

The following code is very simple. No error detection is done because \TeX\
which will see the output of \.{bg5conv} complains loudly if something is
wrong.


@c
#include <stdio.h>
#include <stdlib.h>@#


void main(argc, argv)
  int argc;
  char *argv[];

   {int ch;

    fprintf(stdout, "\\def\\CJKpreproc{}");@#

    ch = fgetc(stdin);@#

    while(!feof(stdin))
       {if(ch >= 0xA1 && ch <= 0xFE)
           {fputc(ch, stdout);@#

            ch = fgetc(stdin);
            if(!feof(stdin))
                fprintf(stdout, "%d\377", ch);
           }
        else
            fputc(ch, stdout);@#

        ch = fgetc(stdin);
       }
    exit(0);
   }
