#include "StilDialog.h"

#define Inherited QDialog

StilDialog::StilDialog(QWidget* parent,	const char* name) : Inherited(parent,name)
{
    setCaption( "STIL View" );
    setBackgroundMode(PaletteBackground);
    setIcon(*myMainIcon);
	
    tmpQScrollView = new QScrollView( this, "STIL View Scroll Area" );
    tmpQScrollView->setGeometry( 0, 0, 200, 200 );
    tmpQScrollView->setVScrollBarMode(QScrollView::Auto);
    tmpQScrollView->setHScrollBarMode(QScrollView::AlwaysOff);
    tmpQScrollView->setResizePolicy(QScrollView::Manual);
	
    globalLabel = new QLabel(tmpQScrollView);
    globalLabel->hide();
    globalLabel->clear();
    globalLabel->setAutoResize(true);
    {
        QColorGroup globalColour(black,QColor(QRgb(0xc0c0c0)),black,black,black,black,black);
        QPalette palette;
        palette.setNormal(globalColour);
        globalLabel->setPalette( palette );
    }
	
    stilLabel = new QLabel(tmpQScrollView);
    stilLabel->hide();
    stilLabel->clear();
    stilLabel->setAutoResize(true);
    {
        QColorGroup stilColour(black,QColor(QRgb(0xc2f2ff)),black,black,black,black,black);
        QPalette palette;
        palette.setNormal(stilColour);
        stilLabel->setPalette( palette );
    }

    bugLabel = new QLabel(tmpQScrollView);
    bugLabel->hide();
    bugLabel->clear();
    bugLabel->setAutoResize(true);
    {   //QColor(QRgb(0xc2f2ff))
        QColorGroup bugColour(black,red,black,black,black,white,black);
        QPalette palette;
        palette.setNormal(bugColour);
        bugLabel->setPalette( palette );
    }

    resize(300,300);
}

void StilDialog::setConfig(const HVSCconfig& inConfig)
{
    // Copy without verification.
    config = inConfig;
}

void StilDialog::setLabels(const char* global,
                           const char* stil,
						   const char* bug)
{
	int maxHeight = (atoi)(config.maxHeight);

	// Where to position the labels.
	int x = 0, y = 0;
	// Scroll view contents geometry.
	int contentsWidth =0, contentsHeight = 0;

	tmpQScrollView->removeChild(globalLabel);
	if ((global!=NULL) && config.showGlobalComments)
	{
		globalLabel->setText(globalString=global);
		if (globalLabel->width() > contentsWidth)
			contentsWidth = globalLabel->width();
		contentsHeight += globalLabel->height();
		tmpQScrollView->resize(contentsWidth,contentsHeight);
		tmpQScrollView->addChild(globalLabel,x,y);
		globalLabel->show();
		y += globalLabel->height();
	}
	else
	{
		globalLabel->clear();
		globalLabel->hide();
	}
	
	tmpQScrollView->removeChild(stilLabel);
	if ((stil!=NULL) && config.showStilEntries)
	{
		stilLabel->setText(stilString=stil);
		if (stilLabel->width() > contentsWidth)
			contentsWidth = stilLabel->width();
		contentsHeight += stilLabel->height();
		tmpQScrollView->resize(contentsWidth,contentsHeight);
		tmpQScrollView->addChild(stilLabel,x,y);
		stilLabel->show();
		y += stilLabel->height();
	}
	else
	{
		stilLabel->clear();
		stilLabel->hide();
	}

	tmpQScrollView->removeChild(bugLabel);
	if ((bug!=NULL) && config.showBugListEntries)
	{
		bugLabel->setText(bugString=bug);
		if (bugLabel->width() > contentsWidth)
			contentsWidth = bugLabel->width();
		contentsHeight += bugLabel->height();
		tmpQScrollView->resize(contentsWidth,contentsHeight);
		tmpQScrollView->addChild(bugLabel,x,y);
		bugLabel->show();
		y += bugLabel->height();
	}
	else
	{
		bugLabel->clear();
		bugLabel->hide();
	}

	// Right margin (scrollbar safety).
	contentsWidth += 16;

	int dlgHeight = contentsHeight;
	if (dlgHeight > maxHeight)
		dlgHeight = maxHeight;
	
	if ((contentsWidth!=0) && (contentsHeight!=0))
	{
		// Resize each label to contents width.
		globalLabel->resize(contentsWidth,globalLabel->height());
		stilLabel->resize(contentsWidth,stilLabel->height());
		bugLabel->resize(contentsWidth,bugLabel->height());
		
		tmpQScrollView->resizeContents(contentsWidth,contentsHeight);

		setMaximumSize(contentsWidth,contentsHeight);
		if (config.autoResize)
		{
			tmpQScrollView->resize(contentsWidth,dlgHeight);
			resize(contentsWidth,dlgHeight);
		}
		if ( !isVisible() )
			show();
	}
	else
	{
		hide();
	}
}

void StilDialog::clearLabels()
{
	globalLabel->clear();
	stilLabel->clear();
	bugLabel->clear();
}

void StilDialog::resizeEvent(QResizeEvent*)
{
	tmpQScrollView->resize(width(),height());
}
