#ifndef MixerDialog_h
#define MixerDialog_h

#include <sidplay/emucfg.h>  // where we take constants from

#include "MixerDialogData.h"
#include "MixerConfig.h"
#include "GlobalIcon.h"
#include "LEDButton.h"

const int _voices = 4;
const int _effects = 3;

class MixerDialog : public MixerDialogData
{
    Q_OBJECT

public:

    static const int voices;   // not used outside though :(  )
    static const int effects;  //
    
    MixerDialog(QWidget* parent = NULL, const char* name = NULL);
    ~MixerDialog();

    void setConfig(const MixerConfig&);
    const MixerConfig& getConfig() const;

 signals:
    
    void changed(const MixerConfig&);
    
 protected slots:

    void setMixerOff();
    void setHighQuality();
    void setFullPanning();
	
    void setEffectsOff();
    void setStereoSurround();
    void setCenteredPanning();

    void setVoice1Volume(int);
    void setVoice2Volume(int);
    void setVoice3Volume(int);
    void setVoice4Volume(int);
    void setVoice1Pan(int);
    void setVoice2Pan(int);
    void setVoice3Pan(int);
    void setVoice4Pan(int);
    void muteVoice1(bool);
    void muteVoice2(bool);
    void muteVoice3(bool);
    void muteVoice4(bool);
    void soloVoice1(bool);
    void soloVoice2(bool);
    void soloVoice3(bool);
    void soloVoice4(bool);

 private:

    bool changedSignalEnabled;
    void enableChangedSignal(bool);
    void emitChangedIfEnabled();
        
    MixerConfig config;
    
    QSlider* volSliders[_voices];
    QScrollBar* panSliders[_voices];
    QPushButton* muteButtons[_voices];
    QPushButton* soloButtons[_voices];
    QWidget* effectWidgets[_effects];

    bool dontTouchMuteButtons;
    int soloIsVoice;  // voice [1..voices] that is SOLO, else (-1)

    void enableVolumeControl(bool);
    void enableEffects(bool);
    void enablePanning(bool);
	
    void setMixerButtons(bool,bool,bool);
    void setEffectButtons(bool,bool,bool);
	
    void setButtons();
	void adjustMuteButtons();
	void adjustPanningSliders();
    
    void currentSoloButtonOff();
    void allMuteSoloButtonsOff();
    
	void muteVoice(int voice, bool val);
	void unMuteAllVoices();

	void newVoiceGain(int voice, int val);
	void newVoicePanPos(int voice, int leftLevel);

};

#endif  // MixerDialog_h
