#ifndef _XMMS_FULLSCREEN_H
#define _XMMS_FULLSCREEN_H 1

#include <gtk/gtk.h>
#include <gdk/gdkx.h>

typedef struct {
	gint width, height;
} xmms_fullscreen_mode_t;

gboolean xmms_fullscreen_available(Display *dpy);
gboolean xmms_fullscreen_init(GtkWidget *win);

gboolean xmms_fullscreen_enter(GtkWidget *win, gint *w, gint *h);
void xmms_fullscreen_leave(GtkWidget *win);

gboolean xmms_fullscreen_in(GtkWidget *win);
gboolean xmms_fullscreen_mark(GtkWidget *win);
void xmms_fullscreen_unmark(GtkWidget *win);

void xmms_fullscreen_cleanup(GtkWidget *win);

GSList *xmms_fullscreen_modelist(GtkWidget *win);
void xmms_fullscreen_modelist_free(GSList *modes);

#endif

