/*  XMMS - Cross-platform multimedia player
 *  Copyright (C) 1998-1999  Peter Alm, Mikael Alm, Olle Hallnas, Thomas Nilsson and 4Front Technologies
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "OSS.h"

void oss_get_volume(int *l, int *r)
{
	int fd, v, cmd, devs;
	gchar *devname;

	if (oss_cfg.mixer_device > 0)
		devname = g_strdup_printf("/dev/mixer%d", oss_cfg.mixer_device);
	else
		devname = g_strdup("/dev/mixer");
	fd = open(devname, O_RDONLY);
	g_free(devname);
	if (fd != -1)
	{
		ioctl(fd, SOUND_MIXER_READ_DEVMASK, &devs);
		if ((devs & SOUND_MASK_PCM) && (oss_cfg.use_master==0))
			cmd = SOUND_MIXER_READ_PCM;
		else if ((devs & SOUND_MASK_VOLUME) && (oss_cfg.use_master==1))
			cmd = SOUND_MIXER_READ_VOLUME;
		else
		{
			close(fd);
			return;
		}
		ioctl(fd, cmd, &v);
		*r = (v & 0xFF00) >> 8;
		*l = (v & 0x00FF);
		close(fd);
	}
}

void oss_set_volume(int l, int r)
{
	int fd, v, cmd, devs;
	gchar *devname;

	if (oss_cfg.mixer_device > 0)
		devname = g_strdup_printf("/dev/mixer%d", oss_cfg.mixer_device);
	else
		devname = g_strdup("/dev/mixer");
	fd = open(devname, O_RDONLY);
	g_free(devname);

	if (fd != -1)
	{
		ioctl(fd, SOUND_MIXER_READ_DEVMASK, &devs);
		if ((devs & SOUND_MASK_PCM) && (oss_cfg.use_master==0))
			cmd = SOUND_MIXER_WRITE_PCM;
		else if ((devs & SOUND_MASK_VOLUME) && (oss_cfg.use_master==1))
			cmd = SOUND_MIXER_WRITE_VOLUME;
		else
		{
			close(fd);
			return;
		}
		v = (r << 8) | l;
		ioctl(fd, cmd, &v);
		close(fd);
	}
}
