#include "config.h"

#include <xmms/plugin.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <gtk/gtk.h>
#include "echo.h"

static void init(void);
static void clear_buffer(void);
static void cleanup(void);
static int mod_samples(gpointer * d, gint length, AFormat afmt, gint srate, gint nch);

#define MAX_SRATE 50000
#define MAX_CHANNELS 2
#define BYTES_PS 2
#define BUFFER_SAMPLES (MAX_SRATE * MAX_DELAY / 1000)
#define BUFFER_SHORTS (BUFFER_SAMPLES * MAX_CHANNELS)
#define BUFFER_BYTES (BUFFER_SHORTS * BYTES_PS)

EffectPlugin secho_ep =
{
	NULL,
	NULL,
	"Pro-Logic Surround Echo Plugin " VERSION,
	init,
	cleanup,
	secho_about,
	secho_configure,
	mod_samples
};

short *buffer;
short *buffer2;
int secho_delay = 500, secho_feedback = 50, secho_volume = 50;
int w_ofs;
int old_srate, old_nch;

EffectPlugin *get_eplugin_info(void)
{
	return &secho_ep;
}

static void init(void)
{
	buffer = (short *) malloc(BUFFER_BYTES + 1);
	buffer2 = (short *) malloc(BUFFER_BYTES + 1);
	if (buffer == NULL)
	{
		perror("Buffer allocation");
		gtk_main_quit();
	}
	if (buffer2 == NULL)
	{
		perror("Buffer allocation");
		gtk_main_quit();
	}
	clear_buffer();
}

static void clear_buffer(void)
{
	bzero(buffer, BUFFER_BYTES);
	bzero(buffer2, BUFFER_BYTES);
	w_ofs = 0;		// short[] index

}

static void cleanup(void)
{
	free(buffer);
	free(buffer2);
}

static void range(int *v)
{
	if (*v < -32768)
		*v = -32768;
	if (*v > 32767)
		*v = 32767;
}

static int mod_samples(gpointer * d, gint length, AFormat afmt, gint srate, gint nch)
{
	int x, i, in, out, buf, tmp, r_ofs, left, right;
	int inl, inr, outl, outr, bufl, bufr;
	gint16 *data = (gint16 *)*d;

	if (!(afmt == FMT_S16_NE || (afmt == FMT_S16_LE && G_BYTE_ORDER == G_LITTLE_ENDIAN) || (afmt == FMT_S16_BE && G_BYTE_ORDER == G_BIG_ENDIAN)))
		return length;

	if (nch != old_nch || srate != old_srate)
	{
		clear_buffer();
		old_nch = nch;
		old_srate = srate;
	}

	r_ofs = w_ofs - (srate * secho_delay / 1000) * nch;
	if (r_ofs < 0)
		r_ofs += BUFFER_SHORTS;

	if (nch == 1)
	{
		for (i = 0; i < length / BYTES_PS; i++)
		{
			in = data[i];
			buf = buffer[r_ofs];
			out = in + buf * secho_volume / 100;
			buf = in + buf * secho_feedback / 100;
			range(&out);
			range(&buf);
			buffer[w_ofs] = buf;
			data[i] = out;
			tmp = data[i];
			if (++r_ofs >= BUFFER_SHORTS)
				r_ofs -= BUFFER_SHORTS;
			if (++w_ofs >= BUFFER_SHORTS)
				w_ofs -= BUFFER_SHORTS;
		}
	}
	else
	{
		short *datas = data;

		for (x = 0; x < length / BYTES_PS / 2; x++)
		{
			bufl = buffer[r_ofs];
			bufr = buffer2[r_ofs];
			left = bufl - bufr;
			right = bufr - bufl;
			bufl = left;
			bufr = right;

			inl = datas[x * 2];
			inr = datas[x * 2 + 1];
			outl = inl + bufl * secho_volume / 100;
			outr = inr + bufr * secho_volume / 100;
			bufl = inl + bufl * secho_feedback / 200;
			bufr = inr + bufr * secho_feedback / 200;
			range(&outl);
			range(&outr);
			range(&bufl);
			range(&bufr);
			buffer[w_ofs] = bufl;
			buffer2[w_ofs] = bufr;
			datas[x * 2] = outl;
			datas[x * 2 + 1] = outr;
			if (++r_ofs >= BUFFER_SHORTS)
				r_ofs -= BUFFER_SHORTS;
			if (++w_ofs >= BUFFER_SHORTS)
				w_ofs -= BUFFER_SHORTS;
		}
	}

	return length;
}
