/*
 *   xmcd - Motif(tm) CD Audio Player
 *
 *   Copyright (C) 1993-1999  Ti Kan
 *   E-mail: ti@amb.org
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef LINT
static char *_callback_c_ident_ = "@(#)callback.c	6.7 99/04/04";
#endif

#include "common_d/appenv.h"
#include "xmcd_d/xmcd.h"
#include "xmcd_d/widget.h"
#include "xmcd_d/callback.h"
#include "cddb_d/cddb.h"
#include "xmcd_d/dbprog.h"
#include "xmcd_d/wwwwarp.h"
#include "xmcd_d/cdfunc.h"
#include "xmcd_d/help.h"
#include "xmcd_d/hotkey.h"


extern appdata_t	app_data;
extern widgets_t	widgets;

STATIC Atom		delw;


/***********************
 *  internal routines  *
 ***********************/


/*
 * register_main_callbacks
 *	Register all callback routines for widgets in the main window
 *
 * Args:
 *	m - Pointer to the main widgets structure
 *	s - Pointer to the curstat_t structure
 *
 * Return:
 *	Nothing.
 */
STATIC void
register_main_callbacks(widgets_t *m, curstat_t *s)
{
	/* Main window callbacks */
	register_focus_cb(m->main.form, cd_shell_focus_chg, m->main.form);

	register_arm_cb(m->main.mode_btn, cd_tooltip_cancel, s);
	register_activate_cb(m->main.mode_btn, cd_mode, s);
	register_focuschg_ev(m->main.mode_btn);
	register_xingchg_ev(m->main.mode_btn);

	register_arm_cb(m->main.lock_btn, cd_tooltip_cancel, s);
	register_xingchg_ev(m->main.lock_btn);

	register_arm_cb(m->main.repeat_btn, cd_tooltip_cancel, s);
	register_xingchg_ev(m->main.repeat_btn);

	register_arm_cb(m->main.shuffle_btn, cd_tooltip_cancel, s);
	register_xingchg_ev(m->main.shuffle_btn);

	register_arm_cb(m->main.eject_btn, cd_tooltip_cancel, s);
	register_activate_cb(m->main.eject_btn, cd_load_eject, s);
	register_focuschg_ev(m->main.eject_btn);
	register_xingchg_ev(m->main.eject_btn);

	register_arm_cb(m->main.quit_btn, cd_tooltip_cancel, s);
	register_activate_cb(m->main.quit_btn, cd_quit_btn, s);
	register_focuschg_ev(m->main.quit_btn);
	register_xingchg_ev(m->main.quit_btn);

	register_xingchg_ev(m->main.disc_ind);
	register_xingchg_ev(m->main.track_ind);
	register_xingchg_ev(m->main.index_ind);
	register_xingchg_ev(m->main.time_ind);

	register_xingchg_ev(m->main.rptcnt_ind);
	register_xingchg_ev(m->main.dbmode_ind);
	register_xingchg_ev(m->main.progmode_ind);
	register_xingchg_ev(m->main.timemode_ind);
	register_xingchg_ev(m->main.playmode_ind);

	register_xingchg_ev(m->main.dtitle_ind);
	register_xingchg_ev(m->main.ttitle_ind);

	register_arm_cb(m->main.dbprog_btn, cd_tooltip_cancel, s);
	register_activate_cb(m->main.dbprog_btn, cd_dbprog, s);
	register_focuschg_ev(m->main.dbprog_btn);
	register_xingchg_ev(m->main.dbprog_btn);

	register_arm_cb(m->main.options_btn, cd_tooltip_cancel, s);
	register_activate_cb(m->main.options_btn, cd_options_popup, s);
	register_focuschg_ev(m->main.options_btn);
	register_xingchg_ev(m->main.options_btn);

	register_arm_cb(m->main.time_btn, cd_tooltip_cancel, s);
	register_activate_cb(m->main.time_btn, cd_time, s);
	register_focuschg_ev(m->main.time_btn);
	register_xingchg_ev(m->main.time_btn);

	register_arm_cb(m->main.ab_btn, cd_tooltip_cancel, s);
	register_activate_cb(m->main.ab_btn, cd_ab, s);
	register_focuschg_ev(m->main.ab_btn);
	register_xingchg_ev(m->main.ab_btn);

	register_arm_cb(m->main.sample_btn, cd_tooltip_cancel, s);
	register_activate_cb(m->main.sample_btn, cd_sample, s);
	register_focuschg_ev(m->main.sample_btn);
	register_xingchg_ev(m->main.sample_btn);

	register_arm_cb(m->main.keypad_btn, cd_tooltip_cancel, s);
	register_activate_cb(m->main.keypad_btn, cd_keypad_popup, s);
	register_focuschg_ev(m->main.keypad_btn);
	register_xingchg_ev(m->main.keypad_btn);

	register_arm_cb(m->main.wwwwarp_btn, cd_tooltip_cancel, s);
	register_activate_cb(m->main.wwwwarp_btn, wwwwarp_popup, s);
	register_focuschg_ev(m->main.wwwwarp_btn);
	register_xingchg_ev(m->main.wwwwarp_btn);

	register_valchg_cb(m->main.level_scale, cd_tooltip_cancel, s);
	register_valchg_cb(m->main.level_scale, cd_level, s);
	register_drag_cb(m->main.level_scale, cd_tooltip_cancel, s);
	register_drag_cb(m->main.level_scale, cd_level, s);
	register_xingchg_ev(m->main.level_scale);

	register_arm_cb(m->main.playpause_btn, cd_tooltip_cancel, s);
	register_activate_cb(m->main.playpause_btn, cd_play_pause, s);
	register_focuschg_ev(m->main.playpause_btn);
	register_xingchg_ev(m->main.playpause_btn);

	register_arm_cb(m->main.stop_btn, cd_tooltip_cancel, s);
	register_activate_cb(m->main.stop_btn, cd_stop, s);
	register_focuschg_ev(m->main.stop_btn);
	register_xingchg_ev(m->main.stop_btn);

	register_arm_cb(m->main.prevdisc_btn, cd_tooltip_cancel, s);
	register_activate_cb(m->main.prevdisc_btn, cd_chgdisc, s);
	register_focuschg_ev(m->main.prevdisc_btn);
	register_xingchg_ev(m->main.prevdisc_btn);

	register_arm_cb(m->main.nextdisc_btn, cd_tooltip_cancel, s);
	register_activate_cb(m->main.nextdisc_btn, cd_chgdisc, s);
	register_focuschg_ev(m->main.nextdisc_btn);
	register_xingchg_ev(m->main.nextdisc_btn);

	register_arm_cb(m->main.prevtrk_btn, cd_tooltip_cancel, s);
	register_activate_cb(m->main.prevtrk_btn, cd_prevtrk, s);
	register_focuschg_ev(m->main.prevtrk_btn);
	register_xingchg_ev(m->main.prevtrk_btn);

	register_arm_cb(m->main.nexttrk_btn, cd_tooltip_cancel, s);
	register_activate_cb(m->main.nexttrk_btn, cd_nexttrk, s);
	register_focuschg_ev(m->main.nexttrk_btn);
	register_xingchg_ev(m->main.nexttrk_btn);

	register_arm_cb(m->main.previdx_btn, cd_tooltip_cancel, s);
	register_activate_cb(m->main.previdx_btn, cd_previdx, s);
	register_focuschg_ev(m->main.previdx_btn);
	register_xingchg_ev(m->main.previdx_btn);

	register_arm_cb(m->main.nextidx_btn, cd_tooltip_cancel, s);
	register_activate_cb(m->main.nextidx_btn, cd_nextidx, s);
	register_focuschg_ev(m->main.nextidx_btn);
	register_xingchg_ev(m->main.nextidx_btn);

	register_arm_cb(m->main.rew_btn, cd_tooltip_cancel, s);
	register_arm_cb(m->main.rew_btn, cd_rew, s);
	register_disarm_cb(m->main.rew_btn, cd_rew, s);
	register_activate_cb(m->main.rew_btn, cd_rew, s);
	register_focuschg_ev(m->main.rew_btn);
	register_xingchg_ev(m->main.rew_btn);

	register_arm_cb(m->main.ff_btn, cd_tooltip_cancel, s);
	register_arm_cb(m->main.ff_btn, cd_ff, s);
	register_disarm_cb(m->main.ff_btn, cd_ff, s);
	register_activate_cb(m->main.ff_btn, cd_ff, s);
	register_focuschg_ev(m->main.ff_btn);
	register_xingchg_ev(m->main.ff_btn);

	/* Install WM_DELETE_WINDOW handler */
	add_delw_callback(
		m->toplevel,
		(XtCallbackProc) cd_exit,
		(XtPointer) s
	);
}


/*
 * register_keypad_callbacks
 *	Register all callback routines for widgets in the keypad window
 *
 * Args:
 *	m - Pointer to the main widgets structure
 *	s - Pointer to the curstat_t structure
 *
 * Return:
 *	Nothing.
 */
STATIC void
register_keypad_callbacks(widgets_t *m, curstat_t *s)
{
	int	i;

	register_focus_cb(m->keypad.form, cd_shell_focus_chg, m->keypad.form);

	/* Keypad popup callbacks */
	for (i = 0; i < 10; i++)
		register_activate_cb(m->keypad.num_btn[i], cd_keypad_num,
				     (long) i);

	register_activate_cb(m->keypad.clear_btn, cd_keypad_clear, s);
	register_activate_cb(m->keypad.enter_btn, cd_keypad_enter, s);

	register_valchg_cb(m->keypad.warp_scale, cd_warp, s);
	register_drag_cb(m->keypad.warp_scale, cd_warp, s);

	register_activate_cb(m->keypad.cancel_btn, cd_keypad_popdown, s);

	/* Install WM_DELETE_WINDOW handler */
	add_delw_callback(
		XtParent(m->keypad.form),
		(XtCallbackProc) cd_keypad_popdown,
		(XtPointer) s
	);
}


/*
 * register_options_callbacks
 *	Register all callback routines for widgets in the options window
 *
 * Args:
 *	m - Pointer to the main widgets structure
 *	s - Pointer to the curstat_t structure
 *
 * Return:
 *	Nothing.
 */
STATIC void
register_options_callbacks(widgets_t *m, curstat_t *s)
{
	register_focus_cb(m->options.form, cd_shell_focus_chg,
			  m->options.form);

	register_valchg_cb(m->options.bal_scale, cd_balance, s);
	register_drag_cb(m->options.bal_scale, cd_balance, s);

	register_activate_cb(m->options.balctr_btn, cd_balance_center, s);

	register_activate_cb(m->options.reset_btn, cd_options_reset, s);
	register_activate_cb(m->options.save_btn, cd_options_save, s);
	register_activate_cb(m->options.ok_btn, cd_options_popdown, s);

	/* Install WM_DELETE_WINDOW handler */
	add_delw_callback(
		XtParent(m->options.form),
		(XtCallbackProc) cd_options_popdown,
		(XtPointer) s
	);
}


/*
 * register_dbprog_callbacks
 *	Register all callback routines for widgets in the
 *	database/program window
 *
 * Args:
 *	m - Pointer to the main widgets structure
 *	s - Pointer to the curstat_t structure
 *
 * Return:
 *	Nothing.
 */
STATIC void
register_dbprog_callbacks(widgets_t *m, curstat_t *s)
{
	/* Database/program popup callbacks */
	register_focus_cb(m->dbprog.form, cd_shell_focus_chg, m->dbprog.form);

	register_activate_cb(m->dbprog.dlist_btn, dbprog_dlist, s);

	register_modvfy_cb(m->dbprog.dtitle_txt, dbprog_txtline_verify, s);
	register_valchg_cb(m->dbprog.dtitle_txt, dbprog_dtitle_new, s);
	register_activate_cb(m->dbprog.dtitle_txt, dbprog_dtitle_new, s);
	register_losefocus_cb(m->dbprog.dtitle_txt, dbprog_dtitle_new, s);

	register_activate_cb(m->dbprog.extd_btn, dbprog_extd, s);

	register_defaction_cb(m->dbprog.trk_list, dbprog_trklist_play, s);
	register_browsel_cb(m->dbprog.trk_list, dbprog_trklist_select, s);

	register_modvfy_cb(m->dbprog.ttitle_txt, dbprog_txtline_verify, s);
	register_valchg_cb(m->dbprog.ttitle_txt, dbprog_ttitle_new, s);
	register_activate_cb(m->dbprog.ttitle_txt, dbprog_ttitle_new, s);
	register_focus_cb(m->dbprog.ttitle_txt, dbprog_ttitle_focuschg, s);
	register_losefocus_cb(m->dbprog.ttitle_txt, dbprog_ttitle_focuschg, s);

	register_activate_cb(m->dbprog.extt_btn, dbprog_extt, TRUE);

	register_modvfy_cb(m->dbprog.pgmseq_txt, dbprog_pgmseq_verify, s);
	register_valchg_cb(m->dbprog.pgmseq_txt, dbprog_pgmseq_txtchg, s);

	register_activate_cb(m->dbprog.addpgm_btn, dbprog_addpgm, s);
	register_activate_cb(m->dbprog.clrpgm_btn, dbprog_clrpgm, s);

	register_valchg_cb(m->dbprog.rmtdsbl_btn, dbprog_rmtdsbl, s);
	register_activate_cb(m->dbprog.submit_btn, dbprog_submit, s);

	register_activate_cb(m->dbprog.savedb_btn, dbprog_save, s);
	register_activate_cb(m->dbprog.linkdb_btn, dbprog_link, s);
	register_activate_cb(m->dbprog.loaddb_btn, dbprog_load, s);
	register_activate_cb(m->dbprog.cancel_btn, dbprog_cancel, s);

	/* Install WM_DELETE_WINDOW handler */
	add_delw_callback(
		XtParent(m->dbprog.form),
		(XtCallbackProc) dbprog_cancel,
		(XtPointer) s
	);
}


/*
 * register_dlist_callbacks
 *	Register all callback routines for widgets in the disc list window
 *
 * Args:
 *	m - Pointer to the main widgets structure
 *	s - Pointer to the curstat_t structure
 *
 * Return:
 *	Nothing.
 */
STATIC void
register_dlist_callbacks(widgets_t *m, curstat_t *s)
{
	/* Disc list window callbacks */
	register_focus_cb(m->dlist.form, cd_shell_focus_chg, m->dlist.form);

	register_activate_cb(m->dlist.hist_btn, dbprog_dlist_mode, s);
	register_activate_cb(m->dlist.chgr_btn, dbprog_dlist_mode, s);

	register_defaction_cb(m->dlist.disc_list, dbprog_dlist_show, s);
	register_browsel_cb(m->dlist.disc_list, dbprog_dlist_select, s);

	register_activate_cb(m->dlist.show_btn, dbprog_dlist_show, s);
	register_activate_cb(m->dlist.goto_btn, dbprog_dlist_goto, s);
	register_activate_cb(m->dlist.del_btn, dbprog_dlist_delete, s);
	register_activate_cb(m->dlist.delall_btn, dbprog_dlist_delall, s);
	register_activate_cb(m->dlist.rescan_btn, dbprog_dlist_rescan, s);

	register_activate_cb(m->dlist.cancel_btn, dbprog_dlist_cancel, s);

	/* Install WM_DELETE_WINDOW handler */
	add_delw_callback(
		XtParent(m->dlist.form),
		(XtCallbackProc) dbprog_dlist_cancel,
		(XtPointer) s
	);
}


/*
 * register_extd_callbacks
 *	Register all callback routines for widgets in the extended
 *	disc information window
 *
 * Args:
 *	m - Pointer to the main widgets structure
 *	s - Pointer to the curstat_t structure
 *
 * Return:
 *	Nothing.
 */
STATIC void
register_extd_callbacks(widgets_t *m, curstat_t *s)
{
	/* Extended disc info window callbacks */
	register_focus_cb(m->dbextd.form, cd_shell_focus_chg, m->dbextd.form);

	register_valchg_cb(m->dbextd.disc_txt, dbprog_set_changed, s);

	register_activate_cb(m->dbextd.ok_btn, dbprog_extd_ok, s);
	register_activate_cb(m->dbextd.clear_btn, dbprog_extd_clear, s);
	register_activate_cb(m->dbextd.cancel_btn, dbprog_extd_cancel, s);

	/* Install WM_DELETE_WINDOW handler */
	add_delw_callback(
		XtParent(m->dbextd.form),
		(XtCallbackProc) dbprog_extd_cancel,
		(XtPointer) s
	);
}


/*
 * register_extt_callbacks
 *	Register all callback routines for widgets in the extended
 *	track information window
 *
 * Args:
 *	m - Pointer to the main widgets structure
 *	s - Pointer to the curstat_t structure
 *
 * Return:
 *	Nothing.
 */
STATIC void
register_extt_callbacks(widgets_t *m, curstat_t *s)
{
	/* Extended track info window callbacks */
	register_focus_cb(m->dbextt.form, cd_shell_focus_chg, m->dbextt.form);

	register_activate_cb(m->dbextt.prev_btn, dbprog_extt_prev, s);
	register_activate_cb(m->dbextt.next_btn, dbprog_extt_next, s);
	register_valchg_cb(m->dbextt.autotrk_btn, dbprog_extt_autotrk, s);

	register_valchg_cb(m->dbextt.trk_txt, dbprog_set_changed, s);

	register_activate_cb(m->dbextt.ok_btn, dbprog_extt_ok, s);
	register_activate_cb(m->dbextt.clear_btn, dbprog_extt_clear, s);
	register_activate_cb(m->dbextt.cancel_btn, dbprog_extt_cancel, s);

	/* Install WM_DELETE_WINDOW handler */
	add_delw_callback(
		XtParent(m->dbextt.form),
		(XtCallbackProc) dbprog_extt_cancel,
		(XtPointer) s
	);
}


/*
 * register_dirsel_callbacks
 *	Register all callback routines for widgets in the CD database
 *	directory selector window
 *
 * Args:
 *	m - Pointer to the main widgets structure
 *	s - Pointer to the curstat_t structure
 *
 * Return:
 *	Nothing.
 */
STATIC void
register_dirsel_callbacks(widgets_t *m, curstat_t *s)
{
	/* Directory selector popup callbacks */
	register_focus_cb(m->dirsel.form, cd_shell_focus_chg, m->dirsel.form);

	register_defaction_cb(m->dirsel.dir_list, dbprog_dirsel_ok, s);
	register_browsel_cb(m->dirsel.dir_list, dbprog_dirsel_select, s);

	register_activate_cb(m->dirsel.ok_btn, dbprog_dirsel_ok, s);
	register_activate_cb(m->dirsel.cancel_btn, dbprog_dirsel_cancel, s);

	/* Install WM_DELETE_WINDOW handler */
	add_delw_callback(
		XtParent(m->dirsel.form),
		(XtCallbackProc) dbprog_dirsel_cancel,
		(XtPointer) s
	);
}


/*
 * register_linksel_callbacks
 *	Register all callback routines for widgets in the CD database
 *	search-link window
 *
 * Args:
 *	m - Pointer to the main widgets structure
 *	s - Pointer to the curstat_t structure
 *
 * Return:
 *	Nothing.
 */
STATIC void
register_linksel_callbacks(widgets_t *m, curstat_t *s)
{
	/* Link selector popup callbacks */
	register_focus_cb(m->linksel.form, cd_shell_focus_chg, m->linksel.form);

	register_defaction_cb(m->linksel.link_list, dbprog_linksel_ok, s);
	register_browsel_cb(m->linksel.link_list, dbprog_linksel_select, s);

	register_activate_cb(m->linksel.ok_btn, dbprog_linksel_ok, s);
	register_activate_cb(m->linksel.cancel_btn, dbprog_linksel_cancel, s);

	/* Install WM_DELETE_WINDOW handler */
	add_delw_callback(
		XtParent(m->linksel.form),
		(XtCallbackProc) dbprog_linksel_cancel,
		(XtPointer) s
	);
}


/*
 * register_wwwwarp_callbacks
 *	Register all callback routines for widgets in the wwwwarp window
 *
 * Args:
 *	m - Pointer to the main widgets structure
 *	s - Pointer to the curstat_t structure
 *
 * Return:
 *	Nothing.
 */
STATIC void
register_wwwwarp_callbacks(widgets_t *m, curstat_t *s)
{
	/* wwwWarp window callbacks */
	register_focus_cb(m->wwwwarp.form, cd_shell_focus_chg,
			  m->wwwwarp.form);

	register_activate_cb(m->wwwwarp.help_btn, cd_help_popup, s);

	register_activate_cb(m->wwwwarp.go_btn, wwwwarp_go, s);
	register_activate_cb(m->wwwwarp.cancel_btn, wwwwarp_popdown, s);

	/* Install WM_DELETE_WINDOW handler */
	add_delw_callback(
		XtParent(m->wwwwarp.form),
		(XtCallbackProc) wwwwarp_popdown,
		(XtPointer) s
	);
}


/*
 * register_help_callbacks
 *	Register all callback routines for widgets in the help text
 *	display window
 *
 * Args:
 *	m - Pointer to the main widgets structure
 *	s - Pointer to the curstat_t structure
 *
 * Return:
 *	Nothing.
 */
STATIC void
register_help_callbacks(widgets_t *m, curstat_t *s)
{
	/* Help popup window callbacks */
	register_focus_cb(m->help.form, cd_shell_focus_chg, m->help.form);

	register_activate_cb(m->help.online_btn, help_topic_sel, NULL);
	register_activate_cb(m->help.about_btn, cd_about, s);
	register_activate_cb(m->help.cancel_btn, cd_help_cancel, s);

	/* Install WM_DELETE_WINDOW handler */
	add_delw_callback(
		XtParent(m->help.form),
		(XtCallbackProc) cd_help_cancel,
		(XtPointer) s
	);
}


/*
 * register_auth_callbacks
 *	Register all callback routines for widgets in the authorization
 *	window
 *
 * Args:
 *	m - Pointer to the main widgets structure
 *	s - Pointer to the curstat_t structure
 *
 * Return:
 *	Nothing.
 */
STATIC void
register_auth_callbacks(widgets_t *m, curstat_t *s)
{
	/* Authorization window callbacks */
	register_focus_cb(m->auth.form, cd_shell_focus_chg, m->auth.form);

	register_activate_cb(m->auth.name_txt, dbprog_auth_name, s);
	register_modvfy_cb(m->auth.pass_txt, dbprog_auth_password_vfy, s);
	register_activate_cb(m->auth.pass_txt, dbprog_auth_ok, s);

	register_activate_cb(m->auth.ok_btn, dbprog_auth_ok, s);
	register_activate_cb(m->auth.cancel_btn, dbprog_auth_cancel, s);

	/* Install WM_DELETE_WINDOW handler */
	add_delw_callback(
		XtParent(m->auth.form),
		(XtCallbackProc) dbprog_auth_cancel,
		(XtPointer) s
	);
}


/*
 * register_dialog_callbacks
 *	Register all callback routines for widgets in the dialog
 *	box windows
 *
 * Args:
 *	m - Pointer to the main widgets structure
 *	s - Pointer to the curstat_t structure
 *
 * Return:
 *	Nothing.
 */
STATIC void
register_dialog_callbacks(widgets_t *m, curstat_t *s)
{
	Widget	btn;

	/* Info, Warning, Fatal and DB Match dialog window callbacks */
	register_focus_cb(m->dialog.info, cd_shell_focus_chg,
			  m->dialog.info);
	register_focus_cb(m->dialog.warning, cd_shell_focus_chg,
			  m->dialog.warning);
	register_focus_cb(m->dialog.fatal, cd_shell_focus_chg,
			  m->dialog.fatal);
	register_focus_cb(m->dialog.dbmatch, cd_shell_focus_chg,
			  m->dialog.dbmatch);

	btn = XmMessageBoxGetChild(
		m->dialog.info,
		XmDIALOG_OK_BUTTON
	);
	register_activate_cb(btn, cd_info_ok, s);

	btn = XmMessageBoxGetChild(
		m->dialog.warning,
		XmDIALOG_OK_BUTTON
	);
	register_activate_cb(btn, cd_warning_ok, s);

	btn = XmMessageBoxGetChild(
		m->dialog.fatal,
		XmDIALOG_OK_BUTTON
	);
	register_activate_cb(btn, cd_fatal_ok, s);

	btn = XmMessageBoxGetChild(
		m->dialog.dbmatch,
		XmDIALOG_OK_BUTTON
	);
	register_activate_cb(btn, dbprog_rmtmatch_yes, s);

	btn = XmMessageBoxGetChild(
		m->dialog.dbmatch,
		XmDIALOG_CANCEL_BUTTON
	);
	register_activate_cb(btn, dbprog_rmtmatch_no, s);

	btn = XmMessageBoxGetChild(
		m->dialog.dbmatch,
		XmDIALOG_HELP_BUTTON
	);
	register_activate_cb(btn, dbprog_rmtmatch_stop, s);

	/* Install WM_DELETE_WINDOW handlers */
	add_delw_callback(
		XtParent(m->dialog.info),
		(XtCallbackProc) cd_info_ok,
		(XtPointer) s
	);
	add_delw_callback(
		XtParent(m->dialog.warning),
		(XtCallbackProc) cd_warning_ok,
		(XtPointer) s
	);
	add_delw_callback(
		XtParent(m->dialog.fatal),
		(XtCallbackProc) cd_fatal_ok,
		(XtPointer) s
	);
	add_delw_callback(
		XtParent(m->dialog.dbmatch),
		(XtCallbackProc) dbprog_rmtmatch_stop,
		(XtPointer) s
	);
}


/***********************
 *   public routines   *
 ***********************/


/*
 * set_delw_atom
 *	Set the WM_DELETE_WINDOW atom - called from post_realize_config()
 *
 * Args:
 *	a - The atom
 *
 * Return:
 *	Nothing.
 */
void
set_delw_atom(Atom a)
{
	delw = a;
}


/*
 * add_delw_callback
 *	Add a callback function for WM_DELETE_WINDOW.
 *
 * Args:
 *	w - Widget
 *	func - Callback function
 *	arg - Callback function argument
 *
 * Return:
 *	Nothing.
 */
void
add_delw_callback(Widget w, XtCallbackProc func, XtPointer arg)
{
	XmAddWMProtocolCallback(w, delw, func, arg);
}


/*
 * rm_delw_callback
 *	Remove a callback function for WM_DELETE_WINDOW.
 *
 * Args:
 *	w - Widget
 *	func - Callback function
 *	arg - Callback function argument
 *
 * Return:
 *	Nothing.
 */
void
rm_delw_callback(Widget w, XtCallbackProc func, XtPointer arg)
{
	XmRemoveWMProtocolCallback(w, delw, func, arg);
}


/*
 * register_callbacks
 *	Top-level function to register all callback routines
 *
 * Args:
 *	m - Pointer to the main widgets structure
 *	s - Pointer to the curstat_t structure
 *
 * Return:
 *	Nothing.
 */
void
register_callbacks(widgets_t *m, curstat_t *s)
{
	register_main_callbacks(m, s);
	register_keypad_callbacks(m, s);
	register_options_callbacks(m, s);
	register_dbprog_callbacks(m, s);
	register_dlist_callbacks(m, s);
	register_extd_callbacks(m, s);
	register_extt_callbacks(m, s);
	register_dirsel_callbacks(m, s);
	register_linksel_callbacks(m, s);
	register_wwwwarp_callbacks(m, s);
	register_help_callbacks(m, s);
	register_auth_callbacks(m, s);
	register_dialog_callbacks(m, s);
}


