/*

Sound audio library
   
Copyright (c) 1999 Pascal Hofstee & Alain Kalker
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

$Id: path.c,v 1.3 1999/10/16 11:55:43 daeron Exp $

*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <pwd.h>
#include <sys/param.h>
#include "wsound.h"

#define DEFAULTS_DIR	"/Defaults"
#define WMSOUND_DOMAIN	"WMSound"



char*
susergnusteppath(void)
{
	static char *path = NULL;
	char *gspath;
	int pathlen;
	
	if (!path) {
		gspath = getenv("GNUSTEP_USER_ROOT");
		if (gspath) {
			gspath = sexpandpath(gspath);
			pathlen = strlen(gspath) + 4;
			path = malloc(pathlen * sizeof(char));
			if (! path) 
				SErrorCode = SERR_NOMEMORY;
			else
				strcpy(path, gspath);
			free(gspath);
		} else {
			pathlen = strlen(sgethomedir()) + 10;
			path = malloc(pathlen);
			if (! path)
				SErrorCode = SERR_NOMEMORY;
			else {
				strcpy(path, sgethomedir());
				strcat(path, "/GNUstep");
			}
		}
	}
	return path;
}



char*
sgethomedir(void)
{
	char		*home = getenv("HOME");
	struct passwd	*user;
	
	if (home)
		return home;
	
	user = getpwuid(getuid());
	if (!user) {
		swarning("Could not get password entry for UID %i", getuid());
		return "/";
	}
	if (!user->pw_dir) {
		return "/";
	} else {
		return user->pw_dir;
	} 
}


char*
sgetuserhomedir(char *username)
{
	struct passwd *user;
	
	user = getpwnam(username);
	if (!user) {
		swarning("Could not get password entry for user %s", username);
		return NULL;
	}
	if (!user->pw_dir) {
		return "/";
	} else {
		return user->pw_dir;
	} 
}


char*
sexpandpath(char *path)
{
	char	buffer2[MAXPATHLEN];
	char	buffer[MAXPATHLEN];
	int	i;
	
	memset(buffer, 0, MAXPATHLEN);
	
	if (*path=='~') {
		char *home;
		
		path++;
		if (*path=='/' || *path==0) {
			home = sgethomedir();
			strcat(buffer, home);
		} else {
			int j;
			j = 0;
			while (*path!=0 && *path!='/') {
				buffer2[j++] = *path;
				buffer2[j] = 0;
				path++;
			}
			home = sgetuserhomedir(buffer2);
			if (!home)
				return NULL;
			strcat(buffer, home);
		}
	}
	
	i = strlen(buffer);
	
	while (*path!=0) {
		char *tmp;
	
		if (*path=='$') {
			int j = 0;
			path++;
			/* expand $(HOME) or $HOME style environment variables */
			if (*path=='(') {
				path++;
				while (*path!=0 && *path!=')') {
					buffer2[j++] = *(path++);
					buffer2[j] = 0;
				}
				if (*path==')')
					path++;
				tmp = getenv(buffer2);
				if (!tmp) {
					buffer[i] = 0;
					strcat(buffer, "$(");
					strcat(buffer, buffer2);
					strcat(buffer, ")");
					i += strlen(buffer2)+3;
				} else {
					strcat(buffer, tmp);
					i += strlen(tmp);
				}
			} else {
				while (*path!=0 && *path!='/') {
					buffer2[j++] = *(path++);
					buffer2[j] = 0;
				}
				tmp = getenv(buffer2);
				if (!tmp) {
					strcat(buffer, "$");
					strcat(buffer, buffer2);
					i += strlen(buffer2)+1;
				} else {
					strcat(buffer, tmp);
					i += strlen(tmp);
				}
			}
		} else {
			buffer[i++] = *path;
			path++;
		}
	}

	return strdup(buffer);
}


char*
getLocalConfigurationPath(void)
{
	char	*path;
	char	*gspath;

	gspath = susergnusteppath();
	path = malloc(strlen(gspath) + strlen(DEFAULTS_DIR) + strlen(WMSOUND_DOMAIN)+4);
	path = malloc(MAXPATHLEN * sizeof(char));
	if (! path) {
		SErrorCode = SERR_NOMEMORY;
		if (gspath)
			free(gspath);

		return NULL;
	}
	strcpy(path, gspath);
	strcat(path, DEFAULTS_DIR);
	strcat(path, "/");
	strcat(path, WMSOUND_DOMAIN);
	
	return path;
}



char*
getGlobalConfigurationPath(void)
{
	FILE	*fstream;
	char	*buffer;
	char	*result;
	
	buffer = malloc(MAXPATHLEN * sizeof(char));
	if (! buffer) {
		SErrorCode = SERR_NOMEMORY;
		return NULL;
	}
	fstream = popen("wmaker --global_defaults_path", "r");
	if ((!fstream) || (!fgets(buffer, MAXPATHLEN, fstream))) {
		swarning("wmaker --global_defaults_path failed!");
		if (buffer)
			free(buffer);
		return NULL;
	}
	if (fstream)
		pclose(fstream);
	
	/* If fgets returns with a '\n' at the end, replace it with '/'.
	 * Otherwise, just cat '/' to the string.
	 */
	if (strchr(buffer,'\n') > 0) {
		char *tmpbuffer = strchr(buffer, '\n');
		tmpbuffer[0] = '/';
	} else
		strcat(buffer, "/");
	
	strcat(buffer, WMSOUND_DOMAIN);
	result = strdup(buffer);
	free(buffer);

	return result; 
}

