/*

Sound audio library
   
Copyright (c) 1999 Pascal Hofstee & Alain Kalker
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

$Id: getsoundset.c,v 1.2 1999/07/24 22:01:13 daeron Exp $

*/

#include <wsound.h>

static  char *eventkeys[] = {
	"AppExit",
	"AppStart",
	"Hide",
	"Iconify",
	"Maximize",
	"UnMaximize",
	"Shade",
	"Startup",
	"UnHide",
	"DeIconify",
	"UnShade",
	NULL
};


char *ProgName;

int
main(int argc, char **argv) {
	proplist_t	soundset, key, val;
	char		*sndsetfile = NULL;
	int		i;
	
	ProgName = argv[0];
	SInitializeApplication(argv[0]);
	
	if (argc > 1) {
		if ((argc > 2) || strstr(argv[1], "-h")) {
			printf("usage: %s [<soundset file>]\n\r",ProgName);
			exit(1);
		}

		sndsetfile = argv[1];
	}
	
	SLoadConfig();
	soundset = PLMakeDictionaryFromEntries(NULL, NULL, NULL);
	
	for (i = 0; eventkeys[i] != NULL; i++) {
		key = PLMakeString(eventkeys[i]);
		val = PLGetDictionaryEntry(WMSoundDB, key);
		if (val)
			PLInsertDictionaryEntry(soundset, key, val);
		PLRelease(key);
		PLRelease(val);
	}

	if (sndsetfile) {
		PLSetFilename(soundset, PLMakeString(sndsetfile));
		PLSave(soundset, YES);
	}
	else
		puts(PLGetDescriptionIndent(soundset, 0));
	
	PLRelease(WMSoundDB);
	PLRelease(soundset);
	
	return 0;
}

