/*

Sound audio library
   
Copyright (c) 1999 Pascal Hofstee & Alain Kalker
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

$Id: wsoundserver.c,v 1.13 1999/10/09 09:37:03 daeron Exp $

*/

#include <dockapp.h>
#include <unistd.h>
#include "wsoundserver.h"
#include "wsoundserver.xpm"


char *displayName = "";
Bool done = False;

static DAProgramOption options[] = {
	{"-d", "--display", "display to use", DOString, False, {&displayName} }
};


static void buttonPress(int button, int state, int x, int y);




int
main (int argc, char **argv) {
	if (argc > 1) {
		if ((strcmp(argv[1], "--version") == 0) || (strcmp(argv[1], "-v") == 0) ) {
			printf("WSoundServer for %s version %s\n\r", DRIVER, VERSION);
			exit(1);
		}
	}
	
	SInitializeApplication(argv[0]);
	
	if (wssInitDisplay(argc, argv) >= 0)
		wssDispatchStartup();
	else
		sfatal(SMessageForError(SERR_NODISPLAY));
	
	wssProcessEvents();
	return 0;
}

int
wssInitDisplay (int argc, char **argv)
{
	GC	gc;
	Pixmap	pixmap;
	static unsigned d_width = 48;
	static unsigned d_height = 48;
	DACallbacks callbacks={NULL, buttonPress, NULL, NULL, NULL, NULL};
	
	DAParseArguments(argc, argv, options,
			sizeof(options)/sizeof(DAProgramOption),
			PACKAGE, PACKAGE);
	
	DAInitialize(displayName, "WMSoundServer", d_width, d_height, argc, argv);
	
	_XA_WINDOWMAKER_WM_FUNCTION = XInternAtom(DADisplay, "_WINDOWMAKER_WM_FUNCTION", False);

	protos[0] = _XA_WINDOWMAKER_WM_FUNCTION;
	
	XSetWMProtocols(DADisplay, DAWindow, protos, 1);
	
	DAMakePixmapFromData(wsoundserver_xpm, &pixmap, None, &d_width, &d_height);
	DASetPixmap(pixmap);
	gc = DefaultGC(DADisplay, DefaultScreen(DADisplay));
	
	DASetCallbacks(&callbacks);
	
	DAShow();

	return 0;
}

void
wssDispatchStartup (void)
{
	XEvent SoundEvent;
	
	SoundEvent.xclient.type		= ClientMessage;
	SoundEvent.xclient.message_type	= _XA_WINDOWMAKER_WM_FUNCTION;
	SoundEvent.xclient.format	= 32;
	SoundEvent.xclient.display	= DADisplay;
	SoundEvent.xclient.window	= DAWindow;
	SoundEvent.xclient.data.l[0]	= SEVNT_STARTUP;

	XSendEvent(DADisplay, DAWindow, False, NoEventMask, &SoundEvent);
	XFlush(DADisplay);
}

void
wssProcessEvents ()
{
	XEvent event;
	short int hadSuccess = 0;
	
	while (!done) {
		XNextEvent(DADisplay, &event);
		DAProcessEvent(&event);
		
		switch (event.type) {
			case Expose:
				break;
			case ClientMessage:
				{
					if (event.xclient.message_type == _XA_WINDOWMAKER_WM_FUNCTION) {
						if (SPlayEvent(event.xclient.data.l[0]) == -1) {
							/* Stop displaying "Could not open audio device" warning
							 * after we have at least once been successful in opening
							 * it. This prevents a lot of logfile spamming
							 */
							if ((SErrorCode != SERR_DEVOPEN) || hadSuccess == 0)
								swarning(SMessageForError(SErrorCode));

							SErrorCode = SERR_NONE;
						}
						else {
							if (hadSuccess < 2)
								hadSuccess++;
							if (hadSuccess == 1)
								swarning("audio playing successful ... disabled further \"could not open audio device\" warnings");
						}

						XSync(DADisplay, True);
					}
					break;
				}
		}
	}
}



static void
buttonPress(int button, int state, int x, int y)
{
	/* We clicked the close button */
	if ((x >= 36) && (y <= 12))
		done = True;
}

