/* Sound display/edit/etc
 *
 * a re-implementation in summer 1996 of my much-missed dpysnd -- the Foonly/SAIL/E/Mus10/Grnlib sound editor from ca 1983.
 * with much help from Douglas Young's "The X Window System, Programming and Applications with Xt" Prentice-Hall 1994.
 *
 * Snd code is split between the sound editor proper (every file without an 'x' in the name),
 * and anything that is specific to X/Motif.  To port to another window system, it should be 
 * sufficient to reimplement whatever is in snd-x*.h, and approximate the user interface in 
 * snd-x*.c.  Except for tempnam, the DAC stuff in snd-dac, and open/read (I like unbuffered IO), 
 * all the code is (or is thought to be) straight ANSI C.
 */

#include "snd.h"

#ifdef HAVE_FPU_CONTROL_H
  #include <fpu_control.h>
#endif

#if DEBUGGING
  void check_snd_commands(void);
#endif

static snd_state *state;                      /* global state info, carried around via callData arg in callbacks */

static void mus_error2snd(int type, char *msg)
{
  if (type != MUS_UNSUPPORTED_HEADER_TYPE)
    {
      if (type != MUS_NO_ERROR)
	{
	  snd_error(msg);
	  if (type == MUS_WRITE_ERROR)
	    set_snd_IO_error(SND_CANNOT_WRITE_DATA);
	}
#ifdef WITH_MUS_MODULE
      else fprintf(stderr,msg); /* scm_misc_error here causes segfaults for some reason */
#endif  
    }
}

#ifdef SGI
  #include <sys/fpu.h>
#endif

#if SND_AS_WIDGET
  snd_state *snd_main(int argc, char **argv)
#else
  #if HAVE_GUILE
    static void snd_main(int argc, char **argv)
  #else
    int main (int argc, char **argv)
  #endif
#endif
{
#ifdef SGI
  union fpc_csr f; f.fc_word = get_fpc_csr(); f.fc_struct.flush = 1; set_fpc_csr(f.fc_word);
#endif
#ifdef HAVE_FPU_CONTROL_H
  #if __GLIBC_MINOR__ < 1
    /* in linux there's <fpu_control.h> with __setfpucw which Clisp calls as __setfpucw(_FPU_IEEE); */
    /* this appears to be useful in getting rid of idiotic NaN's */
    __setfpucw(_FPU_IEEE);
  #else
    #ifndef __alpha__
      int __fpu_ieee = _FPU_IEEE;
      _FPU_SETCW(__fpu_ieee);
      /* this bugfix thanks to Paul Barton-Davis */
    #else
      int __fpu_ieee = 0;
    #endif
  #endif
#endif

  initialize_sndlib();
  mus_set_error_handler(mus_error2snd);

  state=(snd_state *)CALLOC(1,sizeof(snd_state));
  state->s_type = SND_STATE;

  /* if any of these is changed, remember to change parallel check in snd-main.c save_snd_state_options */
  state->Fft_Size = 256;
  state->Fft_Window = default_fft_window(NULL);
  state->Fft_Beta = 0.0;
  state->Fft_Style = NORMAL_FFT;
  state->Sinc_Width = 10;
  state->Speed_Tones = 12;
  state->Default_Amp = 1.0;
  state->Default_Contrast = 0.0;
  state->Default_Contrasting = 0;
  state->Default_Contrast_Amp = 1.0;
  state->Default_Expand_Length = .15;
  state->Default_Expand_Ramp = .4;
  state->Default_Expand_Hop = .05;
  state->Default_Reverb_Feedback = 1.09;
  state->Default_Reverb_Lowpass = 0.7;
  state->Default_Expand = 1.0;
  state->Default_Expanding = 0;
  state->Default_Speed = 1.0;
  state->Default_Reverbing = 0;
  state->Default_Filtering = 0;
  state->Default_Reverb_Scale = 0.0;
  state->Default_Reverb_Length = 1.0;
  state->Default_Filter_Order = 20;
  state->Default_Filter_dBing = 0;
  state->Reverb_Decay = 1.0; 
  state->Default_Output_Type = DEFAULT_OUTPUT_TYPE;
  state->Initial_X0 = 0.0;
  state->Initial_X1 = 0.1;
  state->Initial_Y0 = -1.0;
  state->Initial_Y1 = 1.0;
  state->Xmax = 0.0;
  state->Xmin = 0.0;
  state->Ymax = 1.0;
  state->Ymin = -1.0;
  state->Normalize_On_Open = 1;
  state->Auto_Resize = 1; 
  state->Auto_Update = 0; 
  state->Color_Cutoff = .003;
  state->Color_Scale = 1.0;
  state->Color_Inverted = 1;
  state->Zero_Pad = 0;
  state->Line_Size = 128;
  state->Ask_Before_Overwrite = 0;
  state->X_Axis_Style = X_IN_SECONDS;
  state->Wavo = 0;
  state->Wavo_Hop = 3;
  state->Wavo_Trace = 64;
  state->Spectro_Hop = 4;
  state->Spectro_X_Scale = 1.0;
  state->Spectro_Y_Scale = 1.0;
  state->Spectro_Z_Scale = 0.1;
  state->Spectro_Z_Angle = -2.0;
  state->Spectro_X_Angle = 90.0;
  state->Spectro_Y_Angle = 0.0;
  state->Color_Map = -1;
  state->Spectro_Cutoff = 1.0;
  state->Wavelet_Type = 0;
  state->Transform_Type = FOURIER;
  state->Show_Selection_Transform = 0;
  state->Dot_Size = 1;
  state->Vu_Size = 1.0;
  state->Vu_Font_Size = 1.0;
  state->Vu_Font = NULL;
  state->Speed_Style = SPEED_AS_FLOAT;
  state->Movies = 1;
  state->Normalize_Fft = 1;
  state->Fit_Data_On_Open = 0;
  state->Zoom_Focus_Style = FOCUS_ACTIVE;
  state->Save_State_On_Exit = 0;
  state->Graph_Style = GRAPH_LINES;
  state->Filter_Env_Order = 40;
  state->Mixer_Groups = 6;
  state->Mixer_Group_Max_Out_Chans = 4;
  state->Verbose_Cursor = 0;
  state->Temp_Dir = NULL;
  state->Eps_File = NULL;
  state->Listener_Prompt = ">";
  state->Mixer_Save_State_File = MIXER_SAVE_STATE_FILE;
  state->Show_Fft_Peaks = 0;
  state->Show_Y_Zero = 0;
  state->Show_Axes = 1;
  state->Show_Marks = 1;
#if (XmVERSION > 1)
  state->Show_Edit_History = 1;
  state->Edit_History_Width = 1;
#else
  state->Show_Edit_History = 0;
  state->Edit_History_Width = 0;
#endif
  state->Fft_Log_Magnitude = 0;
  state->Fft_Log_Frequency = 0;
  state->Channel_Style = CHANNELS_SEPARATE;
  state->Sound_Style = SOUNDS_VERTICAL;
  state->Audio_Output_Device = SNDLIB_DEFAULT_DEVICE;
#if DEBUGGING
  state->Trap_Segfault = 0;
#else
  state->Trap_Segfault = 1;
#endif
  state->Raw_Srate = 44100;
  state->Raw_Chans = 1;
  state->Raw_Format = SNDLIB_16_LINEAR;
  state->Raw_Type = NeXT_sound_file;
  state->Use_Raw_Defaults = 0;
  state->Print_Length = 12;
  state->Previous_Files_Sort = 0;
  state->Show_Mix_Consoles = 1;
  state->Show_Mix_Waveforms = 0;
  state->Mix_Waveform_Height = 20;
  state->Show_Usage_Stats = FALSE;
  state->Recorder_Autoload = 0;
  state->Recorder_Buffer_Size = 4096;
  state->Recorder_Out_Chans = 2;
  state->Recorder_Out_Format = SNDLIB_COMPATIBLE_FORMAT;
#ifdef SUN
  state->Recorder_In_Format = SNDLIB_8_MULAW;
  state->Recorder_Srate = 8000;
#else
  state->Recorder_In_Format = SNDLIB_COMPATIBLE_FORMAT;
  state->Recorder_Srate = 22050;
#endif
  state->Recorder_Trigger = 0.0;
  state->Recorder_Max_Duration = 1000000.0;
  state->Recorder_File = NULL;
  state->Save_State_File = "saved-snd.scm";
  state->Enved_Base = 1.0;
  state->Enved_Power = 3.0;
  state->Enved_Waving = 0;
  state->Enved_dBing = 0;
  state->Enved_Clipping = 0;
  state->Enved_Exping = 0;
  state->Enved_Target = AMPLITUDE_ENV;
  state->Prefix_Arg = 0;
#if (HAVE_OSS || HAVE_ALSA)
  #ifdef MKLINUX
     /* actually linuxppc */
     state->Dac_Size = 0;	
  #else
     state->Dac_Size = 256;
  #endif
#else
  state->Dac_Size = 1024;
#endif
  state->Corruption_Time = 60.0;
  state->Max_Regions = 16;
  state->Max_Fft_Peaks = 100;
  state->Max_Fft_Size = 0;
  allocate_regions(max_regions(state));

  state->min_dB = -60.0;
  state->lin_dB = 0.001;
  state->init_window_x = -1; state->init_window_y = -1; state->init_window_width = -1; state->init_window_height = -1;

  init_sound_file_extensions();

  state->viewing = 0;
  state->max_sounds = 4;                 /* expands to accomodate any number of files */
  state->stopped_explicitly = 0;
  state->selected_sound = NO_SELECTION;
  state->from_clm = 0;
  state->to_clm = 0;
  state->mx_sp = NULL;
  state->open_ctrls_height = 180;        /* just a first guess */
  state->sounds = (snd_info **)CALLOC(state->max_sounds,sizeof(snd_info *));
  state->print_choice = PRINT_SND;
  state->pending_open = NULL;
  state->listening = 0;
  state->open_hook_active = 0;
  state->close_hook_active = 0;
  state->fft_hook_active = 0;
  state->graph_hook_active = 0;
  state->exit_hook_active = 0;
  state->start_hook_active = 0;
  state->search_in_progress = 0;

  set_snd_IO_error(SND_NO_ERROR);
  state->eval_error = SND_NO_EVAL_ERROR;
  state->eval_error_info = NULL;

#if HAVE_GUILE
  g_initialize_gh(state);
  g_initialize_xgh(state);
  state->search_proc = SCM_UNDEFINED;
#endif
#if DEBUGGING
  check_snd_commands();
#endif

#ifdef SND_AS_WIDGET
  return(state);
#else
  snd_doit(state,argc,argv);

  #if (!HAVE_GUILE)
    return(0);
  #endif
#endif
}

#ifndef SND_AS_WIDGET
  #if HAVE_GUILE     
  int main(int argc, char *argv[])
   {
     gh_enter(argc,argv,snd_main);
     return(0);
   }
  #endif
#endif

snd_state *get_global_state(void) {return(state);} /* sigh */
