/* X-specific type/macro declarations */

#ifndef SND_X0_H_LOADED
#define SND_X0_H_LOADED

#if defined(HAVE_CONFIG_H)
  #include "config.h"
#endif
#include <Xm/XmAll.h>
#include <X11/keysym.h>

#if defined(LINUX) || defined(SCO5) || defined(UW2) || defined(SOLARIS) || defined(HPUX) || defined(ALPHA) || defined(WINDOZE)
  #define RESIZE_DIALOG 1
  /* these versions of Motif need to be told to allow a dialog to include resize controls */
#else
  #define RESIZE_DIALOG 0
#endif
 
#if defined(LINUX) || defined(SCO5) || defined(UW2) || defined(SOLARIS) || defined(HPUX) || defined(ALPHA) || defined(WINDOZE)
  #define MANAGE_DIALOG 1
  /* these versions of Motif need to "manage" a dialog before dealing with its children */
#else
  #define MANAGE_DIALOG 0
#endif

#if defined(SUN) || (defined(LINUX) && (!(defined(LESSTIF_VERSION))) && (!(defined(MKLINUX))))
  #define OVERRIDE_TOGGLE 1
  /* Metrolink Motif (Linux) defines control-button1 to be "take focus" -- this is not a good idea!! */
  /*    (without this override ctrl-button1 in a graph causes a segfault in Metrolink Motif because someone is calling XmProcessTraversal) */
#else
  #define OVERRIDE_TOGGLE 0
#endif

#if defined(LINUX) || defined(XPM)
  #define HAVE_XPM 1
#else
  #define HAVE_XPM 0
#endif

#if (!defined(HAVE_SELECTED_POSITION_COUNT)) 
  #if defined(SGI) || defined (LESSTIF_VERSION) || defined(SCO5) || defined(UW2) || defined(SOLARIS) || defined(HPUX) || defined(ALPHA) || defined(WINDOZE) || defined(NEXT)
    #define HAVE_SELECTED_POSITION_COUNT 0
  #else
    #define HAVE_SELECTED_POSITION_COUNT 1
  #endif
#endif

#if ((XmVERSION >= 2) && (XmREVISION >= 1))
  #define HAVE_PRINT_SHELL 1
#else
  #define HAVE_PRINT_SHELL 0
#endif

#ifdef SGI
  #define CLOSED_CTRLS_HEIGHT 22
#else
  #define CLOSED_CTRLS_HEIGHT 18
#endif

#define POINT_BUFFER_SIZE 4096
#define WITH_ARROWS 1
#define WITH_FW_BUTTONS 0

#ifdef WITH_BIG_COLORMAP
  #define GRAY_SCALES 512
#else
  #define GRAY_SCALES 64
#endif

#define ACTIVATABLE 1
#define NOT_ACTIVATABLE 0

#ifdef SGI
  #define LINE_MARGIN 10
  #define CONTROLS_MARGIN 0
#endif
#ifdef NEXT
  #define LINE_MARGIN 10
  #define CONTROLS_MARGIN 0
#endif

#if defined(LINUX) || defined(SCO5) || defined(UW2) || defined(SOLARIS) || defined(HPUX) || defined(ALPHA) || defined(WINDOZE)
  #define LINE_MARGIN 4
  #define CONTROLS_MARGIN 1
  #ifndef LESSTIF_VERSION
    #define TOGGLE_MARGIN 0
    #define NEED_TOGGLE_MARGIN 1
  #else
    #define NEED_TOGGLE_MARGIN 0
  #endif
#else
  #define NEED_TOGGLE_MARGIN 0
#endif

typedef struct {
  GC gc;
  Display *dp;
  Drawable wn;
  XFontStruct *label_font,*numbers_font;
} axis_context;

typedef struct {
  /* we need two versions of each GC because the selected channel's colors can be different from the unselected channels' */
  Widget *chan_widgets;
  XtWorkProcId fft_in_progress;
  axis_context *ax;
  int selected;
} chan_context;

typedef struct {
  Pixmap speed_r,speed_l,file_pix;
  XtWorkProcId env_in_progress;
  XtWorkProcId apply_in_progress;
  void *env_data;
  Widget *snd_widgets;
#if (XmVERSION > 1)
  Widget tab;
#endif
  void *flt;
  Widget dialog;
} snd_context;

typedef struct {
  XtAppContext mainapp;     
  Widget mainshell;
  Widget mainpane;
  Widget soundpane;
  Display *mdpy;
  XmFontList button_fontlist;
  XFontStruct *button_fontstruct;
  XmFontList bold_button_fontlist;
  XFontStruct *bold_button_fontstruct; 
  XmFontList listener_fontlist;
  XFontStruct *listener_fontstruct;
  XFontStruct *axis_label_fontstruct;
  XFontStruct *axis_numbers_fontstruct;
  XmFontList help_text_fontlist;
  XFontStruct *help_text_fontstruct;
  XmFontList tiny_fontlist;
  XFontStruct *tiny_fontstruct;

  Pixel white,black,red,yellow,green,light_blue,lighter_blue;
  Pixel data_color,selected_data_color,mark_color,graph_color,selected_graph_color,listener_color,cursor_color;
  Pixel basic_color,selection_color,zoom_color,position_color,highlight_color,enved_waveform_color,mix_waveform_color;
  Pixel mix_focus_color,text_focus_color,filter_waveform_color,mix_color,pushed_button_color,sash_color;

  GC basic_gc,selected_basic_gc,combined_basic_gc;        
  GC cursor_gc,selected_cursor_gc;      
  GC selection_gc,selected_selection_gc;
  GC erase_gc,selected_erase_gc;        
  GC mark_gc,selected_mark_gc;          
  GC mix_gc;           
  GC fltenv_basic_gc,fltenv_data_gc,speed_gc;

  XEvent *text_activate_event;
  Widget text_widget;
  Widget *dialogs;
  int dialog_list_size,ndialogs;
} state_context;

typedef struct {
  Widget graph;
  XPoint *p0,*p1;
  int lastpj;
} mix_context;

typedef struct {
  int inuse,chans_allocated,x,y,moving,active,state;
  void *owner;           /* pointer to current mixdata struct that is using this set of widgets */
  Widget *w;
} mixmark;

typedef struct {
  Pixmap off_label;
  Pixmap on_label;
  Pixmap clip_label;
  XFontStruct *label_font;
  float size;
} vu_label;


#define snd_ShiftMask ShiftMask
#define snd_LockMask LockMask
#define snd_ControlMask ControlMask
#ifndef SUN
  #define snd_MetaMask Mod1Mask
#else
  #define snd_MetaMask (Mod1Mask | Mod4Mask)
#endif

#endif
