#include "snd.h"

/* -------- GLOBAL FIND -------- */
/* 
 * the dialog stays around until dismissed by "Done".  Each click on "Find" runs the search again
 */

typedef struct {int n; int chans; int inc; chan_info **cps; snd_fd **fds; snd_fd **afs;} gfd;

static int prepare_global_search (chan_info *cp, void *g0)
{
  gfd *g = (gfd *)g0;
  g->cps[g->n] = cp;
  g->fds[g->n] = init_sample_read(cp->cursor+1,cp,READ_FORWARD);
  g->n++;
  return(0);
}

static int run_global_search (snd_state *ss, gfd *g)
{
  /* return 0 until success or all eof */
  /* if success, n=winner (as aref index), if eofs, n=-1 */
  int i,j,k;
#if HAVE_GUILE
  SCM res;
  snd_fd *sf;
#endif
  if (g->afs) next_samples_for_eval(g->afs);
  for (i=0;i<g->chans;i++)
    {
      if (g->cps[i])
	{
	  set_search_fd(g->fds[i]); 
	  next_sample_1(search_fd());  /* sets current value to current fs->data and post-increments */
#if HAVE_GUILE
	  if (gh_procedure_p(ss->search_proc))
	    {
	      sf = search_fd();
	      res = gh_call1(ss->search_proc,gh_double2scm((double)(SNDLIB_SNDFLT * sf->current_value)));
	      if (res == SCM_BOOL_T)
		{
		  g->n = i;
		  return(1);
		}
	    }
	  else
#endif
	  if (sop_eval(ss->search_tree))
	    {
	      g->n = i;
	      return(1);
	    }
	  if (read_sample_eof(search_fd()))
	    {
	      g->fds[i] = set_search_fd(free_snd_fd(search_fd()));
	      g->cps[i] = NULL;
	      k=0;
	      for (j=0;j<g->chans;j++) 
		{
		  if (g->cps[i]) 
		    {
		      k=1;
		      break;
		    }
		}
	      if (k == 0) /* all at eof */
		{
		  g->n = -1;
		  return(1);
		}
	    }
	}
    }
  g->inc++;
  return(0);
}

static char search_no_luck[128];

char *global_search(snd_state *ss)
{
  /* set up snd_fd for each active channel, 
   * tick each one forward until a match is found, 
   * update cursor/graph and report success (if any) in associated info window
   * subsequent runs (if no new text) repeat the search from the current locations
   */
  int chans,i,redisplay,passes = 0;
  gfd *fd;
  chan_info *cp;
  if (ss->search_in_progress) 
    {
      sprintf(search_no_luck,STR_search_in_progress);
      return(search_no_luck);
    }
  ss->search_in_progress = 1;
  chans = active_channels(ss,1);
  search_no_luck[0] = '\0';
  if (chans > 0)
    {
      fd = (gfd *)CALLOC(1,sizeof(gfd));
      fd->n = 0;
      fd->inc = 1;
      fd->chans = chans;
      fd->fds = (snd_fd **)CALLOC(chans,sizeof(snd_fd *));
      fd->cps = (chan_info **)CALLOC(chans,sizeof(chan_info *));
      map_over_chans(ss,prepare_global_search,(void *)fd);
      if (ss->search_tree)
	fd->afs = get_chans_needed_by_eval(ss,NULL,ss->search_tree,-1,READ_FORWARD);
      fd->afs = NULL;
      while (!(run_global_search(ss,fd)))
	{
	  passes++;
	  if (passes>=10000)
	    {
	      check_for_event(ss);
	      if (ss->stopped_explicitly) break;
	      passes = 0;
	      fd->n = -1;
	    }
	}
      if (fd->n == -1)
	{
	  if (ss->stopped_explicitly)
	    sprintf(search_no_luck,"search stopped");
	  else sprintf(search_no_luck,"%s: %s",ss->search_expr,STR_not_found);
	  /* printed by find_ok_callback in snd-xmenu.c */
	}
      else
	{
	  /* fd->n is winner, fd->inc is how far forward we searched from current cursor loc */
	  cp = fd->cps[fd->n];
	  cp->cursor += fd->inc;
	  /* now in its own info window show find state, and update graph if needed */
          cp->cursor_on = 1;
	  show_cursor_info(cp);
	  if ((cp->cursor >= graph_low_SAMPLE(cp)) && (cp->cursor <= graph_high_SAMPLE(cp))) 
	    redisplay  = CURSOR_IN_VIEW;
	  else redisplay = CURSOR_IN_MIDDLE;
	  handle_cursor(cp,redisplay);
	}
      ss->stopped_explicitly = 0;
      for (i=0;i<chans;i++) if (fd->cps[i]) free_snd_fd(fd->fds[i]);
      FREE(fd->fds);
      FREE(fd->cps);
      if (fd->afs) {free_chans_for_eval(fd->afs); FREE(fd->afs); fd->afs = NULL;}
      FREE(fd);
    }
  ss->search_in_progress = 0;
  return(search_no_luck);
}

static int cursor_find(snd_info *sp, chan_info *cp, int count, int end_sample)
{
  /* count>0 -> search forward, else back */
  int i,c,inc,passes=0;
  snd_fd **afs = NULL;
  snd_fd *sf;
  snd_state *ss;
#if HAVE_GUILE
  SCM res;
#endif
  ss = sp->state;
  if (ss->search_in_progress) 
    {
      report_in_minibuffer(sp,STR_search_in_progress);
      return(-1);
    }
  c=count;
  if (count > 0) 
    {
      i=cp->cursor+1; 
      inc = 1;
    }
  else 
    {
      i=cp->cursor-1;
      c=-c;
      inc = -1;
      end_sample--;
    }
  ss->search_in_progress = 1;
  set_search_fd(init_sample_read(i,cp,(count>0) ? READ_FORWARD : READ_BACKWARD));
  sf = search_fd();
  if (!sf)
    {
      ss->search_in_progress = 0;
      return(-1);
    }
  if (sp->search_tree)
    afs = get_chans_needed_by_eval(sp->state,cp,sp->search_tree,i,(count>0) ? READ_FORWARD : READ_BACKWARD);
  if (count > 0) set_search_fd_direction(1); else set_search_fd_direction(-1);
  while ((c>0) && (i != end_sample) && (!read_sample_eof(sf)))
    {
      if (count > 0)
	next_sample_1(sf);
      else previous_sample_1(sf);
      if (afs) 
	{
	  if (count > 0)
	    next_samples_for_eval(afs);
	  else previous_samples_for_eval(afs);
	}
#if HAVE_GUILE
      if (sp->search_tree)
	{
	  if (sop_eval(sp->search_tree)) {c--; if (c == 0) break;}
	}
      else
	{
	  res = gh_call1(sp->search_proc,gh_double2scm((double)(SNDLIB_SNDFLT * sf->current_value)));
	  if (res == SCM_BOOL_T) {c--; if (c == 0) break;}
	}
#else
      if (sop_eval(sp->search_tree)) {c--; if (c == 0) break;}
#endif
      i+=inc;
      passes++;
      if (passes>=10000)
	{
	  check_for_event(ss);
	  /* if user types C-s during an active search, we risk stomping on our current pointers */
	  if (ss->stopped_explicitly) break;
	  passes = 0;
	}
    }
  ss->stopped_explicitly = 0;
  set_search_fd(free_snd_fd(sf));
  if (afs) {free_chans_for_eval(afs); FREE(afs); afs = NULL;}
  ss->search_in_progress = 0;
  if (c != 0) return(-1); /* impossible sample number, so => failure */
  return(i);
}

static void get_find_expression(snd_info *sp, int count)
{
  /* clear previous ? */
  search_no_luck[0] = '\0';
  text_set_string(w_snd_info(sp),search_no_luck);
  make_button_label(w_snd_info_label(sp),STR_find_p);
  sp->minibuffer_on = 1;
  goto_minibuffer(sp);
  sp->searching = count;
}

int cursor_search(chan_info *cp, int count)
{
  int samp;
  snd_info *sp;
  char *s1,*s2;
  snd_state *ss;
  ss = cp->state;
  sp = cp->sound;
  if (ss->search_in_progress) 
    {
      report_in_minibuffer(sp,STR_search_in_progress);
      return(KEYBOARD_NO_ACTION);
    }
  if (sp->searching)
    {
#if HAVE_GUILE
      if ((!sp->search_tree) && (!(gh_procedure_p(sp->search_proc)))) return(CURSOR_IN_VIEW); /* no search expr */
#else
      if (!sp->search_tree) return(CURSOR_IN_VIEW); /* no search expr */
#endif
      if (count > 0)
	samp = cursor_find(sp,cp,count,current_ed_samples(cp));
      else samp = cursor_find(sp,cp,count,0);
      if (samp == -1) 
	{ 
	  sprintf(search_no_luck,"%s: %s",sp->search_expr,STR_not_found);
	  report_in_minibuffer(sp,search_no_luck);
	  return(CURSOR_IN_VIEW);
	}
      else
	{
	  sprintf(search_no_luck,"%s: y = %s %s %s (%d)",
		  sp->search_expr,
		  s1 = prettyf(sample(samp,cp),2),
		  STR_at,
		  s2 = prettyf((double)samp/(double)snd_SRATE(cp),2),
		  samp);
	  report_in_minibuffer(sp,search_no_luck);
	  FREE(s1);
	  FREE(s2);
	}
      cursor_moveto(cp,samp);
      if ((cp->cursor >= graph_low_SAMPLE(cp)) && (cp->cursor <= graph_high_SAMPLE(cp))) 
	return(CURSOR_IN_VIEW);
      else return(CURSOR_IN_MIDDLE);
    }
  else get_find_expression(sp,count);
  return(CURSOR_IN_VIEW);
}

int snd_find_1(chan_info *cp, char *c_expr, int start, int count_matches)
{
  snd_info *sp;
  snd_state *ss;
  int val = -1;
  int old_cursor,matches;
#if HAVE_GUILE
  SCM proc;
#endif
  if (count_matches) val = 0;
  if (cp) 
    {
      ss = cp->state;
      if (ss->search_in_progress) return(val);
      if (c_expr)
	{
	  old_cursor = cp->cursor;
	  cp->cursor = start;
	  sp = cp->sound;
	  sp->searching = 1;
	  if (sp->search_tree) {free_sop(sp->search_tree); sp->search_tree = NULL;}
	  if (sp->search_expr) FREE(sp->search_expr);
	  sp->search_expr = c_expr;
#if HAVE_GUILE
	  sp->search_proc = SCM_UNDEFINED;
	  proc = parse_proc(c_expr);
	  if (gh_procedure_p(proc))
	    sp->search_proc = proc;
	  else
#endif
	  sp->search_tree = sop_parse(c_expr,SEARCH_TREE);
#if HAVE_GUILE
	  if ((sp->search_tree) || (gh_procedure_p(sp->search_proc)))
#else
	  if (sp->search_tree)
#endif
	    {
	      if (count_matches)
		{
		  matches = 0;
		  while (1)
		    {
		      val = cursor_find(sp,cp,1,0);
		      if (val != -1)
			{
			  matches++;
			  cp->cursor = val;
			}
		      else break;
		    }
		  val = matches;
		}
	      else val = cursor_find(sp,cp,1,0);
	      if (sp->search_tree) {free_sop(sp->search_tree); sp->search_tree = NULL;}
#if HAVE_GUILE
	      sp->search_proc = SCM_UNDEFINED;
#endif
	    }
	  FREE(c_expr);
	  sp->search_expr = NULL;
	  sp->searching = 0;
	  cp->cursor = old_cursor;
	}
    }
  return(val);
}

