#!/bin/sh
# the next line restarts using tclsh \
exec tclsh8.0 "$0" "$@"

# Hostname of aserver.tcl, please edit host and port number

set host datan.speech.kth.se
set port 23654

if {[llength $argv] == 0} {
    puts {Usage: rplay.tcl file [host]}
    exit
}

# Open the sound file as a binary file

if [catch {set fd [open [lindex $argv 0]]} res] {
    puts $res
    exit
}
fconfigure $fd -translation binary

# Use specified host

if {[llength $argv] == 2} {
    set host [lindex $argv 1]
}

# Open binary socket connection to aserver.tcl

if [catch {set sock [socket $host $port]} res] {
    puts "Error: no aserver.tcl at $host:$port"
    exit
}
fconfigure $sock -translation binary -blocking 0

# Notify the server that a play operation is due

puts -nonewline $sock play

# Write data as long as the server can accept more

fileevent $sock writable PlayHandler

proc PlayHandler {} {
    global fd sock

    set data [read $fd 10000]
    puts -nonewline $sock $data
    if [eof $fd] {
	close $fd
	close $sock
	exit
    }
}

vwait forever
