#!/bin/sh
# the next line restarts using wish \
exec wish8.0 "$0" "$@"

# A cross-platform mixer application that adapts to the capabilities
# of the machine it runs on. Lots of functions on Linux - play volume on Win.

package require -exact snack 1.6

proc Update {} {
    global doMonitor
    audio update
    if $doMonitor { after 100 Update }
}
bind . <Configure> Update

pack [frame .f] -expand yes -fill both
pack [checkbutton .r -text Monitor -command Update -var doMonitor]

set i 0
foreach jack [audio mixers] {
    pack [frame .f.g$i -bd 1 -relief solid] -side left -expand yes -fill both
    pack [label .f.g$i.l -text $jack]
    if {[audio channels $jack] == "Mono"} {
	audio volume $jack v(r$jack)
    } else {
	audio volume $jack v(l$jack) v(r$jack)
	pack [scale .f.g$i.e -from 100 -to 0 -show no -var v(l$jack)] -side \
		left -expand yes -fill both
    }
    pack [scale .f.g$i.s -from 100 -to 0 -show no -var v(r$jack)] -expand yes\
	    -fill both
    incr i
}

pack [frame .f.f2] -side left

if {[audio inputs] != ""} {
    foreach jack [audio inputs] {
	audio input $jack v(in$jack)
	pack [checkbutton .f.f2.b$jack -text $jack -variable v(in$jack)] -anc w
    }
}
if {[audio outputs] != ""} {
    foreach jack [audio outputs] {
	audio output $jack v(in$jack)
	pack [checkbutton .f.f2.b$jack -text $jack -variable v(in$jack)] -anc w
    }
}
