/* item.h
 * - Line item Function Headers
 *
 * Copyright (c) 1999 Jack Moffitt, Barath Raghavan, and Alexander Havng
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __ICECAST_LINE_H
#define __ICECAST_LINE_H

typedef struct output_item_t {
	char *name;
	char *format;
	const void *value;
} item_t;

typedef enum {token_header = 0, token_footer = 1 } item_token_t;
typedef enum {list_start = 0, list_end = 1, list_item = 2, header = 3, list_caption = 4, plaintext = 5, list_set_item = 6} item_type_t;

void item_write_formatted_line (com_request_t *req, int type, item_type_t itype, int num, ...);
void item_write_type (com_request_t *req, int type, item_type_t itype, item_token_t token, const char *firstvalue);
void item_write_item (com_request_t *req, item_type_t itype, item_t *item);
void item_write_item_default (com_request_t *req, item_type_t itype, item_t *item);
void item_write_item_html (com_request_t *req, item_type_t itype, item_t *item);
item_t *item_create (const char *name, const char *format, const void *value);
void item_dispose (item_t *item);
void item_write_value (const com_request_t *req, const char *format, const char *buf, const void *value);

#endif


