#ifndef __CONFIG_H__
#define __CONFIG_H__
/************************************************************************/
/* 
 * Header:	CONFIG
 * Purpose:     to define configuration values for cdtool and cdctrl
 * Language/Compiler/O/S:   GCC 2.7.2
 * Author:      thomas insel 
 * Date:        1996
 * Revision History:
 * [from RCS]
 *
 * $Log: config.h,v $
 * Revision 1.6  1998/01/06 21:00:33  wadeh
 * Added DoCr, changes to fix cdeject crash.
 *
 * Revision 1.5  1997/12/30 23:02:42  wadeh
 * Config for beta 3
 *
 * Revision 1.4  1997/12/24 15:39:10  wadeh
 * Minor bug fixes:
 * 1) Fixed cdctrl eject command causing a signal 11.
 * 2) Fixed Makefile debug option to not strip symbols, can now debug.
 * 3) Added command.h and more prototypes, more documentation.
 * 4) Fixed read_hw to ralways return buffer, even on error.
 * ,
 *
 * Revision 1.3  1997/12/23 22:52:51  wadeh
 * 2.1 beta 1 release
 *
 * Revision 1.2  1997/12/23 21:39:39  wadeh
 * config for cdtool and cdctrl
 *
 *
 * Notes:
 * 1) Header and updates, Wade Hampton, 12/23/1997.
 *----------------------------------------------------------------------*/
/* TYPES- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* INCLUDE FILES- - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* CONSTANTS- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* IF NEEDED, UNCOMMENT THE APPROPRIATE LINE FOR YOUR CD-ROM */

/* #define CD_DEVICE "/dev/sonycd" * Sony */
/* #define CD_DEVICE "/dev/sr0"    * SCSI */
/* #define CD_DEVICE "/dev/mcd"    * Mitsumi */
/* #define CD_DEVICE "/dev/sbpcd"  * SoundBlaster Pro */

/* otherwise, assume a sensible default */
#ifndef CD_DEVICE
#  ifdef linux
#    define CD_DEVICE "/dev/cdrom"
#  elif defined sun
#    define CD_DEVICE "/dev/sr0"
#  else
#    error Please define CD_DEVICE in config.h
#  endif
#endif

/* This one here is needed for the multiple cdrom support
 * 1) [0-7] will be appended 
 * 2) Change to /dev/sbpcd if using SoundBlaster cd's on Linux
 * 3) Change to /dev/cdrom if using /dev/cdrom0, /dev/cdrom1, etc.
 */
#ifndef CD_DEVICE_BASE
#  ifdef linux
#    define CD_DEVICE_BASE "/dev/scd"
#  elif defined sun
#    define CD_DEVICE_BASE "/dev/sr"
#  else
#    error Please define CD_DEVICE in config.h
#  endif
#endif
/* #define CD_DEVICE_BASE "/dev/sr" -- original string */

/* version string printed with usage message */ 
#define VERSION_STRING \
 "CDTOOL 2.1.5 (c) 1994-8 Thomas Insel, et al.  Licensed under GPL."

/* general definitions */
#ifndef TRUE
  #define TRUE (1==1)
#endif

#ifndef FALSE
  #define FALSE (1==0)
#endif

#define DOCRLF 2
#define DOLF   1
#define DONADA 0

static inline void DoCr (int docr)
{
    if (docr == DOLF)
	fputc ('\n', stdout);
    else if (docr == DOCRLF) {
	fputc ('\r', stdout);
	fputc ('\n', stdout);
    }
}


 /* build-specific definitions */
#ifdef CDCTRL
#define EXIT(x) {fprintf(stderr,"Error_return=%d\n",x);return;}
#define PROGNAME cdctrl
#else
#define EXIT(x) exit(x)
#define PROGNAME cdtool
#endif

/* LOCAL DATA - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* EXTERNAL PROCEDURES- - - - - - - - - - - - - - - - - - - - - - - - - */
/* EXTERNAL DATA- - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* PROTOTYPES - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/*
 * 
 * "config.h" copyright 1994 thomas insel 
 */
/************************************************************************/
#endif



