.TH tkmidi 1 "March 1, 1998"
.LO 1
.SH NAME
tkmidi \- Tcl/Tk interface for drvmidi
.SH SYNOPSIS
tkmidi [options] files..
.SH DESCRIPTION
.B tkmidi
is an external interface program for AWE32 MIDI player, drvmidi(1).
This works just as Tcl/Tk interface of drvmidi except tkmidi uses
the general pipe interface to communicate with drvmidi.
All the long command line options starting double minus (--) are
passed to drvmidi, but short options are regarded as Tcl/Tk options.

Tkmidi accepts the directory as command line arguments.  It search the
files with .mid extension under the directory, and add them to the
file list.  For example, to play all midi files under the current
directory, you can start tkmidi as follows:
.in +1i
% tkmidi .
.in -1i

.SH "FILE MENU"
.TP
.B "Open File"
Open a MIDI file from the file selection window.
Not available during play midi files.
.TP
.B "Clear List"
Clear all MIDI songs selected in the list.
Not available during play midi files.
.TP
.B "Save Config"
Save the current configuration in user config file ~/.tkawe.
The play style, display style, volume parameters, chorus/reverb modes
are saved.  This file is read when starting tkmidi.
.TP
.B "Edit Options"
Edit option files in the selection list, or the system default options.
A file selection dialog appear when this menu is selected, then
choose a midi file from the file list.
Most of playing options can be set via option editor window.
If the corresponding midi option file doesn't exist, a new option file
is created, which name starts from period and has ".id" extension.
For example, when "foo.mid" is edited, an option file ".foo.id" will be
created on the current directory.
The system default option can be editted by selecting "Edit Default" in
file selection dialog.  The options are saved on the system
resource file, ~/.drvmidirc.
Note that the changed default options are activated when tkmidi is
inovked at next time.

.SH "MODE MENU"
.TP
.B Repeat
Play the first file again repeatedly after all files are played.
.TP
.B Shuffle
Shuffle play mode.  The order of the playing files is
shuffled and selected randomly.
.TP
.B "Auto Start"
Start playing midi files automatically when the program runs.
.TP
.B "Auto Exit"
Exit the program automatically when finishing all the files.
.TP
.B "Confirm Quit"
Pop up a dialog to confirm when the program is going to quit.

.SH "DISPLAY MENU"
This menu contains six toggle button items, File List, Time, Messages,
Volume, Buttons, and Trace.
Each item selects to display or remove the corresponding window.
The current display style can be saved by "Save Config".

.TP
.B File List
File list window displays all the MIDI files.
You can start or change the file currently playing by clicking the file name
in it.
.TP
.B Time
Time window displays the current time and total time, and a scale bar.
You can control the current time directly by dragging the thumb in the scale bar.
.TP
.B Messages
Message window displays messages in the MIDI file.
To clear the window, push "clear" button under the message window.
.TP
.B Volume
Volume window controls total and equalizer volumes.
The total volume can be changed by dragging the upper scale bar.
It varies from 0 to 200%.
Other two lower scale bars control bass and treble volumes.
The volume status will be saved by "Save Config" in File menu.
.TP
.B Buttons
Button window displays operational buttons to play, stop, previous,
backward, pause, forward, next, and quit.
Each button will be activated or disabled according the playing status.
.TP
.B Trace
Trace window display volume bars of each MIDI channel.
The red bar means the drum channel, and green bar means the normal one.
The yellow arrows under volume bars indicate the panning positions,
and the lower numbers indicate the preset number in hex.

.SH "CHORUS AND REVERB MENUES"
Change the current chorus and reverb modes immediately.
These modes may be changed according to MIDI sysex messages.
	
.SH "KEY BINDINGS"
.TP
.B Return
play
.TP
.B c
stop
.TP
.B "Space,s"
pause / continue
.TP
.B q
quit
.TP
.B n
next song
.TP
.B p
restart or previous song
.TP
.B r
restart
.TP
.B Right
forward two seconds
.TP
.B Left
backward two seconds
.TP
.B "Up,v"
volume up 5%
.TP
.B "Down,V"
volume down 5%
.TP
.B u
increase the base key
.TP
.B d
decrease the base key

.SH "OPTIONS"
All the long type options starting double minus '--' are passed
to drvmidi program.
The other short type options are parsed as Tcl/Tk options.
The following two short options are newly added as Tcl/Tk options.

.TP
.B "\-effect config-file"
Specify the path of configuration file for user defined chorus/reverb modes.
Note that the file is
.I NOT
searched along the soundfont path unlike setfx(1) program.
.TP
.B "\-mode style"
Set playing mode.
.B "shuffle, normal, autostart, autoexit"
and
.B repeat
can be specified as the playing mode style.

.SH "SEE ALSO"
drvmidi(1), sfxload(1), setfx(1).

.SH COPYRIGHT
Copyright (C) 1996-1998 Takashi Iwai.
.P
The AWE32 driver and utilities are free software; you can redistribute them
and/or modify them under the terms of the \fIGNU General Public
License\fP as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.
