/* gtk.c:  GTK+ interface for aumix
 * (c) 1998, 1999 the authors (see AUTHORS file)
 *
 * based on:
 * Freestyle DJ sample playing tool
 * Revision 1.11  1998/06/18 18:17:39
 * (C) 1998 Pete Hollobon hollobon@bigfoot.com
 * http://www.york.ac.uk/~ph116/freestyle.html
 *
 * also based on:
 * gmixer 0.98 (22.2.1999)
 * Copyleft (C) 1998, 1999 Sergey Kiselev
 * sergey@junior.technion.ac.il
 */

#include "../config.h"
#ifdef HAVE_GTK
#include "common.h"
#include "gtk.h"
#include "../data/aumix.xpm"
#include "interactive.h"

GtkAdjustment  *adjustment[SOUND_MIXER_NRDEVICES];

int             items[SOUND_MIXER_NRDEVICES], *itemp[SOUND_MIXER_NRDEVICES];

void            AdjustLevelGTK(int *device);

void            AdjustLevelGTK(int *device)
{
	int             i;
	for (i = 0; i < SOUND_MIXER_NRDEVICES; i++) {
		if (adjustment[i] == (GtkAdjustment *) device)
			break;
	}
	AdjustLevel(i, 0, adjustment[i]->value);
	return;
}

void            aumix_destroy(GtkWidget * widget, gpointer * data)
{
	gtk_widget_destroy(widget);
}

void            InitScreenGTK(void)
{
	GdkBitmap      *bitmap;
	GdkPixmap      *pixmap;
	GtkStyle       *style;
	GtkWidget      *window;
	GtkWidget      *levels[SOUND_MIXER_NRDEVICES];
	GtkWidget      *box;
	GtkWidget      *main_hbox;
	GtkWidget      *mutebox;
	GtkWidget      *widget;
	GtkWidget      *frame;
	GtkWidget      *levelframe[SOUND_MIXER_NRDEVICES];
	GtkWidget      *control_box;
	GtkWidget      *levelbox[SOUND_MIXER_NRDEVICES];
	GSList         *muting_group;
	int             i, tmp, left, right;
	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(window), "aumix");
	gtk_widget_set_usize(window, WINDOW_WIDTH, WINDOW_HEIGHT);
	gtk_signal_connect(GTK_OBJECT(window), "destroy",
			   GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
	gtk_container_border_width(GTK_CONTAINER(window), BORDER);
	box = gtk_vbox_new(FALSE, BORDER);
	gtk_widget_show(box);
	gtk_container_add(GTK_CONTAINER(window), box);
	for (i = 0; i < SOUND_MIXER_NRDEVICES; i++) {
		if ((1 << i) & devmask) {
			levelbox[i] = gtk_event_box_new();
			gtk_widget_show(levelbox[i]);
			levelframe[i] = gtk_frame_new(dev_label[i]);
			gtk_container_border_width(
						   GTK_CONTAINER(levelframe[i]), BORDER);
			gtk_widget_show(levelframe[i]);
		}
	}
	for (i = 0; i < SOUND_MIXER_NRDEVICES; i++) {
		if ((1 << i) & devmask) {
			gtk_container_add(GTK_CONTAINER(levelbox[i]),
					  levelframe[i]);
		}
	}
/* See rangewidgets example. */
	for (i = 0; i < SOUND_MIXER_NRDEVICES; i++) {
		if ((1 << i) & devmask) {
			if (SOUND_IOCTL(mixer_fd, MIXER_READ(i), &tmp) == -1)
				/* Try to read mixer. */
				gtk_exit(EREADMIX);
			right = tmp >> 8;
			left = tmp & 0xFF;
			adjustment[i] = GTK_ADJUSTMENT(gtk_adjustment_new(((right + left) / 2), 0, MAXLEVEL, 1, 1, 0));
			items[i] = i;
			itemp[i] = &items[i];
			gtk_signal_connect(GTK_OBJECT(adjustment[i]),
					   "value_changed", GTK_SIGNAL_FUNC(AdjustLevelGTK),
					   &adjustment[i]);
			levels[i] = gtk_hscale_new(adjustment[i]);
			gtk_scale_set_digits(GTK_SCALE(levels[i]), 0);
			gtk_widget_show(levels[i]);
			gtk_container_add(GTK_CONTAINER(levelframe[i]),
					  levels[i]);
			gtk_range_set_update_policy(GTK_RANGE(levels[i]),
						    GTK_UPDATE_CONTINUOUS);
		}
	}
	main_hbox = gtk_hbox_new(FALSE, 0);
	control_box = gtk_hbox_new(FALSE, BORDER);
	gtk_widget_show(control_box);
	frame = gtk_frame_new("muting");
	gtk_widget_show(frame);
	mutebox = gtk_hbox_new(FALSE, BORDER);
	gtk_container_border_width(GTK_CONTAINER(mutebox), BORDER);
	gtk_widget_show(mutebox);
	gtk_container_add(GTK_CONTAINER(frame), mutebox);
	widget = gtk_radio_button_new_with_label(NULL, "none");
	gtk_signal_connect(GTK_OBJECT(widget), "clicked",
			   GTK_SIGNAL_FUNC(UnmuteAllGTK), (gpointer) "none");
	gtk_widget_show(widget);
	gtk_box_pack_start(GTK_BOX(mutebox), widget, TRUE, TRUE, BORDER);
	muting_group = gtk_radio_button_group(GTK_RADIO_BUTTON(widget));
	widget = gtk_radio_button_new_with_label(muting_group, "global");
	gtk_signal_connect(GTK_OBJECT(widget), "clicked",
			   GTK_SIGNAL_FUNC(MuteAllGTK), (gpointer) "global");
	gtk_widget_show(widget);
	gtk_box_pack_start(GTK_BOX(mutebox), widget, TRUE, TRUE, BORDER);
	muting_group = gtk_radio_button_group(GTK_RADIO_BUTTON(widget));
	gtk_box_pack_start(GTK_BOX(control_box), frame, TRUE, TRUE, 0);
	for (i = 0; i < SOUND_MIXER_NRDEVICES; i++) {
		if ((1 << i) & devmask) {
			gtk_box_pack_start(GTK_BOX(box), levelbox[i], TRUE,
					   TRUE, 0);
		}
	}
	gtk_box_pack_start(GTK_BOX(box), control_box, TRUE, TRUE, 0);
	gtk_widget_realize(window);
	style = gtk_widget_get_style(window);
	pixmap = gdk_pixmap_create_from_xpm_d(window->window, &bitmap,
					      &style->bg[GTK_STATE_NORMAL], aumix_xpm);
	gdk_window_set_icon(window->window, NULL, pixmap, bitmap);
	gtk_widget_show(window);
}

void            KeysBoxGTK(void)
{				/* to do */
}

void            ShowMutingGTK(void)
{				/* to do */
}

void            DrawLevelBalModeGTK(int dev, int mode)
{				/* to do */
}

void            DrawLevelGTK(int dev)
{				/* to do */
}

void            EraseLevelGTK(int dev)
{				/* to do */
}

void            RedrawBalanceGTK(int dev)
{				/* to do */
}

void            DrawRecordPlayGTK(int dev)
{				/* to do */
}

void            CloseScreenGTK(void)
{
	gtk_exit(0);
	return;
}

void            MuteAllGTK(GtkWidget * w, gpointer * data)
{
	MuteAll();
	mutestate = -1;
	return;
}

void            UnmuteAllGTK(GtkWidget * w, gpointer * data)
{
	UnmuteAll();
	mutestate = 0;
	return;
}
#endif
