proc ndef { var } {
	global $var
	catch { put [set $var] } msg
	if { $msg !="" } { return 1 }
	return 0
	}

proc defifndef { var value } {
	global $var
	if { [ndef $var]} { set $var $value }
	}

proc def { var } {
	global $var
	catch { put [set $var] } msg
	if { $msg =="" } { return 1 }
	return 0
	}

proc set_current { name win value } {
#ex: C_HOST .hosts COOL_HOST
	global $name
	set $name $value
	$win tag remove curr 1.0 end
	set index [$win search -exact " $value " 1.0]
	catch { $win tag add curr "$index linestart +1 chars" "$index lineend -1 chars" }
	}
	
proc get_sysinfo {} {
   global smbmountVer smbmountVariant smbmountNew launcher_path kfmclient_path
   set smbmountVer 0
   set smbmountVariant 1
   set kfmclient_path ""
   set launcher_path ""

   if { [ exec uname -s ] == "Linux" } {
      puts "System is Linux"
	 if { [exec uname -r] >"2.1.0" } {
	      puts "Kernel >2.0.XX, Using new smbmount"
	      set smbmountVer 2
	      } {
	      puts "Kernel is 2.0.XX, Using old smbmount"
	      set smbmountVer 1
	      }
      }
   if { $smbmountVer == 2 } {
      puts "Trying to check call format of $smbmountNew (smbmount 2.2.x)"
      spawn $smbmountNew -v
      set id $spawn_id
      set repeat 0
      expect {
	 -i $id "c command string" { 
	 set smbmountVariant 2
	 }
      }
      catch { close -i $id }
      wait i $id
   }
   puts "Selected Variant of smbmount is $smbmountVariant"

   catch {
   	set launcher_path [ exec which launcher ]
	puts "LAUNCHER: $launcher_path"
   }
   catch {
   	set kfmclient_path [ exec which kfmclient ]
   	puts "KFMCLIENT: $kfmclient_path"
   }
}

proc view { file } {
   global kfmclient_path launcher_path USE_KFM USE_LAUNCHER
   if { $kfmclient_path != "" && $USE_KFM == "Yes" } {
	catch { system $kfmclient_path exec "$file" }
   } else {
       if { $launcher_path != "" && $USE_LAUNCHER == "Yes" } {
           catch { system $launcher_path -nowait "$file" }
       }
   }
}
